<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek parameter
if (!isset($_GET['id']) || !isset($_GET['tanggal'])) {
    header("Location: index.php");
    exit();
}

$id_surat = $_GET['id'];
$tanggal = $_GET['tanggal'];

// Ambil data surat tugas
$query_st = "SELECT * FROM surat_tugas WHERE id_surat = ?";
$stmt_st = mysqli_prepare($conn, $query_st);
mysqli_stmt_bind_param($stmt_st, "i", $id_surat);
mysqli_stmt_execute($stmt_st);
$result_st = mysqli_stmt_get_result($stmt_st);
$surat_tugas = mysqli_fetch_assoc($result_st);

// Query untuk mengambil data peserta dan status absensi
$query = "SELECT p.*, 
    (SELECT MAX(tanggal) FROM absensi_sppd 
     WHERE id_pegawai = p.id_pegawai 
     AND id_surat_tugas = ? 
     AND tanggal = ?) as absen_date,
    (SELECT jam FROM absensi_sppd 
     WHERE id_pegawai = p.id_pegawai 
     AND id_surat_tugas = ? 
     AND tanggal = ?) as jam_absen
    FROM pegawai p 
    JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
    WHERE dst.id_surat = ?
    ORDER BY 
        CASE 
            WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 1
            WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
            WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 3
            WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
            WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 5
            ELSE 6
        END,
        CASE 
            WHEN p.golongan LIKE '%IV/C%' THEN 1
            WHEN p.golongan LIKE '%IV/B%' THEN 2
            WHEN p.golongan LIKE '%IV/A%' THEN 3
            WHEN p.golongan LIKE '%III/D%' THEN 4
            WHEN p.golongan LIKE '%III/C%' THEN 5
            WHEN p.golongan LIKE '%III/B%' THEN 6
            WHEN p.golongan LIKE '%III/A%' THEN 7
            WHEN p.golongan LIKE '%II/D%' THEN 8
            WHEN p.golongan LIKE '%II/C%' THEN 9
            WHEN p.golongan LIKE '%II/B%' THEN 10
            WHEN p.golongan LIKE '%II/A%' THEN 11
            ELSE 12
        END,
        p.nama_pegawai";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "ssisi", $id_surat, $tanggal, $id_surat, $tanggal, $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Format tanggal Indonesia dengan hari
function tanggal_indo($tanggal) {
    $hari = array(
        'Sunday' => 'Minggu',
        'Monday' => 'Senin',
        'Tuesday' => 'Selasa',
        'Wednesday' => 'Rabu',
        'Thursday' => 'Kamis',
        'Friday' => 'Jumat',
        'Saturday' => 'Sabtu'
    );
    
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    $nama_hari = $hari[date('l', strtotime($tanggal))];
    return $nama_hari . ', ' . $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Tambahkan fungsi untuk format nama dengan gelar
function format_nama_dengan_gelar($nama) {
    // Pisahkan nama berdasarkan koma untuk memisahkan gelar belakang
    $parts = explode(',', $nama);
    $nama_depan = $parts[0];
    
    // Pisahkan gelar depan (H., Dr., dll) dari nama
    $nama_parts = explode(' ', $nama_depan);
    $formatted_parts = [];
    
    foreach ($nama_parts as $part) {
        // Cek apakah bagian ini adalah gelar depan
        if (preg_match('/^(H\.|Dr\.|Ir\.|Drs\.|Hj\.)$/i', $part)) {
            $formatted_parts[] = $part; // Biarkan gelar dalam format asli
        } else {
            $formatted_parts[] = strtoupper($part); // Ubah nama menjadi kapital
        }
    }
    
    $nama_formatted = implode(' ', $formatted_parts);
    
    // Jika ada gelar belakang (setelah koma), tambahkan kembali
    if (isset($parts[1])) {
        $nama_formatted .= ',' . $parts[1]; // Biarkan gelar belakang dalam format asli
    }
    
    return $nama_formatted;
}

// Tambahkan fungsi untuk format pangkat/golongan
function format_pangkat_golongan($text) {
    // Pisahkan teks dalam kurung
    if (preg_match('/^(.+?)\s*(\(.+?\))$/', $text, $matches)) {
        $pangkat = ucwords(strtolower($matches[1]));
        $golongan = $matches[2]; // Pertahankan format golongan dalam kurung
        return $pangkat . ' ' . $golongan;
    }
    // Jika tidak ada kurung, langsung convert ke title case
    return ucwords(strtolower($text));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Daftar Hadir - <?= tanggal_indo($tanggal) ?></title>
    <style>
        @page {
            size: A4;
            margin: 0.5cm 1cm 1cm 1cm;
        }
        body {
            font-family: Arial, sans-serif;
            line-height: 1.5;
            margin: 0;
            padding: 0;
        }
        .kop-surat {
            text-align: center;
            margin-bottom: 20px;
            padding-top: 0;
        }
        .kop-surat img {
            width: 100%;
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
        }
        .content {
            padding: 0 20px;
        }
        .content h4 {
            text-align: center;
            margin-bottom: 20px;
            font-size: 11pt;
            font-weight: normal;
        }
        .content p {
            margin: 5px 0;
            font-size: 11pt;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 11pt;
        }
        table, th, td {
            border: 1px solid #000;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f8f8f8;
            font-weight: bold;
        }
        td {
            vertical-align: top;
        }
        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 11pt;
        }
        .footer p {
            line-height: 1.6;
        }
        .nip-text {
            font-size: 9pt;
            color: #333;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            .content {
                margin-top: 0;
            }
        }
    </style>
</head>
<body>
    <div class="kop-surat">
        <img src="../assets/img/kop/kopdinas.png" alt="Kop Surat">
    </div>

    <div class="content">
        <h4>DAFTAR HADIR<br>
            <?= htmlspecialchars($surat_tugas['maksud']) ?><br>
    </h4>
        <p> Hari dan Tanggal: <?= tanggal_indo($tanggal) ?></p>
        <p>Lokasi           : <?= htmlspecialchars($surat_tugas['tempat_kegiatan']) ?></p>

        <table>
            <thead>
                <tr>
                    <th style="width: 5%; text-align: center;">No</th>
                    <th style="width: 40%;">Nama/NIP</th>
                    <th style="width: 15%;">Jabatan</th>
                    <th style="width: 15%;">Unit Kerja</th>
                    <th style="width: 10%; text-align: center;">Jam Absen</th>
                    <th style="width: 15%; text-align: center;">Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $no = 1;
                while ($peserta = mysqli_fetch_assoc($result)): 
                    $status = $peserta['jam_absen'] ? 'Hadir' : 'Tidak Hadir';
                    $status_class = $peserta['jam_absen'] ? 'text-success' : 'text-danger';
                ?>
                <tr>
                    <td style="text-align: center;"><?= $no++ ?></td>
                    <td>
                        <?= format_nama_dengan_gelar(htmlspecialchars($peserta['nama_pegawai'])) ?><br>
                        <span class="nip-text"><?= format_pangkat_golongan(htmlspecialchars($peserta['golongan'])) ?></span><br>
                        <span class="nip-text">NIP. <?= htmlspecialchars($peserta['nip']) ?></span>
                    </td>
                    <td><?= htmlspecialchars($peserta['jabatan']) ?></td>
                    <td><?= htmlspecialchars($peserta['unit_kerja']) ?></td>
                    <td style="text-align: center;"><?= $peserta['jam_absen'] ? date('H:i', strtotime($peserta['jam_absen'])) : '-' ?></td>
                    <td style="text-align: center;" class="<?= $status_class ?>"><?= $status ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; font-size: 16px; cursor: pointer;">
            Cetak Daftar Hadir
        </button>
    </div>
</body>
</html> 