<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Fungsi untuk generate QR code menggunakan API QR Server
function generateQRCode($text) {
    // Menggunakan layanan QR Code generator yang masih aktif
    $apiUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($text);
    return $apiUrl;
}

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek parameter id surat tugas
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id_surat = $_GET['id'];

// Ambil data surat tugas
$query_st = "SELECT * FROM surat_tugas WHERE id_surat = ?";
$stmt_st = mysqli_prepare($conn, $query_st);
mysqli_stmt_bind_param($stmt_st, "i", $id_surat);
mysqli_stmt_execute($stmt_st);
$result_st = mysqli_stmt_get_result($stmt_st);
$surat_tugas = mysqli_fetch_assoc($result_st);

if (!$surat_tugas) {
    header("Location: index.php");
    exit();
}

// Ambil data peserta
$query_peserta = "SELECT p.* FROM pegawai p 
                  JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
                  WHERE dst.id_surat = ?
                  ORDER BY p.nama_pegawai";
$stmt_peserta = mysqli_prepare($conn, $query_peserta);
mysqli_stmt_bind_param($stmt_peserta, "i", $id_surat);
mysqli_stmt_execute($stmt_peserta);
$result_peserta = mysqli_stmt_get_result($stmt_peserta);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak ID Card - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            @page {
                size: A4;
                margin: 0;
            }
            body {
                margin: 1cm;
            }
            .no-print {
                display: none !important;
            }
        }

        .id-card {
            width: 9cm;
            height: 5.5cm;
            border: 1px solid #ddd;
            border-radius: 10px;
            padding: 15px;
            margin: 10px;
            float: left;
            background: url('../assets/img/logo1.jpeg');
            background-size: cover;
            background-position: center;
            color: white;
            position: relative;
            overflow: hidden;
            page-break-inside: avoid;
        }

        .id-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }

        .id-card-content {
            position: relative;
            z-index: 2;
            display: flex;
            height: 100%;
        }

        .id-card-left {
            flex: 1;
            padding-right: 15px;
        }

        .id-card-right {
            width: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .id-card-header {
            text-align: left;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
            background: rgba(0, 0, 0, 0.3);
            padding: 5px;
            border-radius: 5px;
        }

        .id-card-header h3 {
            font-size: 16px;
            margin: 0;
            font-weight: bold;
            text-transform: uppercase;
        }

        .id-card-body {
            font-size: 12px;
            padding-top: 5px;
        }

        .id-card-body p {
            margin: 5px 0;
            background: rgba(0, 0, 0, 0.3);
            padding: 5px;
            border-radius: 3px;
        }

        .id-card-qr {
            background: white;
            padding: 5px;
            border-radius: 5px;
            width: 100px;
            height: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .id-card-qr img {
            width: 90px;
            height: 90px;
        }

        .print-controls {
            position: fixed;
            top: 20px;
            right: 20px;
            background: white;
            padding: 15px;
            border-radius: 10px;
            z-index: 1000;
        }

        .btn-print {
            background: #0ea5e9;
            border: none;
            color: white;
            padding: 8px 20px;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-print:hover {
            background: #0284c7;
        }

        .btn-back {
            background: #64748b;
            margin-right: 10px;
        }

        .btn-back:hover {
            background: #475569;
        }

        .logo-instansi {
            width: 30px;
            height: 30px;
            object-fit: contain;
        }
    </style>
</head>
<body>
    <div class="print-controls no-print">
        <button onclick="window.location.href='detail.php?id=<?= $id_surat ?>'" class="btn-print btn-back">
            Kembali
        </button>
        <button onclick="window.print()" class="btn-print">
            Cetak ID Card
        </button>
    </div>

    <?php while ($peserta = mysqli_fetch_assoc($result_peserta)): 
        $qrImage = generateQRCode($peserta['nip']);
    ?>
    <div class="id-card">
        <div class="id-card-content">
            <div class="id-card-left">
                <div class="id-card-header">
                    <img src="../assets/img/logo.png" alt="Logo" class="logo-instansi">
                    <h3>Card Absensi</h3>
                </div>
                <div class="id-card-body">
                    <p><strong>Nama:</strong> <?= htmlspecialchars($peserta['nama_pegawai']) ?></p>
                    <p><strong>NIP:</strong> <?= htmlspecialchars($peserta['nip']) ?></p>
                    <p><strong>Pangkat/Gol:</strong> <?= htmlspecialchars($peserta['golongan'] ?: '-') ?></p>
                      </div>
            </div>
            <div class="id-card-right">
                <div class="id-card-qr">
                    <img src="<?= $qrImage ?>" alt="QR Code">
                </div>
            </div>
        </div>
    </div>
    <?php endwhile; ?>

    <script>
        // Auto print when page loads (optional)
        // window.onload = function() {
        //     window.print();
        // };
    </script>
</body>
</html> 