<?php
require_once '../config/database.php';
require_once '../config/config.php';

// Fungsi untuk memformat NIP
function formatNIP($nip) {
    // Hapus semua spasi dari input
    $nip = str_replace(' ', '', $nip);
    
    // Cek apakah NIP memiliki 18 digit
    if (strlen($nip) != 18 || !ctype_digit($nip)) {
        return false;
    }
    
    // Format NIP dengan spasi
    return substr($nip, 0, 8) . ' ' . substr($nip, 8, 6) . ' ' . substr($nip, 14, 1) . ' ' . substr($nip, 15);
}

// Validasi dan format input NIP
if (!isset($_POST['nip'])) {
    die('NIP tidak boleh kosong.');
}

// Hapus spasi dari input NIP
$input_nip = str_replace(' ', '', $_POST['nip']);

// Validasi panjang dan format NIP
if (strlen($input_nip) != 18 || !ctype_digit($input_nip)) {
    die('NIP tidak valid. NIP harus 18 digit angka.');
}

// Format NIP untuk query
$nip = formatNIP($input_nip);

if (!$nip) {
    die('Format NIP tidak valid.');
}

// Query untuk mendapatkan data pegawai
$query = "SELECT * FROM pegawai WHERE nip = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "s", $nip);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (mysqli_num_rows($result) == 0) {
    die('Data pegawai tidak ditemukan.');
}

$pegawai = mysqli_fetch_assoc($result);

// Fungsi untuk generate QR code menggunakan API QR Server
function generateQRCode($text) {
    $apiUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($text);
    return $apiUrl;
}

// Gunakan NIP terformat untuk QR Code
$qrImage = generateQRCode($nip);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ID Card Absensi - <?= htmlspecialchars($pegawai['nama_pegawai']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f0f2f5;
            display: flex;
            flex-direction: column;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
        }

        .controls {
            width: 100%;
            max-width: 9cm;
            margin-bottom: 20px;
            display: flex;
            gap: 10px;
            justify-content: center;
        }

        .btn-custom {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-back {
            background: #64748b;
            color: white;
        }

        .btn-back:hover {
            background: #475569;
        }

        .btn-download {
            background: #0ea5e9;
            color: white;
        }

        .btn-download:hover {
            background: #0284c7;
        }

        .id-card {
            width: 9cm;
            height: 5.5cm;
            border: 1px solid #ddd;
            border-radius: 10px;
            padding: 15px;
            background: url('../assets/img/logo1.jpeg');
            background-size: cover;
            background-position: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .id-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }

        .id-card-content {
            position: relative;
            z-index: 2;
            display: flex;
            height: 100%;
        }

        .id-card-left {
            flex: 1;
            padding-right: 15px;
        }

        .id-card-right {
            width: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .id-card-header {
            text-align: left;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
            background: rgba(0, 0, 0, 0.3);
            padding: 5px;
            border-radius: 5px;
        }

        .logo-instansi {
            width: 30px;
            height: 30px;
            object-fit: contain;
        }

        .id-card-header h3 {
            font-size: 16px;
            margin: 0;
            font-weight: bold;
            text-transform: uppercase;
        }

        .id-card-body {
            font-size: 12px;
            padding-top: 5px;
        }

        .id-card-body p {
            margin: 5px 0;
            background: rgba(0, 0, 0, 0.3);
            padding: 5px;
            border-radius: 3px;
            line-height: 1.4;
        }

        .qr-code {
            background: white;
            padding: 5px;
            border-radius: 5px;
            width: 100px;
            height: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .qr-code img {
            width: 90px;
            height: 90px;
        }

        @media print {
            body {
                background: none;
                padding: 0;
            }
            .controls {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="controls">
        <button onclick="window.location.href='../login.php'" class="btn-custom btn-back">
            Kembali
        </button>
        <button onclick="downloadCard()" class="btn-custom btn-download">
            Download ID Card
        </button>
    </div>

    <div class="id-card" id="idCard">
        <div class="id-card-content">
            <div class="id-card-left">
                <div class="id-card-header">
                    <img src="../assets/img/logo.png" alt="Logo" class="logo-instansi">
                    <h3>Card Absensi</h3>
                </div>
                <div class="id-card-body">
                    <p><strong>Nama:</strong> <?= htmlspecialchars($pegawai['nama_pegawai']) ?></p>
                    <p><strong>NIP:</strong> <?= htmlspecialchars($nip) ?></p>
                    <p><strong>Pangkat/Gol:</strong> <?= htmlspecialchars($pegawai['golongan'] ?: '-') ?></p>
                </div>
            </div>
            <div class="id-card-right">
                <div class="qr-code">
                    <img src="<?= $qrImage ?>" alt="QR Code">
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script>
        function downloadCard() {
            const idCard = document.getElementById('idCard');
            
            // Konfigurasi html2canvas
            const options = {
                scale: 4, // Tingkatkan kualitas dengan scale 4x
                useCORS: true, // Izinkan cross-origin images
                backgroundColor: null, // Transparent background
                logging: false // Matikan logging
            };

            html2canvas(idCard, options).then(canvas => {
                // Konversi canvas ke blob
                canvas.toBlob(function(blob) {
                    // Buat URL untuk blob
                    const url = URL.createObjectURL(blob);
                    
                    // Buat element anchor untuk download
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'ID_Card_<?= str_replace(' ', '_', $pegawai['nama_pegawai']) ?>.jpg';
                    
                    // Trigger download
                    document.body.appendChild(a);
                    a.click();
                    
                    // Cleanup
                    document.body.removeChild(a);
                    URL.revokeObjectURL(url);
                }, 'image/jpeg', 1.0);
            });
        }
    </script>
</body>
</html> 