<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';
require_once '../lib/phpqrcode/qrlib.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek parameter id surat tugas
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id_surat_tugas = $_GET['id'];

// Ambil data surat tugas
$query_st = "SELECT * FROM surat_tugas WHERE id_surat_tugas = ?";
$stmt_st = mysqli_prepare($conn, $query_st);
mysqli_stmt_bind_param($stmt_st, "i", $id_surat_tugas);
mysqli_stmt_execute($stmt_st);
$result_st = mysqli_stmt_get_result($stmt_st);
$surat_tugas = mysqli_fetch_assoc($result_st);

if (!$surat_tugas) {
    header("Location: index.php");
    exit();
}

// Ambil data peserta
$query_peserta = "SELECT p.* FROM pegawai p 
                  JOIN surat_tugas_peserta stp ON p.id_pegawai = stp.id_pegawai 
                  WHERE stp.id_surat_tugas = ?";
$stmt_peserta = mysqli_prepare($conn, $query_peserta);
mysqli_stmt_bind_param($stmt_peserta, "i", $id_surat_tugas);
mysqli_stmt_execute($stmt_peserta);
$result_peserta = mysqli_stmt_get_result($stmt_peserta);

// Buat folder untuk QR Code jika belum ada
$qr_folder = "../temp/qr_codes/";
if (!file_exists($qr_folder)) {
    mkdir($qr_folder, 0777, true);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak QR Code Absensi - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print {
                display: none !important;
            }
            .qr-container {
                page-break-inside: avoid;
            }
        }
        .qr-container {
            text-align: center;
            margin-bottom: 30px;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 10px;
        }
        .qr-code {
            margin: 10px auto;
        }
        .qr-info {
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="no-print mb-4">
            <a href="index.php" class="btn btn-secondary">Kembali</a>
            <button onclick="window.print()" class="btn btn-primary">Cetak QR Code</button>
        </div>

        <h3 class="text-center mb-4">QR Code Absensi Perjalanan Dinas</h3>
        <div class="text-center mb-4">
            <h5><?= htmlspecialchars($surat_tugas['nama_kegiatan']) ?></h5>
            <p>Nomor Surat: <?= htmlspecialchars($surat_tugas['nomor_surat']) ?></p>
            <p>Tanggal: <?= date('d/m/Y', strtotime($surat_tugas['tanggal_mulai'])) ?> - 
                        <?= date('d/m/Y', strtotime($surat_tugas['tanggal_selesai'])) ?></p>
        </div>

        <div class="row">
            <?php while ($peserta = mysqli_fetch_assoc($result_peserta)) : 
                // Generate QR Code untuk setiap peserta
                $qr_data = "sppd_absensi_{$id_surat_tugas}_{$peserta['id_pegawai']}";
                $qr_file = $qr_folder . "qr_{$id_surat_tugas}_{$peserta['id_pegawai']}.png";
                QRcode::png($qr_data, $qr_file, QR_ECLEVEL_L, 10);
            ?>
            <div class="col-md-4 col-sm-6">
                <div class="qr-container">
                    <h6><?= htmlspecialchars($peserta['nama_pegawai']) ?></h6>
                    <p class="text-muted"><?= htmlspecialchars($peserta['nip']) ?></p>
                    <img src="<?= str_replace("..", BASE_URL, $qr_file) ?>" alt="QR Code" class="qr-code">
                    <div class="qr-info">
                        <small class="text-muted">Scan untuk melakukan absensi</small>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 