<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

header('Content-Type: application/json');

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Unauthorized'
    ]);
    exit();
}

// Terima data JSON
$json = file_get_contents('php://input');
$data = json_decode($json);

if (!$data || !isset($data->id_pegawai) || !isset($data->id_surat)) {
    echo json_encode([
        'success' => false,
        'message' => 'Data tidak lengkap'
    ]);
    exit();
}

try {http://localhost/sppd/dashboard.php
    // Mulai transaction
    mysqli_begin_transaction($conn);

    if ($data->tanggal === 'all') {
        // Hapus semua absensi pegawai untuk surat tugas ini
        $query = "DELETE FROM absensi_sppd 
                 WHERE id_pegawai = ? AND id_surat_tugas = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "ii", $data->id_pegawai, $data->id_surat);
    } else {
        // Hapus absensi spesifik tanggal
        $query = "DELETE FROM absensi_sppd 
                 WHERE id_pegawai = ? AND id_surat_tugas = ? AND tanggal = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "iis", $data->id_pegawai, $data->id_surat, $data->tanggal);
    }

    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception('Gagal menghapus data absensi');
    }

    // Commit transaction
    mysqli_commit($conn);

    echo json_encode([
        'success' => true,
        'message' => 'Data absensi berhasil dihapus'
    ]);

} catch (Exception $e) {
    // Rollback jika terjadi error
    mysqli_rollback($conn);
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} 