<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek parameter id surat tugas
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id_surat = $_GET['id'];

// Ambil data surat tugas
$query_st = "SELECT 
    st.*,
    DATE_FORMAT(st.tanggal_berangkat, '%d/%m/%Y') as tanggal_berangkat_formatted,
    DATE_FORMAT(st.tanggal_kembali, '%d/%m/%Y') as tanggal_kembali_formatted,
    DATEDIFF(st.tanggal_kembali, st.tanggal_berangkat) + 1 as durasi_hari
    FROM surat_tugas st 
    WHERE st.id_surat = ?";
$stmt_st = mysqli_prepare($conn, $query_st);
mysqli_stmt_bind_param($stmt_st, "i", $id_surat);
mysqli_stmt_execute($stmt_st);
$result_st = mysqli_stmt_get_result($stmt_st);

if (!$result_st) {
    die("Error in query: " . mysqli_error($conn));
}

$surat_tugas = mysqli_fetch_assoc($result_st);

if (!$surat_tugas) {
    header("Location: index.php");
    exit();
}

// Buat array tanggal untuk periode perjalanan dinas
$dates = array();
if (isset($surat_tugas['tanggal_berangkat']) && isset($surat_tugas['tanggal_kembali'])) {
    $period = new DatePeriod(
        new DateTime($surat_tugas['tanggal_berangkat']),
        new DateInterval('P1D'),
        (new DateTime($surat_tugas['tanggal_kembali']))->modify('+1 day')
    );
    foreach ($period as $date) {
        $dates[] = $date->format('Y-m-d');
    }
}

// Ambil data peserta dan absensi
$query = "SELECT 
    p.*,
    GROUP_CONCAT(
        CONCAT(
            DATE_FORMAT(a.tanggal, '%Y-%m-%d'),
            '|',
            TIME_FORMAT(a.jam, '%H:%i'),
            '|',
            CASE 
                WHEN TIME(a.jam) > '08:00:00' THEN 'Terlambat'
                ELSE 'Hadir'
            END
        ) ORDER BY a.tanggal, a.jam
    ) as kehadiran_detail
    FROM pegawai p 
    JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
    LEFT JOIN absensi_sppd a ON p.id_pegawai = a.id_pegawai 
        AND a.id_surat_tugas = dst.id_surat
    WHERE dst.id_surat = ?
    GROUP BY p.id_pegawai
    ORDER BY p.nama_pegawai";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result) {
    die("Error in query: " . mysqli_error($conn));
}

// Hitung durasi kegiatan dalam hari
if (isset($surat_tugas['tgl_berangkat']) && isset($surat_tugas['tgl_kembali'])) {
    $date1 = new DateTime($surat_tugas['tgl_berangkat']);
    $date2 = new DateTime($surat_tugas['tgl_kembali']);
    $interval = $date1->diff($date2);
    $total_hari = $interval->days + 1; // +1 karena inklusif
} else {
    $total_hari = 0;
}
?>

<!DOCTYPE html>
<html lang="en"></html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Absensi - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
  
    <style>
        :root {
            --sidebar-width: 280px;
            --sidebar-mini-width: 70px;
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            padding-left: 0 !important;
            position: relative;
            z-index: 0;
        }

        /* Main Layout Structure */
        .wrapper {
            display: flex;
            min-height: 100vh;
            width: 100%;
            position: relative;
            background: transparent !important;
        }

        /* Main Content Area */
        .main-content {
            position: relative;
            margin-left: var(--sidebar-width);
            transition: all 0.3s ease;
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            background: transparent !important;
        }

        .main-content.expanded {
            margin-left: var(--sidebar-mini-width);
            width: calc(100% - var(--sidebar-mini-width));
        }

        /* Container Modifications */
        .container-fluid {
            max-width: 100% !important;
            padding: 2rem;
            margin: 0;
            transition: all 0.3s ease;
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
                padding: 1rem;
            }

            .container-fluid {
                padding: 1rem !important;
            }
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
            position: relative;
            color: white;
        }

        .header-wrapper h1 {
            margin: 0;
            font-weight: 600;
            font-size: 1.5rem;
        }

        .header-wrapper p {
            margin: 0.5rem 0;
            opacity: 0.9;
        }

        .header-wrapper .breadcrumb {
            margin-bottom: 0;
        }

        .header-wrapper .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
        }

        .header-wrapper .breadcrumb-item.active {
            color: white;
        }

        .header-actions {
            position: absolute;
            right: 2rem;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            gap: 1rem;
            z-index: 1;
        }

        .btn-header {
            background: white;
            color: #0ea5e9;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            border: none;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .btn-header:hover {
            background: rgba(255, 255, 255, 0.9);
            transform: translateY(-2px);
            color: #0ea5e9;
            text-decoration: none;
        }

        .btn-header i {
            font-size: 1rem;
        }

        .card {
            background: white;
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            overflow: hidden;
            margin-bottom: 2rem;
        }

        .card-header {
            background: var(--primary-gradient) !important;
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 1.5rem;
        }

        .attendance-info {
            background: #f8f9fa;
            padding: 1.5rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .attendance-info h5 {
            color: #2c3e50;
            margin-bottom: 1rem;
            font-weight: 600;
        }

        .attendance-info p {
            color: #596574;
            margin-bottom: 0.5rem;
        }

        .progress-stacked {
            display: flex;
            height: 20px;
            border-radius: 10px;
            overflow: hidden;
            background-color: rgba(0, 0, 0, 0.05);
            margin-bottom: 0.5rem;
        }

        .progress-stacked .progress {
            width: 100%;
            margin: 0;
            background: transparent;
        }

        .progress-stacked .progress:not(:last-child) {
            margin-right: 1px;
        }

        .progress-stacked .progress-bar {
            border-radius: 0;
            transition: width 0.3s ease;
        }

        .table {
            margin-bottom: 0;
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }

        .table thead th {
            background: var(--primary-gradient) !important;
            color: white;
            font-weight: 600;
            padding: 1rem !important;
            border: none;
            text-transform: uppercase;
            font-size: 0.85rem;
            letter-spacing: 0.5px;
        }

        .table tbody td {
            padding: 1rem !important;
            vertical-align: middle;
            border: none;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-size: 0.9rem;
            color: #2c3e50;
        }

        .badge {
            padding: 0.5rem 0.75rem;
            font-size: 0.85rem;
            font-weight: 500;
        }

        .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }

        .bg-success { background-color: #28a745 !important; }
        .bg-warning { background-color: #ffc107 !important; }
        .bg-danger { background-color: #dc3545 !important; }
        .bg-secondary { background-color: #6c757d !important; }

        /* DataTables Customization */
        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 0.5rem;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button.current {
            background: var(--primary-gradient) !important;
            border: none;
            color: white !important;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="wrapper">
        <div class="main-content" id="mainContent">
            <div class="container-fluid">
                <div class="header-wrapper">
                    <h1>Detail Absensi Perjalanan Dinas</h1>
                    <p>Detail kehadiran peserta perjalanan dinas</p>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="index.php">Absensi SPPD</a></li>
                            <li class="breadcrumb-item active">Detail Absensi</li>
                        </ol>
                    </nav>
                    <div class="header-actions">
                        <a href="scan.php?id=<?= $id_surat ?>" class="btn-header">
                            <i class="bi bi-qr-code-scan"></i>
                            Scan QR Code
                        </a>
                        <a href="cetak_id_card.php?id=<?= $id_surat ?>" class="btn-header">
                            <i class="bi bi-printer"></i>
                            Cetak ID Card
                        </a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <?php if ($surat_tugas): ?>
                        <div class="attendance-info">
                            <h5><?= isset($surat_tugas['maksud']) ? htmlspecialchars($surat_tugas['maksud']) : 'Tidak ada keterangan' ?></h5>
                            <p class="mb-1">Nomor Surat: <?= isset($surat_tugas['no_surat']) ? htmlspecialchars($surat_tugas['no_surat']) : '-' ?></p>
                            <p class="mb-1">Tanggal: 
                                <?= isset($surat_tugas['tanggal_berangkat_formatted']) ? $surat_tugas['tanggal_berangkat_formatted'] : '-' ?> - 
                                <?= isset($surat_tugas['tanggal_kembali_formatted']) ? $surat_tugas['tanggal_kembali_formatted'] : '-' ?>
                            </p>
                            <p class="mb-1">Lokasi: <?= isset($surat_tugas['tempat_kegiatan']) ? htmlspecialchars($surat_tugas['tempat_kegiatan']) : '-' ?></p>
                            <p class="mb-0">Durasi: <?= isset($surat_tugas['durasi_hari']) ? $surat_tugas['durasi_hari'] : '0' ?> hari</p>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            Data surat tugas tidak ditemukan.
                        </div>
                        <?php endif; ?>

                        <div class="table-responsive">
                            <table class="table" id="absensiTable">
                                <thead>
                                    <tr>
                                        <th style="width: 5%">No</th>
                                        <th style="width: 20%">Nama</th>
                                        <th style="width: 15%">NIP</th>
                                        <th style="width: 30%">Kehadiran</th>
                                        <th style="width: 20%">Status</th>
                                        <th style="width: 10%">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $no = 1;
                                    if ($result && mysqli_num_rows($result) > 0):
                                    while ($row = mysqli_fetch_assoc($result)): 
                                        // Parse kehadiran detail
                                        $kehadiran = array();
                                        if ($row['kehadiran_detail']) {
                                            $details = explode(',', $row['kehadiran_detail']);
                                            foreach ($details as $detail) {
                                                list($tgl, $jam, $status) = explode('|', $detail);
                                                $kehadiran[$tgl] = array('jam' => $jam, 'status' => $status);
                                            }
                                        }
                                        
                                        // Calculate attendance percentage
                                        $total_days = count($dates);
                                        $days_present = count($kehadiran);
                                        $attendance_percentage = ($total_days > 0) ? ($days_present / $total_days) * 100 : 0;
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $no++ ?></td>
                                        <td><?= htmlspecialchars($row['nama_pegawai']) ?></td>
                                        <td><?= htmlspecialchars($row['nip']) ?></td>
                                        <td>
                                            <div class="progress-stacked">
                                                <?php 
                                                foreach ($dates as $date):
                                                    $isPresent = isset($kehadiran[$date]);
                                                    $width = 100 / count($dates);
                                                ?>
                                                <div class="progress" role="progressbar" style="width: <?= $width ?>%">
                                                    <div class="progress-bar <?= $isPresent ? 'bg-success' : 'bg-secondary' ?>" 
                                                         style="width: 100%">
                                                    </div>
                                                </div>
                                                <?php endforeach; ?>
                                            </div>
                                            <small class="d-block text-center mt-1">
                                                <?= number_format($attendance_percentage, 1) ?>% (<?= $days_present ?>/<?= $total_days ?> hari)
                                            </small>
                                        </td>
                                        <td>
                                            <?php foreach ($dates as $date): ?>
                                                <?php if (isset($kehadiran[$date])): ?>
                                                    <div class="mb-1">
                                                        <span class="badge <?= $kehadiran[$date]['status'] == 'Hadir' ? 'bg-success' : 'bg-warning' ?>">
                                                            <?= date('d/m', strtotime($date)) ?> - <?= $kehadiran[$date]['jam'] ?>
                                                            <button class="btn btn-sm btn-danger ms-1" 
                                                                    onclick="showDeleteConfirmation('<?= $row['id_pegawai'] ?>', '<?= $date ?>')" 
                                                                    title="Hapus Absensi">
                                                                <i class="bi bi-x"></i>
                                                            </button>
                                                        </span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-danger" 
                                                    onclick="showDeleteAllConfirmation('<?= $row['id_pegawai'] ?>')"
                                                    title="Hapus Semua Absensi">
                                                <i class="bi bi-trash"></i> Hapus Semua
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endwhile; 
                                    else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">Tidak ada data peserta</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Konfirmasi Hapus -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="deleteModalLabel">Konfirmasi Hapus</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus data absensi ini?</p>
                    <p class="text-danger"><small>*Data yang sudah dihapus tidak dapat dikembalikan</small></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">Hapus</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get elements
        const sidebarWrapper = document.querySelector('.sidebar');
        const mainContent = document.getElementById('mainContent');
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        if (!sidebarWrapper || !mainContent || !sidebarToggle) {
            console.error('Required elements not found');
            return;
        }

        function updateLayout() {
            if (sidebarWrapper.classList.contains('collapsed')) {
                mainContent.classList.add('expanded');
            } else {
                mainContent.classList.remove('expanded');
            }
        }

        // Initial check
        updateLayout();

        // Toggle event
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            sidebarWrapper.classList.toggle('collapsed');
            updateLayout();
            localStorage.setItem('sidebarCollapsed', sidebarWrapper.classList.contains('collapsed'));
        });

        // Check saved state
        const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
        if (sidebarCollapsed) {
            sidebarWrapper.classList.add('collapsed');
            mainContent.classList.add('expanded');
        }
    });

    $(document).ready(function() {
        $('#absensiTable').DataTable({
            "language": {
                "lengthMenu": "Tampilkan _MENU_ data per halaman",
                "zeroRecords": "Data tidak ditemukan",
                "info": "Menampilkan halaman _PAGE_ dari _PAGES_",
                "infoEmpty": "Tidak ada data tersedia",
                "infoFiltered": "(difilter dari _MAX_ total data)",
                "search": "Cari:",
                "paginate": {
                    "first": "Pertama",
                    "last": "Terakhir",
                    "next": "Selanjutnya",
                    "previous": "Sebelumnya"
                }
            }
        });
    });

    function showDeleteConfirmation(idPegawai, tanggal) {
        const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
        document.getElementById('confirmDelete').onclick = function() {
            deleteAbsensi(idPegawai, tanggal);
            modal.hide();
        };
        modal.show();
    }

    function showDeleteAllConfirmation(idPegawai) {
        const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
        document.getElementById('confirmDelete').onclick = function() {
            deleteAbsensi(idPegawai, 'all');
            modal.hide();
        };
        modal.show();
    }

    function deleteAbsensi(idPegawai, tanggal) {
        fetch('delete_absensi.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                id_pegawai: idPegawai,
                tanggal: tanggal,
                id_surat: <?= $id_surat ?>
            })
        })
        .then(response => response.json())
        .then(result => {
            if (result.success) {
                // Reload halaman setelah berhasil hapus
                location.reload();
            } else {
                alert('Gagal menghapus data: ' + result.message);
            }
        })
        .catch(error => {
            alert('Terjadi kesalahan: ' + error.message);
        });
    }
    </script>
</body>
</html> 