<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek parameter id surat tugas
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id_surat = $_GET['id'];

// Ambil data surat tugas
$query_st = "SELECT 
    st.*,
    DATE_FORMAT(st.tanggal_berangkat, '%Y-%m-%d') as tgl_berangkat,
    DATE_FORMAT(st.tanggal_kembali, '%Y-%m-%d') as tgl_kembali
    FROM surat_tugas st 
    WHERE st.id_surat = ?";
$stmt_st = mysqli_prepare($conn, $query_st);
mysqli_stmt_bind_param($stmt_st, "i", $id_surat);
mysqli_stmt_execute($stmt_st);
$result_st = mysqli_stmt_get_result($stmt_st);
$surat_tugas = mysqli_fetch_assoc($result_st);

if (!$surat_tugas) {
    header("Location: index.php");
    exit();
}

// Generate array of dates
$dates = array();
if (isset($surat_tugas['tgl_berangkat']) && isset($surat_tugas['tgl_kembali'])) {
    $period = new DatePeriod(
        new DateTime($surat_tugas['tgl_berangkat']),
        new DateInterval('P1D'),
        (new DateTime($surat_tugas['tgl_kembali']))->modify('+1 day')
    );
    foreach ($period as $date) {
        $dates[] = $date->format('Y-m-d');
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate QR Code Absensi - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <style>
        .qr-container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .qr-code {
            text-align: center;
            margin: 10px 0;
        }
        @media print {
            .no-print {
                display: none;
            }
            .qr-container {
                page-break-inside: avoid;
                margin: 20px;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mt-4">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">QR Code Absensi Per Tanggal</h5>
                                <div>
                                    <button onclick="window.print()" class="btn btn-primary no-print">
                                        <i class="bi bi-printer"></i> Cetak QR Code
                                    </button>
                                    <a href="detail.php?id=<?= $id_surat ?>" class="btn btn-light no-print">
                                        <i class="bi bi-arrow-left"></i> Kembali
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <?php foreach ($dates as $date): ?>
                                <div class="col-md-4">
                                    <div class="qr-container">
                                        <h5 class="text-center"><?= date('d/m/Y', strtotime($date)) ?></h5>
                                        <div class="qr-code" id="qrcode-<?= $date ?>"></div>
                                        <p class="text-center mb-0">Scan untuk absen tanggal ini</p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php foreach ($dates as $date): ?>
            new QRCode(document.getElementById("qrcode-<?= $date ?>"), {
                text: JSON.stringify({
                    id_surat: <?= $id_surat ?>,
                    tanggal: "<?= $date ?>",
                    type: "absensi"
                }),
                width: 200,
                height: 200
            });
            <?php endforeach; ?>
        });
    </script>
</body>
</html> 