<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Get user's bidang
$user_id = $_SESSION['user_id'];
$stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
$result_user = mysqli_stmt_get_result($stmt);
$user_data = mysqli_fetch_assoc($result_user);
$user_bidang = $user_data['bidang'];

// Ambil data surat tugas yang aktif
$query = "SELECT st.*, 
          COUNT(DISTINCT p.id_pegawai) as total_peserta,
          GROUP_CONCAT(DISTINCT DATE_FORMAT(a.tanggal, '%Y-%m-%d')) as attendance_dates,
          (SELECT COUNT(DISTINCT id_pegawai) 
           FROM absensi_sppd 
           WHERE id_surat_tugas = st.id_surat) as total_hadir,
          (SELECT DATEDIFF(tanggal_kembali, tanggal_berangkat) + 1) as total_days
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          LEFT JOIN absensi_sppd a ON st.id_surat = a.id_surat_tugas AND dst.id_pegawai = a.id_pegawai
          LEFT JOIN users u ON st.created_by = u.id
          WHERE u.bidang = ?
          GROUP BY st.id_surat
          ORDER BY st.tanggal_berangkat DESC";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "s", $user_bidang);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Absensi Perjalanan Dinas - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    
    <style>
    :root {
        --sidebar-width: 280px;
        --sidebar-mini-width: 70px;
        --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
    }

    body {
        margin: 0;
        padding: 0;
        min-height: 100vh;
        background: var(--bg-gradient) !important;
        padding-left: 0 !important;
        position: relative;
        z-index: 0;
    }

    /* Main Layout Structure */
    .wrapper {
        display: flex;
        min-height: 100vh;
        width: 100%;
        position: relative;
        background: transparent !important;
    }

    /* Main Content Area */
    .main-content {
        position: relative;
        margin-left: var(--sidebar-width);
        transition: all 0.3s ease;
        width: calc(100% - var(--sidebar-width));
        min-height: 100vh;
        background: transparent !important;
    }

    .main-content.expanded {
        margin-left: var(--sidebar-mini-width);
        width: calc(100% - var(--sidebar-mini-width));
    }

    /* Container Modifications */
    .container-fluid {
        max-width: 100% !important;
        padding: 2rem;
        margin: 0;
        transition: all 0.3s ease;
    }

    /* Mobile Responsiveness */
    @media (max-width: 768px) {
        .main-content {
            margin-left: 0 !important;
            width: 100% !important;
            padding: 1rem;
        }

        .container-fluid {
            padding: 1rem !important;
        }
    }

    .header-wrapper {
        background: var(--primary-gradient);
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        position: relative;
    }

    .header-wrapper h1 {
        color: white;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .header-wrapper p {
        color: rgba(255, 255, 255, 0.8);
        margin-bottom: 1rem;
    }

    .header-wrapper .breadcrumb-item a {
        color: rgba(255, 255, 255, 0.8);
        text-decoration: none;
    }

    .header-wrapper .breadcrumb-item.active {
        color: white;
    }

    .header-wrapper .breadcrumb-item + .breadcrumb-item::before {
        color: rgba(255, 255, 255, 0.5);
    }

    .btn-scan {
        position: absolute;
        right: 2rem;
        top: 50%;
        transform: translateY(-50%);
        background: white;
        color: #0ea5e9;
        padding: 0.5rem 1rem;
        border-radius: 8px;
        font-weight: 500;
        text-decoration: none;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-scan:hover {
        background: rgba(255, 255, 255, 0.9);
        transform: translateY(-50%) translateX(-2px);
    }

    .card {
        background: white;
        backdrop-filter: blur(10px);
        border: none;
        border-radius: 15px;
        box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
    }

    .card-body {
        padding: 0;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        background: var(--primary-gradient) !important;
        color: white;
        font-weight: 600;
        padding: 1rem !important;
        border: none;
    }

    .table tbody td {
        padding: 1rem !important;
        vertical-align: middle;
        border: none;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }

    .table tbody tr:hover {
        background-color: rgba(14, 165, 233, 0.04);
    }

    .progress-stacked {
        display: flex;
        height: 20px;
        border-radius: 10px;
        overflow: hidden;
        background-color: rgba(0, 0, 0, 0.05);
    }

    .progress-stacked .progress {
        width: 100%;
        margin: 0;
        background: transparent;
    }

    .progress-stacked .progress:not(:last-child) {
        margin-right: 1px;
    }

    .progress-stacked .progress-bar {
        border-radius: 0;
        transition: width 0.3s ease;
    }

    .btn-soft-info {
        background: rgba(14, 165, 233, 0.1);
        color: #0ea5e9;
        border: none;
        padding: 0.5rem;
        border-radius: 6px;
        transition: all 0.3s ease;
    }

    .btn-soft-info:hover {
        background: var(--primary-gradient);
        color: white;
        transform: translateY(-2px);
    }

    .empty-state {
        text-align: center;
        padding: 2rem;
        color: #6c757d;
    }

    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1rem;
    }

    /* DataTables Customization */
    .dataTables_wrapper .dataTables_length select,
    .dataTables_wrapper .dataTables_filter input {
        border: 1px solid rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        padding: 0.5rem;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: var(--primary-gradient) !important;
        border: none;
        color: white !important;
    }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="wrapper">
        <div class="main-content" id="mainContent">
            <div class="container-fluid">
                <div class="header-wrapper">
                    <h1>Absensi Perjalanan Dinas</h1>
                    <p>Daftar absensi perjalanan dinas yang sedang aktif</p>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item active">Absensi SPPD</li>
                        </ol>
                    </nav>
                  
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="absensiTable">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width: 80px">No.</th>
                                        <th style="width: 15%">No. Surat Tugas</th>
                                        <th style="width: 15%">No. SPPD</th>
                                        <th style="width: 20%">Kegiatan</th>
                                        <th style="width: 15%">Tanggal</th>
                                        <th style="width: 15%">Total Peserta</th>
                                        <th style="width: 10%">Kehadiran</th>
                                        <th style="width: 10%">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $no = 1;
                                    while ($row = mysqli_fetch_assoc($result)): 
                                        $persentase_hadir = ($row['total_peserta'] > 0) ? 
                                                          ($row['total_hadir'] / $row['total_peserta']) * 100 : 0;
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $no++ ?></td>
                                        <td><?= htmlspecialchars($row['no_surat']) ?></td>
                                        <td><?= htmlspecialchars($row['no_sppd']) ?></td>
                                        <td>
                                            <div class="text-wrap"><?= htmlspecialchars($row['maksud']) ?></div>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($row['tanggal_berangkat'])) ?> - 
                                            <?= date('d/m/Y', strtotime($row['tanggal_kembali'])) ?></td>
                                        <td><?= $row['total_peserta'] ?> orang</td>
                                        <td>
                                            <div class="progress-stacked">
                                                <?php 
                                                $total_days = $row['total_days'] ?: 1;
                                                $attendance_dates = $row['attendance_dates'] ? explode(',', $row['attendance_dates']) : [];
                                                $unique_dates = count(array_unique($attendance_dates));
                                                $daily_percentage = ($row['total_peserta'] > 0) ? 
                                                    ($row['total_hadir'] / ($row['total_peserta'] * $total_days)) * 100 : 0;
                                                
                                                for ($i = 0; $i < $total_days; $i++) {
                                                    $day_percentage = ($row['total_peserta'] > 0 && $i < $unique_dates) ? 
                                                        (100 / $total_days) : 0;
                                                    $bg_class = $day_percentage > 0 ? 'bg-success' : 'bg-secondary';
                                                    ?>
                                                    <div class="progress" role="progressbar" 
                                                         style="width: <?= 100/$total_days ?>%">
                                                        <div class="progress-bar <?= $bg_class ?>" 
                                                             style="width: <?= $day_percentage ?>%">
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                            <small class="d-block text-center mt-1">
                                                <?= number_format($daily_percentage, 1) ?>% (<?= $unique_dates ?>/<?= $total_days ?> hari)
                                            </small>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="detail.php?id=<?= $row['id_surat'] ?>" 
                                                   class="btn btn-soft-info btn-sm" title="Detail">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                             
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                    <?php if (mysqli_num_rows($result) == 0): ?>
                                    <tr>
                                        <td colspan="8" class="empty-state">
                                            <i class="bi bi-inbox"></i>
                                            <p class="mb-0">Tidak ada data absensi yang aktif</p>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap5.min.js"></script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get elements
        const sidebarWrapper = document.querySelector('.sidebar');
        const mainContent = document.getElementById('mainContent');
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        if (!sidebarWrapper || !mainContent || !sidebarToggle) {
            console.error('Required elements not found');
            return;
        }

        function updateLayout() {
            if (sidebarWrapper.classList.contains('collapsed')) {
                mainContent.classList.add('expanded');
            } else {
                mainContent.classList.remove('expanded');
            }
        }

        // Initial check
        updateLayout();

        // Toggle event
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            sidebarWrapper.classList.toggle('collapsed');
            updateLayout();
            localStorage.setItem('sidebarCollapsed', sidebarWrapper.classList.contains('collapsed'));
        });

        // Check saved state
        const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
        if (sidebarCollapsed) {
            sidebarWrapper.classList.add('collapsed');
            mainContent.classList.add('expanded');
        }
    });

    $(document).ready(function() {
        $('#absensiTable').DataTable({
            "responsive": true,
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
            }
        });
    });
    </script>
</body>
</html> 