<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Terima data JSON
$json = file_get_contents('php://input');
$data = json_decode($json);

if (!$data || !isset($data->nip) || !isset($data->id_surat) || !isset($data->tanggal)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

$nip = $data->nip;
$id_surat = $data->id_surat;
$tanggal = $data->tanggal;
$jam = date('H:i:s');

try {
    // Cek apakah NIP terdaftar sebagai peserta surat tugas
    $query_check = "SELECT p.id_pegawai, p.nama_pegawai 
                   FROM pegawai p 
                   JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
                   WHERE p.nip = ? AND dst.id_surat = ?";
    $stmt_check = mysqli_prepare($conn, $query_check);
    mysqli_stmt_bind_param($stmt_check, "si", $nip, $id_surat);
    mysqli_stmt_execute($stmt_check);
    $result_check = mysqli_stmt_get_result($stmt_check);
    $pegawai = mysqli_fetch_assoc($result_check);

    if (!$pegawai) {
        throw new Exception('Pegawai tidak terdaftar dalam perjalanan dinas ini');
    }

    // Cek apakah sudah absen hari ini
    $query_exist = "SELECT id_absensi FROM absensi_sppd 
                    WHERE id_surat_tugas = ? AND id_pegawai = ? AND tanggal = ?";
    $stmt_exist = mysqli_prepare($conn, $query_exist);
    mysqli_stmt_bind_param($stmt_exist, "iis", $id_surat, $pegawai['id_pegawai'], $tanggal);
    mysqli_stmt_execute($stmt_exist);
    $result_exist = mysqli_stmt_get_result($stmt_exist);

    if (mysqli_num_rows($result_exist) > 0) {
        throw new Exception('Pegawai sudah melakukan absensi hari ini');
    }

    // Simpan absensi
    $query_insert = "INSERT INTO absensi_sppd (id_surat_tugas, id_pegawai, tanggal, jam) 
                    VALUES (?, ?, ?, ?)";
    $stmt_insert = mysqli_prepare($conn, $query_insert);
    mysqli_stmt_bind_param($stmt_insert, "iiss", $id_surat, $pegawai['id_pegawai'], $tanggal, $jam);
    
    if (!mysqli_stmt_execute($stmt_insert)) {
        throw new Exception('Gagal menyimpan absensi');
    }

    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'message' => 'Absensi berhasil dicatat untuk ' . $pegawai['nama_pegawai'],
        'data' => [
            'nama_pegawai' => $pegawai['nama_pegawai'],
            'tanggal' => $tanggal,
            'jam' => $jam
        ]
    ]);

} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?> 