<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

header('Content-Type: application/json');

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Anda harus login terlebih dahulu'
    ]);
    exit();
}

// Cek apakah ada data yang dikirim
if (!isset($_POST['id_surat_tugas']) || !isset($_POST['id_pegawai'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Data tidak lengkap'
    ]);
    exit();
}

$id_surat_tugas = $_POST['id_surat_tugas'];
$id_pegawai = $_POST['id_pegawai'];
$tanggal = date('Y-m-d');
$jam = date('H:i:s');

// Cek apakah pegawai terdaftar dalam surat tugas
$query_check = "SELECT * FROM surat_tugas_peserta WHERE id_surat_tugas = ? AND id_pegawai = ?";
$stmt_check = mysqli_prepare($conn, $query_check);
mysqli_stmt_bind_param($stmt_check, "ii", $id_surat_tugas, $id_pegawai);
mysqli_stmt_execute($stmt_check);
$result_check = mysqli_stmt_get_result($stmt_check);

if (mysqli_num_rows($result_check) === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Pegawai tidak terdaftar dalam surat tugas ini'
    ]);
    exit();
}

// Cek apakah sudah absen hari ini
$query_exist = "SELECT * FROM absensi_sppd WHERE id_surat_tugas = ? AND id_pegawai = ? AND tanggal = ?";
$stmt_exist = mysqli_prepare($conn, $query_exist);
mysqli_stmt_bind_param($stmt_exist, "iis", $id_surat_tugas, $id_pegawai, $tanggal);
mysqli_stmt_execute($stmt_exist);
$result_exist = mysqli_stmt_get_result($stmt_exist);

if (mysqli_num_rows($result_exist) > 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Anda sudah melakukan absensi hari ini'
    ]);
    exit();
}

// Simpan absensi
$query_insert = "INSERT INTO absensi_sppd (id_surat_tugas, id_pegawai, tanggal, jam, status) VALUES (?, ?, ?, ?, 'hadir')";
$stmt_insert = mysqli_prepare($conn, $query_insert);
mysqli_stmt_bind_param($stmt_insert, "iiss", $id_surat_tugas, $id_pegawai, $tanggal, $jam);

if (mysqli_stmt_execute($stmt_insert)) {
    // Ambil nama pegawai
    $query_pegawai = "SELECT nama_pegawai FROM pegawai WHERE id_pegawai = ?";
    $stmt_pegawai = mysqli_prepare($conn, $query_pegawai);
    mysqli_stmt_bind_param($stmt_pegawai, "i", $id_pegawai);
    mysqli_stmt_execute($stmt_pegawai);
    $result_pegawai = mysqli_stmt_get_result($stmt_pegawai);
    $pegawai = mysqli_fetch_assoc($result_pegawai);
    
    echo json_encode([
        'status' => 'success',
        'message' => 'Absensi berhasil dicatat untuk ' . htmlspecialchars($pegawai['nama_pegawai'])
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Gagal mencatat absensi'
    ]);
} 