<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek parameter id surat tugas
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id_surat = $_GET['id'];

// Ambil data surat tugas
$query_st = "SELECT * FROM surat_tugas WHERE id_surat = ?";
$stmt_st = mysqli_prepare($conn, $query_st);
mysqli_stmt_bind_param($stmt_st, "i", $id_surat);
mysqli_stmt_execute($stmt_st);
$result_st = mysqli_stmt_get_result($stmt_st);
$surat_tugas = mysqli_fetch_assoc($result_st);

if (!$surat_tugas) {
    header("Location: index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scan ID Card - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <script src="https://unpkg.com/html5-qrcode"></script>
    <style>
        :root {
            --sidebar-width: 280px;
            --sidebar-mini-width: 70px;
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --card-border-radius: 15px;
            --shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.05);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            padding-left: 0 !important;
            position: relative;
            z-index: 0;
        }

        /* Main Layout Structure */
        .wrapper {
            display: flex;
            min-height: 100vh;
            width: 100%;
            position: relative;
            background: transparent !important;
        }

        /* Main Content Area */
        .main-content {
            position: relative;
            margin-left: var(--sidebar-width);
            transition: all 0.3s ease;
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            background: transparent !important;
        }

        .main-content.expanded {
            margin-left: var(--sidebar-mini-width);
            width: calc(100% - var(--sidebar-mini-width));
        }

        /* Container Modifications */
        .container-fluid {
            max-width: 100% !important;
            padding: 2rem;
            margin: 0;
            transition: all 0.3s ease;
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
                padding: 1rem;
            }

            .container-fluid {
                padding: 1rem !important;
            }
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: var(--card-border-radius);
            margin-bottom: 2rem;
            box-shadow: var(--shadow-lg);
            position: relative;
        }

        .header-wrapper h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header-wrapper p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 1rem;
        }

        .header-wrapper .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: color 0.2s ease;
        }

        .header-wrapper .breadcrumb-item a:hover {
            color: white;
        }

        .header-wrapper .breadcrumb-item.active {
            color: white;
        }

        .card {
            background: white;
            border: none;
            border-radius: var(--card-border-radius);
            box-shadow: var(--shadow-lg);
            overflow: hidden;
            margin-bottom: 2rem;
            backdrop-filter: blur(10px);
        }

        .card-body {
            padding: 2rem;
        }

        .attendance-info {
            background: rgba(14, 165, 233, 0.05);
            padding: 1.5rem;
            border-radius: var(--card-border-radius);
            margin-bottom: 1.5rem;
            box-shadow: var(--shadow-sm);
            border: 1px solid rgba(14, 165, 233, 0.1);
        }

        .attendance-info h5 {
            color: #0ea5e9;
            margin-bottom: 1rem;
            font-weight: 600;
        }

        .attendance-info p {
            color: #334155;
            margin-bottom: 0.5rem;
            font-size: 0.95rem;
        }

        .scan-area {
            background: white;
            padding: 2rem;
            border-radius: var(--card-border-radius);
            box-shadow: var(--shadow-md);
            border: 1px solid rgba(0, 0, 0, 0.05);
        }

        #reader {
            width: 100%;
            max-width: 640px;
            margin: 0 auto;
            border-radius: var(--card-border-radius);
            overflow: hidden;
            border: none !important;
            box-shadow: var(--shadow-sm) !important;
        }

        #reader > div:first-child {
            box-shadow: none !important;
            border: none !important;
        }

        .table {
            margin-bottom: 0;
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }

        .table thead th {
            background: var(--primary-gradient) !important;
            color: white;
            font-weight: 600;
            padding: 1rem !important;
            border: none;
            text-transform: uppercase;
            font-size: 0.85rem;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }

        .table thead th:first-child {
            border-top-left-radius: 10px;
        }

        .table thead th:last-child {
            border-top-right-radius: 10px;
        }

        .table tbody td {
            padding: 1rem !important;
            vertical-align: middle;
            border: none;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-size: 0.9rem;
            color: #334155;
            background: white;
            transition: background-color 0.2s ease;
        }

        .table tbody tr:hover td {
            background-color: rgba(14, 165, 233, 0.02);
        }

        .table tbody tr:last-child td {
            border-bottom: none;
        }

        .table tbody tr:last-child td:first-child {
            border-bottom-left-radius: 10px;
        }

        .table tbody tr:last-child td:last-child {
            border-bottom-right-radius: 10px;
        }

        .status-badge {
            padding: 0.35rem 0.75rem;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            display: inline-block;
        }

        .status-badge.present {
            background: rgba(34, 197, 94, 0.1);
            color: #16a34a;
        }

        .status-badge.absent {
            background: rgba(239, 68, 68, 0.1);
            color: #dc2626;
        }

        .status-badge.warning {
            background: rgba(245, 158, 11, 0.1);
            color: #d97706;
        }

        .btn-scan {
            position: absolute;
            right: 2rem;
            top: 50%;
            transform: translateY(-50%);
            background: white;
            color: #0ea5e9;
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: var(--shadow-md);
        }

        .btn-scan:hover {
            background: rgba(255, 255, 255, 0.9);
            transform: translateY(-50%) translateX(-2px);
            color: #0ea5e9;
        }

        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .form-control {
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            padding: 0.75rem 1rem;
            transition: all 0.2s ease;
        }

        .form-control:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }

        .alert {
            border-radius: var(--card-border-radius);
            padding: 1rem 1.5rem;
            margin-top: 1rem;
            display: none;
            animation: fadeIn 0.3s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .modal-content {
            border: none;
            border-radius: var(--card-border-radius);
            overflow: hidden;
        }

        .modal-header {
            background: var(--primary-gradient);
            border: none;
            padding: 1.5rem;
        }

        .modal-header .modal-title {
            color: white;
            font-weight: 600;
        }

        .modal-body {
            padding: 2rem;
        }

        .modal-footer {
            border-top: 1px solid rgba(0, 0, 0, 0.05);
            padding: 1rem 2rem;
        }

        .btn-close-white {
            filter: brightness(0) invert(1);
        }

        .success-icon {
            color: #16a34a;
            font-size: 4rem;
            margin-bottom: 1rem;
        }

        .badge {
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-weight: 500;
        }

        .badge.bg-success {
            background: rgba(34, 197, 94, 0.1) !important;
            color: #16a34a;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="wrapper">
        <div class="main-content" id="mainContent">
            <div class="container-fluid">
                <div class="header-wrapper">
                    <h1>Scan ID Card Pegawai</h1>
                    <p>Scan ID Card untuk mencatat kehadiran peserta perjalanan dinas</p>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="index.php">Absensi SPPD</a></li>
                            <li class="breadcrumb-item active">Scan ID Card</li>
                        </ol>
                    </nav>
                    <a href="detail.php?id=<?= $id_surat ?>" class="btn-scan">
                        <i class="bi bi-arrow-left"></i>
                        Kembali
                    </a>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="attendance-info">
                            <h5><i class="bi bi-info-circle me-2"></i>Informasi Perjalanan Dinas</h5>
                            <div class="row">
                                <div class="col-md-4">
                                    <p class="mb-1"><strong>Nomor Surat:</strong><br><?= htmlspecialchars($surat_tugas['no_surat']) ?></p>
                                </div>
                                <div class="col-md-4">
                                    <p class="mb-1"><strong>Tanggal:</strong><br><?= date('d/m/Y', strtotime($surat_tugas['tanggal_berangkat'])) ?> - 
                                    <?= date('d/m/Y', strtotime($surat_tugas['tanggal_kembali'])) ?></p>
                                </div>
                                <div class="col-md-4">
                                    <p class="mb-0"><strong>Lokasi:</strong><br><?= htmlspecialchars($surat_tugas['tempat_kegiatan']) ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Area Scan -->
                            <div class="col-md-5">
                                <div class="scan-area">
                                    <div class="text-center mb-4">
                                        <div class="mb-4">
                                            <label for="tanggalAbsen" class="form-label">Pilih Tanggal Absen</label>
                                            <input type="date" class="form-control" id="tanggalAbsen" 
                                                   min="<?= $surat_tugas['tanggal_berangkat'] ?>" 
                                                   max="<?= $surat_tugas['tanggal_kembali'] ?>" 
                                                   value="<?= date('Y-m-d') ?>">
                                        </div>
                                        <div class="text-end mb-4">
                                            <a href="cetak_absensi.php?id=<?= $id_surat ?>&tanggal=<?= date('Y-m-d') ?>" 
                                               id="cetakButton"
                                               class="btn btn-primary" 
                                               target="_blank">
                                                <i class="bi bi-printer me-2"></i>Cetak Daftar Hadir
                                            </a>
                                        </div>
                                        <p class="text-muted mb-4">
                                            <i class="bi bi-qr-code-scan me-2"></i>
                                            Silakan scan ID Card pegawai untuk mencatat kehadiran
                                        </p>
                                    </div>
                                    <div id="reader" class="mb-4"></div>
                                    <div id="result"></div>
                                    <div class="alert alert-success" id="successAlert" role="alert">
                                        <i class="bi bi-check-circle me-2"></i>
                                        Absensi berhasil dicatat!
                                    </div>
                                    <div class="alert alert-danger" id="errorAlert" role="alert">
                                        <i class="bi bi-exclamation-circle me-2"></i>
                                        <span id="errorMessage">Terjadi kesalahan saat mencatat absensi.</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Tabel Peserta -->
                            <div class="col-md-7">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Nama</th>
                                                <th>NIP</th>
                                                <th>Pangkat/Golongan</th>
                                                <th>Unit Kerja</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            // Ambil data peserta
                                            $query_peserta = "SELECT p.*, 
                                                (SELECT MAX(tanggal) FROM absensi_sppd 
                                                 WHERE id_pegawai = p.id_pegawai 
                                                 AND id_surat_tugas = ?) as last_absen
                                                FROM pegawai p 
                                                JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
                                                WHERE dst.id_surat = ?
                                                ORDER BY 
                                                    CASE 
                                                        WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 1
                                                        WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                                                        WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 3
                                                        WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
                                                        WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 5
                                                        ELSE 6
                                                    END,
                                                    CASE 
                                                        WHEN p.golongan LIKE '%IV/C%' THEN 1
                                                        WHEN p.golongan LIKE '%IV/B%' THEN 2
                                                        WHEN p.golongan LIKE '%IV/A%' THEN 3
                                                        WHEN p.golongan LIKE '%III/D%' THEN 4
                                                        WHEN p.golongan LIKE '%III/C%' THEN 5
                                                        WHEN p.golongan LIKE '%III/B%' THEN 6
                                                        WHEN p.golongan LIKE '%III/A%' THEN 7
                                                        WHEN p.golongan LIKE '%II/D%' THEN 8
                                                        WHEN p.golongan LIKE '%II/C%' THEN 9
                                                        WHEN p.golongan LIKE '%II/B%' THEN 10
                                                        WHEN p.golongan LIKE '%II/A%' THEN 11
                                                        ELSE 12
                                                    END,
                                                    p.nama_pegawai";
                                            
                                            $stmt_peserta = mysqli_prepare($conn, $query_peserta);
                                            mysqli_stmt_bind_param($stmt_peserta, "ii", $id_surat, $id_surat);
                                            mysqli_stmt_execute($stmt_peserta);
                                            $result_peserta = mysqli_stmt_get_result($stmt_peserta);
                                            
                                            $no = 1;
                                            while ($peserta = mysqli_fetch_assoc($result_peserta)) {
                                                $status = "Belum Absen";
                                                $status_class = "absent";
                                                
                                                if ($peserta['last_absen']) {
                                                    if ($peserta['last_absen'] == date('Y-m-d')) {
                                                        $status = "Sudah Absen Hari Ini";
                                                        $status_class = "present";
                                                    } else {
                                                        $status = "Terakhir: " . date('d/m/Y', strtotime($peserta['last_absen']));
                                                        $status_class = "warning";
                                                    }
                                                }
                                            ?>
                                            <tr>
                                                <td><?= $no++ ?></td>
                                                <td><?= htmlspecialchars($peserta['nama_pegawai']) ?></td>
                                                <td><?= htmlspecialchars($peserta['nip']) ?></td>
                                                <td><?= htmlspecialchars($peserta['golongan'] ?: '-') ?></td>
                                                <td><?= htmlspecialchars($peserta['unit_kerja']) ?></td>
                                                <td><span class="status-badge <?= $status_class ?>"><?= $status ?></span></td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Sukses -->
    <div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="successModalLabel">Berhasil!</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <i class="bi bi-check-circle-fill success-icon"></i>
                    <p class="mt-3 mb-4" id="successModalMessage"></p>
                    <div class="bg-light p-3 rounded-3">
                        <p class="mb-2"><i class="bi bi-clock me-2"></i><strong>Waktu Absen:</strong> <span id="absenTime"></span></p>
                        <p class="mb-2"><i class="bi bi-calendar me-2"></i><strong>Tanggal:</strong> <span id="absenDate"></span></p>
                        <p class="mb-0"><i class="bi bi-person-check me-2"></i><strong>Status:</strong> <span id="absenStatus" class="badge bg-success">Hadir</span></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get elements
            const sidebarWrapper = document.querySelector('.sidebar');
            const mainContent = document.getElementById('mainContent');
            const sidebarToggle = document.querySelector('.sidebar-toggle');
            
            if (!sidebarWrapper || !mainContent || !sidebarToggle) {
                console.error('Required elements not found');
                return;
            }

            function updateLayout() {
                if (sidebarWrapper.classList.contains('collapsed')) {
                    mainContent.classList.add('expanded');
                } else {
                    mainContent.classList.remove('expanded');
                }
            }

            // Initial check
            updateLayout();

            // Toggle event
            sidebarToggle.addEventListener('click', function(e) {
                e.preventDefault();
                sidebarWrapper.classList.toggle('collapsed');
                updateLayout();
                localStorage.setItem('sidebarCollapsed', sidebarWrapper.classList.contains('collapsed'));
            });

            // Check saved state
            const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
            if (sidebarCollapsed) {
                sidebarWrapper.classList.add('collapsed');
                mainContent.classList.add('expanded');
            }
        });

        // Fungsi untuk memperbarui URL tombol cetak
        document.getElementById('tanggalAbsen').addEventListener('change', function() {
            const selectedDate = this.value;
            const cetakButton = document.getElementById('cetakButton');
            const baseUrl = 'cetak_absensi.php';
            const newUrl = `${baseUrl}?id=<?= $id_surat ?>&tanggal=${selectedDate}`;
            cetakButton.href = newUrl;
            
            // Update tabel kehadiran
            updateAttendanceTable(selectedDate);
        });

        // Fungsi untuk memperbarui tabel kehadiran
        function updateAttendanceTable(selectedDate) {
            const tbody = document.querySelector('table tbody');
            tbody.style.opacity = '0.5';
            tbody.style.transition = 'opacity 0.3s ease';

            fetch('update_attendance_table.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    id_surat: <?= $id_surat ?>,
                    tanggal: selectedDate
                })
            })
            .then(response => response.json())
            .then(data => {
                tbody.innerHTML = '';
                
                data.forEach((peserta, index) => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${index + 1}</td>
                        <td>${peserta.nama_pegawai}</td>
                        <td>${peserta.nip}</td>
                        <td>${peserta.golongan || '-'}</td>
                        <td>${peserta.unit_kerja}</td>
                        <td><span class="status-badge ${peserta.status_class}">${peserta.status}</span></td>
                    `;
                    tbody.appendChild(row);
                });
                
                tbody.style.opacity = '1';
            })
            .catch(error => {
                console.error('Error updating table:', error);
                tbody.style.opacity = '1';
                showError('Gagal memperbarui data kehadiran');
            });
        }

        function showSuccess(message) {
            const alert = document.getElementById('successAlert');
            alert.textContent = message;
            alert.style.display = 'block';
            setTimeout(() => {
                alert.style.display = 'none';
            }, 3000);
        }

        function showError(message) {
            const alert = document.getElementById('errorAlert');
            const messageSpan = document.getElementById('errorMessage');
            messageSpan.textContent = message;
            alert.style.display = 'block';
            setTimeout(() => {
                alert.style.display = 'none';
            }, 3000);
        }

        function onScanSuccess(decodedText, decodedResult) {
            try {
                const selectedDate = document.getElementById('tanggalAbsen').value;
                const reader = document.getElementById('reader');
                reader.style.opacity = '0.5';
                reader.style.transition = 'opacity 0.3s ease';
                
                // Kirim NIP pegawai (dari barcode) dan id surat tugas ke server
                fetch('process_absensi.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        nip: decodedText,
                        id_surat: <?= $id_surat ?>,
                        tanggal: selectedDate
                    })
                })
                .then(response => response.json())
                .then(result => {
                    reader.style.opacity = '1';
                    if (result.success) {
                        // Update modal content
                        document.getElementById('successModalMessage').textContent = result.message;
                        document.getElementById('absenTime').textContent = result.data.jam;
                        document.getElementById('absenDate').textContent = result.data.tanggal;
                        
                        // Show modal
                        var successModal = new bootstrap.Modal(document.getElementById('successModal'));
                        successModal.show();

                        // Play success sound
                        var audio = new Audio('<?= BASE_URL ?>/assets/sounds/success.mp3');
                        audio.play();

                        // Update attendance table
                        updateAttendanceTable(selectedDate);
                    } else {
                        throw new Error(result.message);
                    }
                })
                .catch(error => {
                    reader.style.opacity = '1';
                    showError(error.message || 'Terjadi kesalahan saat mencatat absensi');
                });
            } catch (error) {
                console.error('Invalid barcode format');
                showError('Format barcode tidak valid');
            }
        }

        function onScanFailure(error) {
            // handle scan failure, usually better to ignore and keep scanning
            console.warn(`Code scan error = ${error}`);
        }

        // Initialize QR Scanner with custom styling
        let html5QrcodeScanner = new Html5QrcodeScanner(
            "reader",
            { 
                fps: 10, 
                qrbox: {width: 250, height: 250},
                rememberLastUsedCamera: true,
                showTorchButtonIfSupported: true
            },
            /* verbose= */ false
        );
        
        // Render scanner
        html5QrcodeScanner.render(onScanSuccess, onScanFailure);

        // Add custom styling to scanner elements after render
        setTimeout(() => {
            const scannerContainer = document.getElementById('reader');
            const videoContainer = scannerContainer.querySelector('#reader__scan_region');
            if (videoContainer) {
                videoContainer.style.border = '1px solid rgba(0, 0, 0, 0.1)';
                videoContainer.style.borderRadius = '10px';
                videoContainer.style.overflow = 'hidden';
            }

            const selectCamera = scannerContainer.querySelector('select');
            if (selectCamera) {
                selectCamera.classList.add('form-select');
                selectCamera.style.maxWidth = '300px';
                selectCamera.style.margin = '0 auto 1rem auto';
            }

            const permissionButton = scannerContainer.querySelector('button');
            if (permissionButton) {
                permissionButton.classList.add('btn', 'btn-primary', 'mb-3');
            }
        }, 1000);
    </script>
</body>
</html> 