<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

// Terima data JSON
$json = file_get_contents('php://input');
$data = json_decode($json);

if (!$data || !isset($data->id_surat) || !isset($data->tanggal)) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Invalid data']);
    exit();
}

$id_surat = $data->id_surat;
$tanggal = $data->tanggal;

// Query untuk mengambil data peserta dan status absensi
$query = "SELECT p.*, 
    (SELECT MAX(tanggal) FROM absensi_sppd 
     WHERE id_pegawai = p.id_pegawai 
     AND id_surat_tugas = ? 
     AND tanggal = ?) as absen_date
    FROM pegawai p 
    JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
    WHERE dst.id_surat = ?
    ORDER BY 
        CASE 
            WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 1
            WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
            WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 3
            WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
            WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 5
            ELSE 6
        END,
        CASE 
            WHEN p.golongan LIKE '%IV/C%' THEN 1
            WHEN p.golongan LIKE '%IV/B%' THEN 2
            WHEN p.golongan LIKE '%IV/A%' THEN 3
            WHEN p.golongan LIKE '%III/D%' THEN 4
            WHEN p.golongan LIKE '%III/C%' THEN 5
            WHEN p.golongan LIKE '%III/B%' THEN 6
            WHEN p.golongan LIKE '%III/A%' THEN 7
            WHEN p.golongan LIKE '%II/D%' THEN 8
            WHEN p.golongan LIKE '%II/C%' THEN 9
            WHEN p.golongan LIKE '%II/B%' THEN 10
            WHEN p.golongan LIKE '%II/A%' THEN 11
            ELSE 12
        END,
        p.nama_pegawai";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "ssi", $id_surat, $tanggal, $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$peserta_list = [];
while ($peserta = mysqli_fetch_assoc($result)) {
    // Tentukan status absensi
    if ($peserta['absen_date']) {
        $status = "Sudah Absen Hari Ini";
        $status_class = "text-success";
    } else {
        $status = "Belum Absen";
        $status_class = "text-danger";
    }

    // Format data untuk response
    $peserta_list[] = [
        'nama_pegawai' => htmlspecialchars($peserta['nama_pegawai']),
        'nip' => htmlspecialchars($peserta['nip']),
        'golongan' => htmlspecialchars($peserta['golongan']),
        'unit_kerja' => htmlspecialchars($peserta['unit_kerja']),
        'status' => $status,
        'status_class' => $status_class
    ];
}

// Kirim response JSON
header('Content-Type: application/json');
echo json_encode($peserta_list); 