<?php
session_start();
require_once '../config/config.php';

// Cek login dan level
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['level'], ['admin', 'pimpinan', 'bandahara'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $judul = trim($_POST['judul']);
    $isi = trim($_POST['isi']);
    $prioritas = $_POST['prioritas'];
    $created_by = $_SESSION['user_id'];
    $status = 'aktif'; // Set default status to aktif

    $query = "INSERT INTO informasi (judul, isi, prioritas, created_by, status) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "sssis", $judul, $isi, $prioritas, $created_by, $status);

    if (mysqli_stmt_execute($stmt)) {
        echo json_encode([
            'success' => true,
            'message' => 'Informasi berhasil ditambahkan'
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Error: ' . mysqli_error($conn)
        ]);
    }
    exit();
} else {
    // Jika bukan POST request, redirect ke halaman informasi
    header("Location: ../informasi/index.php");
    exit();
}
