<?php
session_start();
require_once '../config/config.php';

header('Content-Type: application/json');

// Cek login dan level
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_GET['id'])) {
    $id_info = $_GET['id'];

    // Cek apakah user adalah pembuat info atau admin
    $check_query = "SELECT created_by FROM informasi WHERE id_info = ?";
    $stmt = mysqli_prepare($conn, $check_query);
    mysqli_stmt_bind_param($stmt, "i", $id_info);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $info = mysqli_fetch_assoc($result);

    if (!$info) {
        echo json_encode(['success' => false, 'message' => 'Informasi tidak ditemukan']);
        exit();
    }

    if ($info['created_by'] != $_SESSION['user_id'] && $_SESSION['level'] != 'admin') {
        echo json_encode(['success' => false, 'message' => 'Anda tidak memiliki hak untuk menghapus informasi ini']);
        exit();
    }

    // Mulai transaksi
    mysqli_begin_transaction($conn);

    try {
        // 0. Ambil daftar file yang akan dihapus
        $get_files_query = "SELECT cf.file_name 
                           FROM chat_files cf 
                           INNER JOIN chat_messages cm ON cf.message_id = cm.id 
                           WHERE cm.info_id = ?";
        $stmt_get_files = mysqli_prepare($conn, $get_files_query);
        mysqli_stmt_bind_param($stmt_get_files, "i", $id_info);
        mysqli_stmt_execute($stmt_get_files);
        $result_files = mysqli_stmt_get_result($stmt_get_files);
        
        // Hapus file fisik
        while ($file = mysqli_fetch_assoc($result_files)) {
            $file_path = "../assets/uploads/chat/" . $file['file_name'];
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }

        // 1. Hapus file-file chat yang terkait
        $delete_files_query = "DELETE chat_files FROM chat_files 
                             INNER JOIN chat_messages ON chat_files.message_id = chat_messages.id 
                             WHERE chat_messages.info_id = ?";
        $stmt_files = mysqli_prepare($conn, $delete_files_query);
        mysqli_stmt_bind_param($stmt_files, "i", $id_info);
        mysqli_stmt_execute($stmt_files);

        // 2. Hapus semua chat messages yang terkait
        $delete_chat_query = "DELETE FROM chat_messages WHERE info_id = ?";
        $stmt_chat = mysqli_prepare($conn, $delete_chat_query);
        mysqli_stmt_bind_param($stmt_chat, "i", $id_info);
        mysqli_stmt_execute($stmt_chat);

        // 3. Hapus informasi
        $delete_info_query = "DELETE FROM informasi WHERE id_info = ?";
        $stmt_info = mysqli_prepare($conn, $delete_info_query);
        mysqli_stmt_bind_param($stmt_info, "i", $id_info);
        mysqli_stmt_execute($stmt_info);

        // Commit transaksi jika semua berhasil
        mysqli_commit($conn);
        echo json_encode(['success' => true, 'message' => 'Informasi dan chat terkait berhasil dihapus']);
    } catch (Exception $e) {
        // Rollback jika terjadi error
        mysqli_rollback($conn);
        echo json_encode(['success' => false, 'message' => 'Gagal menghapus informasi: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
