<?php
session_start();
require_once '../config/config.php';

header('Content-Type: application/json');

// Cek login dan level
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_info = $_POST['id_info'];
    $judul = trim($_POST['judul']);
    $isi = trim($_POST['isi']);
    $prioritas = $_POST['prioritas'];

    // Cek apakah user adalah pembuat info atau admin
    $check_query = "SELECT created_by FROM informasi WHERE id_info = ?";
    $stmt = mysqli_prepare($conn, $check_query);
    mysqli_stmt_bind_param($stmt, "i", $id_info);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $info = mysqli_fetch_assoc($result);

    if ($info['created_by'] != $_SESSION['user_id'] && $_SESSION['level'] != 'admin') {
        echo json_encode(['success' => false, 'message' => 'Anda tidak memiliki hak untuk mengedit informasi ini']);
        exit();
    }

    $query = "UPDATE informasi SET judul = ?, isi = ?, prioritas = ? WHERE id_info = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "sssi", $judul, $isi, $prioritas, $id_info);

    if (mysqli_stmt_execute($stmt)) {
        echo json_encode(['success' => true, 'message' => 'Informasi berhasil diperbarui']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Gagal memperbarui informasi: ' . mysqli_error($conn)]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
}
