<?php
session_start();
require_once '../config/config.php';

header('Content-Type: application/json');

// Cek login
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['id'])) {
    $id_info = $_GET['id'];

    // Cek apakah user adalah pembuat info atau admin
    $query = "SELECT i.*, u.username, u.nama_lengkap 
              FROM informasi i 
              LEFT JOIN users u ON i.created_by = u.id 
              WHERE i.id_info = ? AND i.status = 'aktif'";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id_info);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $info = mysqli_fetch_assoc($result);

    if (!$info) {
        echo json_encode(['success' => false, 'message' => 'Informasi tidak ditemukan']);
        exit();
    }

    // Cek hak akses
    if ($info['created_by'] != $_SESSION['user_id'] && $_SESSION['level'] != 'admin') {
        echo json_encode(['success' => false, 'message' => 'Anda tidak memiliki hak untuk mengedit informasi ini']);
        exit();
    }

    // Hapus field yang tidak perlu dikirim ke client
    unset($info['status']);
    unset($info['username']);
    unset($info['nama_lengkap']);

    echo json_encode($info);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
