<?php
session_start();
require_once '../../config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: ../../403.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        mysqli_begin_transaction($conn);
        
        $kop_fields = ['kop_surat_1', 'kop_surat_2', 'kop_surat_3'];
        $upload_dir = '../../assets/img/kop/';
        $allowed_types = ['image/jpeg', 'image/png'];
        $max_size = 2 * 1024 * 1024; // 2MB
        
        foreach ($kop_fields as $field) {
            if (isset($_FILES[$field]) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {
                $file = $_FILES[$field];
                
                // Validasi tipe file
                if (!in_array($file['type'], $allowed_types)) {
                    throw new Exception("Tipe file tidak didukung untuk $field. Gunakan JPG atau PNG.");
                }
                
                // Validasi ukuran
                if ($file['size'] > $max_size) {
                    throw new Exception("Ukuran file terlalu besar untuk $field. Maksimal 2MB.");
                }
                
                // Upload file
                $filename = $field . '.png';
                $filepath = $upload_dir . $filename;
                
                if (move_uploaded_file($file['tmp_name'], $filepath)) {
                    mysqli_query($conn, "UPDATE pengaturan SET nilai = '$filename' WHERE kode = '$field'");
                } else {
                    throw new Exception("Gagal mengupload file untuk $field.");
                }
            }
        }
        
        mysqli_commit($conn);
        $_SESSION['success'] = "Kop surat berhasil diperbarui!";
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $_SESSION['error'] = "Gagal memperbarui kop surat: " . $e->getMessage();
    }
    
    header("Location: ../pengaturan.php");
    exit();
} 