<?php
session_start();
require_once '../../config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: ../../403.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Update logo instansi jika ada
        if (isset($_FILES['logo_instansi']) && $_FILES['logo_instansi']['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES['logo_instansi'];
            $allowed_types = ['image/jpeg', 'image/png'];
            $max_size = 2 * 1024 * 1024; // 2MB
            
            if (!in_array($file['type'], $allowed_types)) {
                throw new Exception('Tipe file tidak didukung. Gunakan JPG atau PNG.');
            }
            
            if ($file['size'] > $max_size) {
                throw new Exception('Ukuran file terlalu besar. Maksimal 2MB.');
            }
            
            $upload_dir = '../../assets/img/';
            $filename = 'logo.png';
            $filepath = $upload_dir . $filename;
            
            if (move_uploaded_file($file['tmp_name'], $filepath)) {
                mysqli_query($conn, "UPDATE pengaturan SET nilai = '$filename' WHERE kode = 'logo_instansi'");
                $_SESSION['success'] = "Logo instansi berhasil diperbarui!";
            } else {
                throw new Exception('Gagal mengupload file.');
            }
        } else {
            throw new Exception('Tidak ada file yang diupload.');
        }
    } catch (Exception $e) {
        $_SESSION['error'] = "Gagal memperbarui logo: " . $e->getMessage();
    }
    
    header("Location: ../pengaturan.php");
    exit();
} 