<?php
session_start();
require_once '../../config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: ../../403.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Update maintenance mode
        $maintenance_mode = isset($_POST['maintenance_mode']) ? '1' : '0';
        $maintenance_message = mysqli_real_escape_string($conn, $_POST['maintenance_message']);

        // Update maintenance mode
        $query = "UPDATE pengaturan SET nilai = ? WHERE kode = 'maintenance_mode'";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "s", $maintenance_mode);
        mysqli_stmt_execute($stmt);

        // Update maintenance message
        $query = "UPDATE pengaturan SET nilai = ? WHERE kode = 'maintenance_message'";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "s", $maintenance_message);
        mysqli_stmt_execute($stmt);

        $_SESSION['success'] = "Pengaturan maintenance berhasil diperbarui!";
    } catch (Exception $e) {
        $_SESSION['error'] = "Gagal memperbarui pengaturan maintenance: " . $e->getMessage();
    }

    // Redirect kembali ke halaman pengaturan
    header("Location: ../pengaturan.php");
    exit();
} 