<?php
session_start();
require_once '../config/koneksi.php';
require_once '../config/whatsapp.php';

header('Content-Type: application/json');

// Debug log
error_log('Approve user request received: ' . json_encode($_POST));

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    error_log('Unauthorized access attempt');
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized access']);
    exit();
}

if (!isset($_POST['user_id']) || empty($_POST['user_id'])) {
    error_log('Invalid user ID');
    echo json_encode(['status' => 'error', 'message' => 'User ID tidak valid']);
    exit();
}

try {
    $user_id = $_POST['user_id'];
    
    // Ambil data user termasuk OTP
    $stmt = $conn->prepare("SELECT no_wa, otp FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    
    if (!$user) {
        throw new Exception("User tidak ditemukan");
    }

    // Update status user menjadi active
    $stmt = $conn->prepare("UPDATE users SET status = 'active' WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    
    if ($stmt->execute()) {
        // Kirim notifikasi WhatsApp
        $message = "Selamat! Akun SPPD Anda telah disetujui oleh admin.\n";
        $message .= "Silakan gunakan kode OTP berikut untuk verifikasi: " . $user['otp'] . "\n";
        $message .= "Anda sekarang dapat login ke sistem menggunakan username dan password yang telah didaftarkan.";
        
        try {
            sendWAMessage($user['no_wa'], $message);
            error_log('WhatsApp message sent successfully to: ' . $user['no_wa']);
        } catch (Exception $e) {
            error_log('Error sending WhatsApp message: ' . $e->getMessage());
        }
        
        echo json_encode([
            'status' => 'success',
            'message' => 'User berhasil disetujui dan OTP telah dikirim',
            'otp' => $user['otp']
        ]);
        error_log('User approved successfully. User ID: ' . $user_id);
    } else {
        throw new Exception("Gagal mengupdate status user");
    }
    
} catch (Exception $e) {
    error_log('Error in approve_user.php: ' . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
    if (isset($conn)) {
        $conn->close();
    }
} 