<?php
session_start();
require_once '../config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: ../403.php");
    exit();
}

// Inisialisasi array untuk menyimpan pengaturan
$settings = [];

// Query untuk mengambil pengaturan dari database
$query = "SELECT * FROM pengaturan ORDER BY id ASC";
$result = mysqli_query($conn, $query);

while ($row = mysqli_fetch_assoc($result)) {
    $settings[$row['kode']] = $row['nilai'];
}

// Handling AJAX request untuk maintenance mode
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['maintenance_mode'])) {
    try {
        $maintenance_mode = $_POST['maintenance_mode'] === '1' ? '1' : '0';
        $query = "UPDATE pengaturan SET nilai = ? WHERE kode = 'maintenance_mode'";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "s", $maintenance_mode);
        
        if (mysqli_stmt_execute($stmt)) {
            if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 
                strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
                // Jika request AJAX
                header('Content-Type: application/json');
                echo json_encode(['success' => true]);
                exit;
            }
        } else {
            throw new Exception("Gagal mengupdate status maintenance");
        }
    } catch (Exception $e) {
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 
            strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
            // Jika request AJAX
            header('Content-Type: application/json');
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            exit;
        }
    }
}

// Proses update pengaturan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        mysqli_begin_transaction($conn);
        
        // Update nama instansi
        if (isset($_POST['nama_instansi'])) {
            $nama_instansi = mysqli_real_escape_string($conn, $_POST['nama_instansi']);
            mysqli_query($conn, "UPDATE pengaturan SET nilai = '$nama_instansi' WHERE kode = 'nama_instansi'");
        }
        
        // Update alamat instansi
        if (isset($_POST['alamat_instansi'])) {
            $alamat_instansi = mysqli_real_escape_string($conn, $_POST['alamat_instansi']);
            mysqli_query($conn, "UPDATE pengaturan SET nilai = '$alamat_instansi' WHERE kode = 'alamat_instansi'");
        }
        
        // Update email instansi
        if (isset($_POST['email_instansi'])) {
            $email_instansi = mysqli_real_escape_string($conn, $_POST['email_instansi']);
            mysqli_query($conn, "UPDATE pengaturan SET nilai = '$email_instansi' WHERE kode = 'email_instansi'");
        }
        
        // Update telepon instansi
        if (isset($_POST['telepon_instansi'])) {
            $telepon_instansi = mysqli_real_escape_string($conn, $_POST['telepon_instansi']);
            mysqli_query($conn, "UPDATE pengaturan SET nilai = '$telepon_instansi' WHERE kode = 'telepon_instansi'");
        }
        
        // Update maintenance mode
        if (isset($_POST['maintenance_mode'])) {
            $maintenance_mode = $_POST['maintenance_mode'] === '1' ? '1' : '0';
            $query = "UPDATE pengaturan SET nilai = ? WHERE kode = 'maintenance_mode'";
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "s", $maintenance_mode);
            mysqli_stmt_execute($stmt);
        } else {
            // Jika checkbox tidak dicentang, set nilai ke 0
            $query = "UPDATE pengaturan SET nilai = '0' WHERE kode = 'maintenance_mode'";
            mysqli_query($conn, $query);
        }

        // Update maintenance message
        if (isset($_POST['maintenance_message'])) {
            $maintenance_message = mysqli_real_escape_string($conn, $_POST['maintenance_message']);
            $query = "UPDATE pengaturan SET nilai = ? WHERE kode = 'maintenance_message'";
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "s", $maintenance_message);
            mysqli_stmt_execute($stmt);
        }
        
        // Update kop surat
        $kop_fields = ['kop_surat_1', 'kop_surat_2', 'kop_surat_3'];
        foreach ($kop_fields as $field) {
            if (isset($_FILES[$field]) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {
                $file = $_FILES[$field];
                $allowed_types = ['image/jpeg', 'image/png'];
                $max_size = 2 * 1024 * 1024; // 2MB
                
                if (!in_array($file['type'], $allowed_types)) {
                    throw new Exception('Tipe file tidak didukung. Gunakan JPG atau PNG.');
                }
                
                if ($file['size'] > $max_size) {
                    throw new Exception('Ukuran file terlalu besar. Maksimal 2MB.');
                }
                
                $upload_dir = '../assets/img/kop/';
                $filename = $field . '.png';
                $filepath = $upload_dir . $filename;
                
                if (move_uploaded_file($file['tmp_name'], $filepath)) {
                    mysqli_query($conn, "UPDATE pengaturan SET nilai = '$filename' WHERE kode = '$field'");
                } else {
                    throw new Exception('Gagal mengupload file.');
                }
            }
        }
        
        mysqli_commit($conn);
        $_SESSION['success'] = "Pengaturan berhasil diperbarui!";
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $_SESSION['error'] = "Gagal memperbarui pengaturan: " . $e->getMessage();
    }
    
    header("Location: pengaturan.php");
    exit();
}

// Array untuk pilihan font
$fonts = [
    'Times New Roman' => 'Times New Roman',
    'Arial' => 'Arial',
    'Tahoma' => 'Tahoma',
    'Verdana' => 'Verdana',
    'Calibri' => 'Calibri'
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan Sistem - SPPD</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .preview-kop {
            border: 1px solid #ddd;
            padding: 20px;
            margin-top: 20px;
            background: white;
        }
        .preview-kop p {
            margin: 0;
            text-align: center;
        }
        .current-kop img {
            max-height: 200px;
            width: auto;
            object-fit: contain;
        }
        .current-kop .border {
            background: #f8f9fa;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="content">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col">
                    <h2 class="page-title">Pengaturan Sistem</h2>
                </div>
            </div>
            
            <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= $_SESSION['success'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
                </div>
                <?php unset($_SESSION['success']); ?>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= $_SESSION['error'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
                </div>
                <?php unset($_SESSION['error']); ?>
            <?php endif; ?>
            
            <!-- Card Groups -->
            <div class="row">
                <div class="col-md-8">
                    <!-- Card Group: Informasi Instansi -->
                    <div class="card-group mb-4">
                        <div class="card">
                            <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                                <h5 class="card-title mb-0 text-white">
                                    <i class="bi bi-building me-2"></i>Informasi Instansi
                                </h5>
                            </div>
                            <div class="card-body">
                                <form action="actions/update_instansi.php" method="POST" class="needs-validation" novalidate>
                                    <div class="mb-3">
                                        <label for="nama_instansi" class="form-label">Nama Instansi</label>
                                        <input type="text" class="form-control" id="nama_instansi" name="nama_instansi" 
                                               value="<?= htmlspecialchars($settings['nama_instansi'] ?? '') ?>" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="alamat_instansi" class="form-label">Alamat Instansi</label>
                                        <textarea class="form-control" id="alamat_instansi" name="alamat_instansi" 
                                                  rows="3" required><?= htmlspecialchars($settings['alamat_instansi'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="email_instansi" class="form-label">Email Instansi</label>
                                        <input type="email" class="form-control" id="email_instansi" name="email_instansi" 
                                               value="<?= htmlspecialchars($settings['email_instansi'] ?? '') ?>" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="telepon_instansi" class="form-label">Nomor Telepon Instansi</label>
                                        <input type="text" class="form-control" id="telepon_instansi" name="telepon_instansi" 
                                               value="<?= htmlspecialchars($settings['telepon_instansi'] ?? '') ?>" required>
                                    </div>

                                    <div class="text-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save me-2"></i>Simpan Informasi Instansi
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Card Group: Logo & Maintenance -->
                    <div class="card-group mb-4">
                        <!-- Logo Card -->
                        <div class="card">
                            <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                                <h5 class="card-title mb-0 text-white">
                                    <i class="bi bi-image me-2"></i>Logo Instansi
                                </h5>
                            </div>
                            <div class="card-body">
                                <form action="actions/update_logo.php" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                                    <div class="mb-3">
                                        <label for="logo_instansi" class="form-label">Upload Logo</label>
                                        <input type="file" class="form-control" id="logo_instansi" name="logo_instansi" accept="image/jpeg,image/png">
                                        <div class="form-text">Format yang diizinkan: JPG/PNG, Ukuran maksimal: 2MB</div>
                                    </div>
                                    
                                    <?php if (!empty($settings['logo_instansi'])): ?>
                                    <div class="mb-3">
                                        <label class="form-label">Logo Saat Ini</label>
                                        <div>
                                            <img src="../assets/img/<?= htmlspecialchars($settings['logo_instansi']) ?>" 
                                                 alt="Logo Instansi" class="img-thumbnail" style="max-height: 100px;">
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <div class="text-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save me-2"></i>Simpan Logo
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Maintenance Card -->
                        <div class="card">
                            <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                                <h5 class="card-title mb-0 text-white">
                                    <i class="bi bi-tools me-2"></i>Pengaturan Maintenance
                                </h5>
                            </div>
                            <div class="card-body">
                                <form action="actions/update_maintenance.php" method="POST" class="needs-validation" novalidate>
                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="maintenance_mode" 
                                                   name="maintenance_mode" value="1" 
                                                   <?= isset($settings['maintenance_mode']) && $settings['maintenance_mode'] === '1' ? 'checked' : '' ?>>
                                            <label class="form-check-label" for="maintenance_mode">
                                                Aktifkan Mode Maintenance
                                            </label>
                                        </div>
                                        <div class="form-text text-danger">
                                            <i class="bi bi-exclamation-triangle-fill me-1"></i>
                                            Mengaktifkan mode ini akan menonaktifkan akses ke aplikasi untuk semua pengguna kecuali admin.
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="maintenance_message" class="form-label">Pesan Maintenance</label>
                                        <textarea class="form-control" id="maintenance_message" name="maintenance_message" 
                                                  rows="3"><?= htmlspecialchars($settings['maintenance_message'] ?? 'Sistem sedang dalam pemeliharaan. Silakan coba beberapa saat lagi.') ?></textarea>
                                        <div class="form-text">
                                            Pesan ini akan ditampilkan kepada pengguna saat mode maintenance aktif.
                                        </div>
                                    </div>

                                    <div class="text-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save me-2"></i>Simpan Pengaturan Maintenance
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Card Group: Kop Surat -->
                    <div class="card-group mb-4">
                        <div class="card">
                            <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                                <h5 class="card-title mb-0 text-white">
                                    <i class="bi bi-file-text me-2"></i>Pengaturan Kop Surat
                                </h5>
                            </div>
                            <div class="card-body">
                                <form action="actions/update_kop.php" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                                    <!-- Kop Surat 1 -->
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">Kop Surat 1 (Utama)</label>
                                        <div class="mb-3">
                                            <input type="file" class="form-control" id="kop_surat_1" name="kop_surat_1" accept="image/jpeg,image/png">
                                            <div class="form-text">Format: JPG/PNG, Ukuran maksimal: 2MB, Dimensi yang disarankan: 2480 x 3508 pixels (A4)</div>
                                        </div>
                                        <?php if (!empty($settings['kop_surat_1'])): ?>
                                        <div class="current-kop mb-3">
                                            <label class="form-label">Kop Surat Saat Ini:</label>
                                            <div class="border rounded p-2">
                                                <img src="../assets/img/kop/<?= htmlspecialchars($settings['kop_surat_1']) ?>" 
                                                     alt="Kop Surat 1" class="img-fluid">
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Kop Surat 2 -->
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">Kop Surat 2 (Alternatif)</label>
                                        <div class="mb-3">
                                            <input type="file" class="form-control" id="kop_surat_2" name="kop_surat_2" accept="image/jpeg,image/png">
                                            <div class="form-text">Format: JPG/PNG, Ukuran maksimal: 2MB, Dimensi yang disarankan: 2480 x 3508 pixels (A4)</div>
                                        </div>
                                        <?php if (!empty($settings['kop_surat_2'])): ?>
                                        <div class="current-kop mb-3">
                                            <label class="form-label">Kop Surat Saat Ini:</label>
                                            <div class="border rounded p-2">
                                                <img src="../assets/img/kop/<?= htmlspecialchars($settings['kop_surat_2']) ?>" 
                                                     alt="Kop Surat 2" class="img-fluid">
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Kop Surat 3 -->
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">Kop Surat 3 (Alternatif)</label>
                                        <div class="mb-3">
                                            <input type="file" class="form-control" id="kop_surat_3" name="kop_surat_3" accept="image/jpeg,image/png">
                                            <div class="form-text">Format: JPG/PNG, Ukuran maksimal: 2MB, Dimensi yang disarankan: 2480 x 3508 pixels (A4)</div>
                                        </div>
                                        <?php if (!empty($settings['kop_surat_3'])): ?>
                                        <div class="current-kop mb-3">
                                            <label class="form-label">Kop Surat Saat Ini:</label>
                                            <div class="border rounded p-2">
                                                <img src="../assets/img/kop/<?= htmlspecialchars($settings['kop_surat_3']) ?>" 
                                                     alt="Kop Surat 3" class="img-fluid">
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="text-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save me-2"></i>Simpan Kop Surat
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Informasi Sistem Card -->
                <div class="col-md-4">
                    <div class="card sticky-top" style="top: 1rem;">
                        <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                            <h5 class="card-title mb-0 text-white">
                                <i class="bi bi-info-circle me-2"></i>Informasi Sistem
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><i class="bi bi-filetype-php me-2"></i>Versi PHP</td>
                                        <td>: <?= PHP_VERSION ?></td>
                                    </tr>
                                    <tr>
                                        <td><i class="bi bi-database me-2"></i>Versi MySQL</td>
                                        <td>: <?= mysqli_get_server_info($conn) ?></td>
                                    </tr>
                                    <tr>
                                        <td><i class="bi bi-pc me-2"></i>Sistem Operasi</td>
                                        <td>: <?= PHP_OS ?></td>
                                    </tr>
                                    <tr>
                                        <td><i class="bi bi-upload me-2"></i>Batas Unggah</td>
                                        <td>: <?= ini_get('upload_max_filesize') ?></td>
                                    </tr>
                                    <tr>
                                        <td><i class="bi bi-arrow-up-circle me-2"></i>Batas Kirim Data</td>
                                        <td>: <?= ini_get('post_max_size') ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <style>
            .card-group {
                gap: 1rem;
            }

            .card-group > .card {
                margin: 0;
                border: none;
                border-radius: 15px !important;
                box-shadow: 0 0 20px rgba(0,0,0,0.08);
            }

            .card-header {
                border-radius: 15px 15px 0 0 !important;
                border-bottom: none;
                padding: 1rem 1.5rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .form-label {
                font-weight: 500;
                color: #374151;
            }

            .form-control, .form-select {
                border-radius: 8px;
                border: 1px solid #e5e7eb;
                padding: 0.5rem 1rem;
            }

            .form-control:focus, .form-select:focus {
                border-color: #0ea5e9;
                box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.15);
            }

            .preview-kop {
                background: white;
                border: 1px solid #e5e7eb;
                border-radius: 8px;
                padding: 2rem;
            }

            .btn-primary {
                background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
                border: none;
                padding: 0.75rem 1.5rem;
                font-weight: 500;
            }

            .btn-primary:hover {
                background: linear-gradient(135deg, #0891cf 0%, #26bba8 100%);
                transform: translateY(-1px);
            }

            .table td {
                padding: 0.75rem 0;
                color: #374151;
            }

            .table td:first-child {
                font-weight: 500;
            }

            .current-kop img {
                max-height: 200px;
                width: auto;
                object-fit: contain;
            }

            .current-kop .border {
                background: #f8f9fa;
            }

            /* Responsive adjustments */
            @media (max-width: 768px) {
                .card-group {
                    flex-direction: column;
                }
                
                .card-group > .card {
                    margin-bottom: 1rem;
                }
                
                .sticky-top {
                    position: relative !important;
                    top: 0 !important;
                }
            }
            </style>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="../assets/js/script.js"></script>
    
    <script>
    // Preview kop surat saat input berubah
    document.querySelectorAll('#kop_line1, #kop_line2, #kop_line3, #kop_font_size, #kop_font_family, #kop_line_spacing').forEach(input => {
        input.addEventListener('input', updateKopPreview);
    });

    function updateKopPreview() {
        const preview = document.querySelector('#kopPreview p');
        const line1 = document.querySelector('#kop_line1').value;
        const line2 = document.querySelector('#kop_line2').value;
        const line3 = document.querySelector('#kop_line3').value;
        const fontSize = document.querySelector('#kop_font_size').value;
        const fontFamily = document.querySelector('#kop_font_family').value;
        const lineSpacing = document.querySelector('#kop_line_spacing').value;
        
        preview.style.fontFamily = fontFamily;
        preview.style.fontSize = fontSize + 'px';
        preview.style.lineHeight = lineSpacing;
        preview.innerHTML = `${line1}<br>${line2}<br>${line3}`;
    }

    // Fungsi untuk mengupdate maintenance mode
    function updateMaintenanceMode(isChecked) {
        const formData = new FormData();
        formData.append('maintenance_mode', isChecked ? '1' : '0');
        
        fetch('pengaturan.php', {
            method: 'POST',
            body: formData
        }).then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            console.log('Maintenance mode updated successfully');
        }).catch(error => {
            console.error('Error:', error);
            alert('Gagal mengupdate mode maintenance');
        });
    }

    // Event listener untuk checkbox
    document.getElementById('maintenance_mode').addEventListener('change', function() {
        updateMaintenanceMode(this.checked);
    });
    </script>

    <!-- Modal Konfirmasi Password -->
    <div class="modal fade" id="passwordModal" tabindex="-1" aria-labelledby="passwordModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="passwordModalLabel">Konfirmasi Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Masukkan Password</label>
                        <input type="password" class="form-control" id="confirm_password" placeholder="Masukkan password untuk konfirmasi">
                        <div class="invalid-feedback">
                            Password tidak valid!
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-primary" id="confirmPasswordBtn">Konfirmasi</button>
                </div>
            </div>
        </div>
    </div>

    <script>
    // Tambahkan script sebelum penutup </body>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');
        const passwordModal = new bootstrap.Modal(document.getElementById('passwordModal'));
        const confirmPasswordBtn = document.getElementById('confirmPasswordBtn');
        const confirmPasswordInput = document.getElementById('confirm_password');
        const correctPassword = 'dinaspendidikan###';
        
        // Mencegah form submit langsung
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            passwordModal.show();
        });
        
        // Handle konfirmasi password
        confirmPasswordBtn.addEventListener('click', function() {
            const inputPassword = confirmPasswordInput.value;
            
            if (inputPassword === correctPassword) {
                // Password benar, submit form
                passwordModal.hide();
                form.removeEventListener('submit', arguments.callee);
                form.submit();
            } else {
                // Password salah, tampilkan error
                confirmPasswordInput.classList.add('is-invalid');
                setTimeout(() => {
                    confirmPasswordInput.classList.remove('is-invalid');
                }, 3000);
            }
        });
        
        // Reset invalid state saat modal ditutup
        document.getElementById('passwordModal').addEventListener('hidden.bs.modal', function() {
            confirmPasswordInput.value = '';
            confirmPasswordInput.classList.remove('is-invalid');
        });
        
        // Reset invalid state saat mulai mengetik
        confirmPasswordInput.addEventListener('input', function() {
            this.classList.remove('is-invalid');
        });
        
        // Handle enter key pada input password
        confirmPasswordInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                confirmPasswordBtn.click();
            }
        });
    });
    </script>

    <style>
    /* Tambahkan style untuk modal */
    .modal-content {
        border: none;
        border-radius: 15px;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }

    .modal-header {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        color: white;
        border-radius: 15px 15px 0 0;
        border-bottom: none;
    }

    .modal-footer {
        border-top: none;
        padding: 1rem;
    }

    .btn-primary {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        border: none;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, #0891cf 0%, #26bba8 100%);
        transform: translateY(-1px);
    }

    .form-control:focus {
        border-color: #0ea5e9;
        box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.15);
    }

    .modal-body {
        padding: 1.5rem;
    }

    .invalid-feedback {
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
    </style>
</body>
</html> 