<?php
session_start();
require_once '../config/koneksi.php';
require_once '../config/whatsapp.php';

header('Content-Type: application/json');

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized access']);
    exit();
}

if (!isset($_POST['user_id']) || empty($_POST['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'User ID tidak valid']);
    exit();
}

try {
    $user_id = $_POST['user_id'];
    
    // Ambil nomor WA user sebelum menghapus
    $stmt = $conn->prepare("SELECT no_wa FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    
    if ($user) {
        // Hapus user dari database
        $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
        $stmt->bind_param("i", $user_id);
        
        if ($stmt->execute()) {
            // Kirim notifikasi WhatsApp
            $message = "Mohon maaf, pendaftaran akun SPPD Anda tidak disetujui oleh admin.\n";
            $message .= "Silakan hubungi admin untuk informasi lebih lanjut.";
            
            sendWAMessage($user['no_wa'], $message);
            
            echo json_encode([
                'status' => 'success',
                'message' => 'User berhasil ditolak'
            ]);
        } else {
            throw new Exception("Gagal menghapus user");
        }
    } else {
        throw new Exception("User tidak ditemukan");
    }
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
    if (isset($conn)) {
        $conn->close();
    }
} 