<?php
session_start();
require_once '../config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: ../403.php");
    exit();
}

// Konstanta untuk password restore
define('RESTORE_PASSWORD', 'dinaspendidikan###');

// Direktori untuk file backup
$backup_dir = "../backups/";

// Fungsi untuk memvalidasi file SQL
function validateSQLFile($file) {
    $allowed_extensions = ['sql'];
    $file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    
    if (!in_array($file_extension, $allowed_extensions)) {
        return "File harus berekstensi .sql";
    }
    
    if ($file['size'] > 50 * 1024 * 1024) { // 50MB limit
        return "Ukuran file tidak boleh lebih dari 50MB";
    }
    
    return null;
}

// Proses restore database
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['backup_file']) && isset($_POST['password'])) {
    // Validasi password
    if ($_POST['password'] !== RESTORE_PASSWORD) {
        $_SESSION['error'] = "Password tidak valid!";
        header("Location: restore.php");
        exit();
    }

    $error = validateSQLFile($_FILES['backup_file']);
    
    if ($error === null) {
        try {
            // Baca isi file SQL
            $sql_content = file_get_contents($_FILES['backup_file']['tmp_name']);
            
            // Split SQL content into individual queries
            $queries = array_filter(array_map('trim', explode(';', $sql_content)));
            
            // Begin transaction
            mysqli_begin_transaction($conn);
            
            // Execute each query
            foreach ($queries as $query) {
                if (!empty($query)) {
                    if (!mysqli_query($conn, $query)) {
                        throw new Exception("Error executing query: " . mysqli_error($conn));
                    }
                }
            }
            
            // Commit transaction
            mysqli_commit($conn);
            
            $_SESSION['success'] = "Database berhasil direstore!";
        } catch (Exception $e) {
            // Rollback on error
            mysqli_rollback($conn);
            $_SESSION['error'] = "Gagal melakukan restore: " . $e->getMessage();
        }
    } else {
        $_SESSION['error'] = $error;
    }
    
    header("Location: restore.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restore Database - SPPD</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1040;
            width: 100vw;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.5);
        }

        .modal {
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1050;
            width: 100%;
            height: 100%;
            overflow-x: hidden;
            overflow-y: auto;
            outline: 0;
        }

        .modal-dialog {
            position: relative;
            width: auto;
            margin: 1.75rem auto;
            pointer-events: none;
        }
        
        .modal-content {
            border-radius: 15px;
            border: none;
            position: relative;
            display: flex;
            flex-direction: column;
            width: 100%;
            pointer-events: auto;
            background-color: #fff;
            background-clip: padding-box;
            outline: 0;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            border: none;
        }
        
        .modal-title {
            font-weight: 600;
        }
        
        .form-control:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
        }

        .modal-backdrop.show {
            opacity: 0.5;
        }

        body.modal-open {
            overflow: hidden;
            padding-right: 0 !important;
        }

        /* Animasi untuk modal */
        .modal.fade .modal-dialog {
            transition: transform 0.3s ease-out;
            transform: translate(0, -50px);
        }

        .modal.show .modal-dialog {
            transform: none;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="content">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col">
                    <h2 class="page-title">Restore Database</h2>
                </div>
            </div>
            
            <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= $_SESSION['success'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success']); ?>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= $_SESSION['error'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error']); ?>
            <?php endif; ?>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Upload File Backup</h5>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#restoreModal">
                                <i class="bi bi-upload me-2"></i>Restore Database
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Petunjuk Restore Database</h5>
                            <ol>
                                <li>Pastikan Anda memiliki file backup database dengan format .sql</li>
                                <li>File backup harus merupakan hasil backup dari sistem SPPD ini</li>
                                <li>Proses restore akan menimpa seluruh data yang ada saat ini</li>
                                <li>Pastikan file backup tidak rusak atau termodifikasi</li>
                                <li>Disarankan untuk membuat backup terlebih dahulu sebelum melakukan restore</li>
                                <li>Masukkan password yang valid untuk melakukan restore</li>
                            </ol>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <strong>Perhatian!</strong> Proses restore akan menghapus seluruh data yang ada saat ini dan menggantinya dengan data dari file backup.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Restore -->
    <div class="modal fade" id="restoreModal" tabindex="-1" aria-labelledby="restoreModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="restoreModalLabel">Restore Database</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="restore.php" method="POST" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="backup_file" class="form-label">Pilih File SQL Backup</label>
                            <input type="file" class="form-control" id="backup_file" name="backup_file" accept=".sql" required>
                            <div class="form-text">File harus berekstensi .sql dan maksimal 50MB</div>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Masukkan Password untuk Restore</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Restore</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- jQuery (diperlukan untuk Bootstrap) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="../assets/js/script.js"></script>
    <script>
        // Validasi file sebelum upload
        document.getElementById('backup_file').addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                if (file.name.toLowerCase().endsWith('.sql')) {
                    // File valid
                } else {
                    alert('Hanya file .sql yang diperbolehkan!');
                    this.value = ''; // Reset input file
                }
            }
        });

        // Pastikan modal berfungsi dengan benar
        document.addEventListener('DOMContentLoaded', function() {
            const modal = new bootstrap.Modal(document.getElementById('restoreModal'));
            
            // Reset form saat modal ditutup
            document.getElementById('restoreModal').addEventListener('hidden.bs.modal', function () {
                document.querySelector('form').reset();
            });
        });
    </script>
</body>
</html> 