<?php
session_start();
require_once '../config/koneksi.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: ../403.php");
    exit();
}

// Ambil daftar user pending
$query = "SELECT id, nama_lengkap, no_wa, username, level, bidang, otp, created_at 
          FROM users 
          WHERE status = 'pending' 
          ORDER BY created_at DESC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verifikasi User - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
    
    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg,rgb(239, 255, 253) 0%,rgb(218, 249, 255) 100%);
        }

        .home-section {
            background: linear-gradient(135deg,rgb(231, 255, 255) 0%,rgb(236, 255, 246) 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .card {
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            margin: 20px auto;
            background: white;
            max-width: 1200px;
            width: 95%;
        }

        .card-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 1rem 1.5rem;
            border: none;
        }

        .card-body {
            padding: 1rem;
        }

        .table-title {
            color: #1e293b;
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 0.8rem;
            padding-left: 0.5rem;
            border-left: 4px solid #0ea5e9;
        }

        .table {
            margin-bottom: 0;
            font-size: 0.85rem;
        }

        .table th {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            font-weight: 500;
            border: none;
            padding: 0.6rem 0.8rem;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }

        .table td {
            padding: 0.6rem 0.8rem;
            vertical-align: middle;
            border-bottom: 1px solid #e9ecef;
            color: #495057;
            white-space: nowrap;
        }

        .badge {
            padding: 0.3em 0.6em;
            border-radius: 4px;
            font-weight: 500;
            font-size: 0.75rem;
        }

        .badge-pending {
            background-color: #fef3c7;
            color: #d97706;
        }

        .btn-action {
            padding: 0.3rem 0.6rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 500;
            margin: 0 0.15rem;
        }

        .btn-approve {
            background-color: #10b981;
            border: none;
            color: white;
        }

        .btn-approve:hover {
            background-color: #059669;
        }

        .btn-reject {
            background-color: #ef4444;
            border: none;
            color: white;
        }

        .btn-reject:hover {
            background-color: #dc2626;
        }

        .btn-copy {
            padding: 0.2rem 0.4rem;
            background: transparent;
            border: 1px solid #e5e7eb;
            color: #6b7280;
            border-radius: 4px;
            margin-left: 0.3rem;
            font-size: 0.75rem;
        }

        .table-container {
            margin: 0.5rem;
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
            overflow: hidden;
        }

        .table-responsive {
            margin-bottom: 0;
        }

        .table {
            margin-bottom: 0;
            width: 100%;
        }

        .table th {
            white-space: nowrap;
            padding: 0.75rem !important;
            font-size: 0.8rem;
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            font-weight: 500;
        }

        .table td {
            padding: 0.75rem !important;
            vertical-align: middle;
            font-size: 0.85rem;
        }

        .btn-action {
            padding: 0.4rem 0.6rem !important;
            border-radius: 6px;
            font-size: 0.8rem;
            margin: 0 0.15rem;
            min-width: 32px;
        }

        .btn-approve, .btn-reject {
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .text-truncate {
            max-width: 150px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        @media (max-width: 768px) {
            .card {
                margin: 10px;
                width: auto;
            }

            .table-container {
                margin: 0;
            }

            .table th,
            .table td {
                padding: 0.5rem !important;
            }

            .btn-action {
                padding: 0.35rem 0.5rem !important;
                font-size: 0.75rem;
                min-width: 28px;
            }

            .text-truncate {
                max-width: 100px;
            }

            .table {
                font-size: 0.8rem;
            }
        }

        @media (max-width: 576px) {
            .card-body {
                padding: 0.5rem;
            }

            .table-container {
                border-radius: 4px;
            }

            .text-truncate {
                max-width: 80px;
            }

            .btn-action {
                padding: 0.3rem 0.4rem !important;
                min-width: 24px;
            }
        }

        .otp-text {
            font-size: 0.8rem;
        }

        .btn-copy {
            padding: 0.15rem 0.3rem;
            font-size: 0.7rem;
        }

        .btn-action {
            padding: 0.25rem 0.4rem;
            font-size: 0.7rem;
        }

        .badge {
            font-size: 0.7rem;
            padding: 0.25em 0.5em;
        }

        .table-container {
            overflow-x: hidden;
        }

        .card {
            max-width: 1000px;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <section class="home-section">
        <div class="container-fluid">
            <div class="card">
                
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Verifikasi User</h5>
                </div>
                <div class="card-body p-2">
                <h6 class="table-title">Daftar User Pending</h6>
                    <div class="table-container">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Nama</th>
                                        <th>Username</th>
                                        <th>WhatsApp</th>
                                        <th>OTP</th>
                                        <th class="text-end">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $no = 1;
                                    while ($row = $result->fetch_assoc()): 
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td class="text-truncate" title="<?= htmlspecialchars($row['nama_lengkap']) ?>">
                                            <?= htmlspecialchars($row['nama_lengkap']) ?>
                                        </td>
                                        <td class="text-truncate" title="<?= htmlspecialchars($row['username']) ?>">
                                            <?= htmlspecialchars($row['username']) ?>
                                        </td>
                                        <td class="text-truncate" title="<?= htmlspecialchars($row['no_wa']) ?>">
                                            <?= htmlspecialchars($row['no_wa']) ?>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <small class="me-1"><?= $row['otp'] ?></small>
                                                <button type="button" class="btn-copy p-0 border-0" data-otp="<?= $row['otp'] ?>">
                                                    <i class="bi bi-clipboard"></i>
                                                </button>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <div class="d-flex gap-1 justify-content-end">
                                                <button type="button" class="btn btn-action btn-approve approve-user" 
                                                        data-id="<?= $row['id'] ?>" 
                                                        data-no_wa="<?= $row['no_wa'] ?>"
                                                        data-otp="<?= $row['otp'] ?>">
                                                    <i class="bi bi-check-lg"></i>
                                                </button>
                                                <button type="button" class="btn btn-action btn-reject reject-user"
                                                        data-id="<?= $row['id'] ?>" 
                                                        data-no_wa="<?= $row['no_wa'] ?>">
                                                    <i class="bi bi-x-lg"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- DataTables JS -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    $(document).ready(function() {
        // Initialize DataTable
        $('#userTable').DataTable({
            "responsive": true,
            "autoWidth": false,
            "language": {
                "lengthMenu": "Tampilkan _MENU_ data per halaman",
                "zeroRecords": "Data tidak ditemukan",
                "info": "Menampilkan halaman _PAGE_ dari _PAGES_",
                "infoEmpty": "Tidak ada data yang tersedia",
                "infoFiltered": "(difilter dari _MAX_ total data)",
                "search": "Cari:",
                "paginate": {
                    "first": "Pertama",
                    "last": "Terakhir",
                    "next": "Selanjutnya",
                    "previous": "Sebelumnya"
                }
            }
        });

        // Approve user
        $('.approve-user').on('click', function() {
            const userId = $(this).data('id');
            const userNoWa = $(this).data('no_wa');
            const userOtp = $(this).data('otp');
            const btn = $(this);

            Swal.fire({
                title: 'Setujui User?',
                text: `Apakah Anda yakin ingin menyetujui user dengan nomor WhatsApp ${userNoWa}?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#10b981',
                cancelButtonColor: '#ef4444',
                confirmButtonText: 'Ya, Setujui!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    btn.prop('disabled', true);
                    localStorage.setItem('pendingOTP', userOtp);

                    $.ajax({
                        url: 'approve_user.php',
                        type: 'POST',
                        data: { 
                            user_id: userId,
                            otp: userOtp 
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Berhasil!',
                                    text: 'User telah disetujui dan OTP telah dikirim via WhatsApp',
                                    timer: 1500
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                btn.prop('disabled', false);
                                localStorage.removeItem('pendingOTP');
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: response.message || 'Terjadi kesalahan saat menyetujui user'
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            btn.prop('disabled', false);
                            localStorage.removeItem('pendingOTP');
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Terjadi kesalahan pada server: ' + error
                            });
                        }
                    });
                }
            });
        });

        // Copy OTP
        $('.btn-copy').on('click', function() {
            const otp = $(this).data('otp');
            navigator.clipboard.writeText(otp).then(function() {
                Swal.fire({
                    icon: 'success',
                    title: 'OTP Disalin!',
                    text: 'Kode OTP berhasil disalin ke clipboard',
                    timer: 1500,
                    showConfirmButton: false,
                    toast: true,
                    position: 'top-end'
                });
            });
        });

        // Reject user
        $('.reject-user').on('click', function() {
            const userId = $(this).data('id');
            const userNoWa = $(this).data('no_wa');

            Swal.fire({
                title: 'Tolak User?',
                text: `Apakah Anda yakin ingin menolak user dengan nomor WhatsApp ${userNoWa}?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ef4444',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, Tolak!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: 'reject_user.php',
                        type: 'POST',
                        data: { user_id: userId },
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Berhasil!',
                                    text: 'User telah ditolak',
                                    timer: 1500
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: response.message || 'Terjadi kesalahan saat menolak user'
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Terjadi kesalahan pada server: ' + error
                            });
                        }
                    });
                }
            });
        });
    });
    </script>
</body>
</html> 