// Fungsi untuk menambah informasi
function addInfo() {
    const form = document.getElementById('addInfoForm');
    const formData = new FormData(form);
    formData.append('action', 'add');

    fetch('actions/info_actions.php', {
        method: 'POST',
        body: formData
    })
    .then(response => {
        if (response.ok) {
            location.reload();
        }
    });
}

// Fungsi untuk mengedit informasi
function editInfo(id) {
    // Ambil data informasi yang akan diedit
    fetch(`actions/get_info.php?id=${id}`)
    .then(response => response.json())
    .then(data => {
        document.getElementById('edit_id_info').value = data.id_info;
        document.getElementById('edit_judul').value = data.judul;
        document.getElementById('edit_isi').value = data.isi;
        document.getElementById('edit_prioritas').value = data.prioritas;
        
        // Tampilkan modal edit
        new bootstrap.Modal(document.getElementById('editInfoModal')).show();
    });
}

// Fungsi untuk menghapus informasi
function deleteInfo(id) {
    if (confirm('Apakah Anda yakin ingin menghapus informasi ini?')) {
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('id_info', id);

        fetch('actions/info_actions.php', {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    }
} 