<?php
session_start();
require_once 'config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: dashboard.php");
    exit();
}

// Konstanta untuk password backup
define('BACKUP_PASSWORD', 'dinaspendidikan###');

// Handle backup request dengan validasi password
if (isset($_POST['backup']) && isset($_POST['password'])) {
    if ($_POST['password'] === BACKUP_PASSWORD) {
        try {
            $file = backupDatabase($conn);
            $_SESSION['success'] = "Backup SQL berhasil dibuat: " . basename($file);
        } catch (Exception $e) {
            $_SESSION['error'] = "Error saat membuat backup SQL: " . $e->getMessage();
        }
    } else {
        $_SESSION['error'] = "Password tidak valid!";
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

// Fungsi untuk membuat backup database
function backupDatabase($conn, $tables = '*') {
    // Dapatkan semua tabel
    if ($tables == '*') {
        $tables = array();
        $result = $conn->query("SHOW TABLES");
        while ($row = $result->fetch_row()) {
            $tables[] = $row[0];
        }
    } else {
        $tables = is_array($tables) ? $tables : explode(',', $tables);
    }

    $return = "-- Database Backup SPPD System\n";
    $return .= "-- Generated: " . date('Y-m-d H:i:s') . "\n\n";

    // Iterate tables
    foreach ($tables as $table) {
        $result = $conn->query("SELECT * FROM $table");
        $numFields = $result->field_count;

        $return .= "DROP TABLE IF EXISTS $table;\n";
        $row2 = $conn->query("SHOW CREATE TABLE $table")->fetch_row();
        $return .= $row2[1] . ";\n\n";

        // Insert data
        while ($row = $result->fetch_row()) {
            $return .= "INSERT INTO $table VALUES(";
            for ($j = 0; $j < $numFields; $j++) {
                if (isset($row[$j])) {
                    $row[$j] = addslashes($row[$j]);
                    $row[$j] = str_replace("\n", "\\n", $row[$j]);
                    $return .= '"' . $row[$j] . '"';
                } else {
                    $return .= 'NULL';
                }
                if ($j < ($numFields - 1)) {
                    $return .= ',';
                }
            }
            $return .= ");\n";
        }
        $return .= "\n\n";
    }

    // Buat folder backup jika belum ada
    $backup_dir = "backups";
    if (!file_exists($backup_dir)) {
        mkdir($backup_dir, 0777, true);
    }

    // Simpan file
    $filename = $backup_dir . '/backup_' . date('Y-m-d_H-i-s') . '.sql';
    file_put_contents($filename, $return);
    return $filename;
}

// Get list of backup files
$backup_dir = "backups";
$backup_files = [];
if (file_exists($backup_dir)) {
    foreach (new DirectoryIterator($backup_dir) as $file) {
        if ($file->isFile() && $file->getExtension() == 'sql') {
            $backup_files[] = [
                'name' => $file->getFilename(),
                'size' => round($file->getSize() / 1024, 2), // Size in KB
                'date' => date('Y-m-d H:i:s', $file->getMTime()),
                'type' => $file->getExtension()
            ];
        }
    }
    // Sort by date descending
    usort($backup_files, function($a, $b) {
        return strtotime($b['date']) - strtotime($a['date']);
    });
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backup Database - SPPD</title>
    <?php include 'includes/header.php'; ?>
    <style>
        body {
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        
        .card-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border-radius: 15px 15px 0 0 !important;
            padding: 20px;
            border: none;
        }
        
        .card-header h5 {
            color: white;
            font-weight: 600;
            margin: 0;
            font-size: 1.25rem;
        }

        .table thead th {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: #fff;
            font-weight: 500;
            padding: 15px;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border: none;
            vertical-align: middle;
        }

        .btn-backup {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-backup:hover {
            background: linear-gradient(135deg, #0891ce 0%, #26bba8 100%);
            transform: translateY(-2px);
            color: white;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .btn-download {
            color: #0ea5e9;
            background-color: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.2);
            transition: all 0.3s ease;
        }

        .btn-download:hover {
            color: white;
            background-color: #0ea5e9;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(14, 165, 233, 0.2);
        }

        .btn-delete {
            color: #dc3545;
            background-color: rgba(220, 53, 69, 0.1);
            border: 1px solid rgba(220, 53, 69, 0.2);
            transition: all 0.3s ease;
        }

        .btn-delete:hover {
            color: white;
            background-color: #dc3545;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(220, 53, 69, 0.2);
        }

        .home-section {
            background: linear-gradient(135deg,rgb(231, 255, 255) 0%,rgb(236, 255, 246) 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .file-size {
            font-size: 0.875rem;
            color: #6c757d;
        }

        .backup-info {
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.2);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .backup-info p {
            margin-bottom: 8px;
            color: #1e293b;
        }

        .backup-info i {
            color: #0ea5e9;
            margin-right: 8px;
        }

        .backup-card {
            margin: 20px;
            padding: 20px;
            border-radius: 5px;
        }
        .backup-table {
            margin-top: 20px;
        }
        .btn-backup {
            margin-bottom: 20px;
        }
        .modal-content {
            border-radius: 15px;
            border: none;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            border: none;
        }
        
        .modal-title {
            font-weight: 600;
        }
        
        .form-control:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
        }
    </style>
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    <div class="main-content">
        <div class="container-fluid">
            <div class="card backup-card">
                <h4 class="card-title">Backup Database</h4>
                
                <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success">
                        <?= $_SESSION['success'] ?>
                        <?php unset($_SESSION['success']); ?>
                    </div>
                <?php endif; ?>

                <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger">
                        <?= $_SESSION['error'] ?>
                        <?php unset($_SESSION['error']); ?>
                    </div>
                <?php endif; ?>

                <div class="btn-backup">
                    <button type="button" class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#backupModal">
                        <i class="bi bi-download"></i> Backup SQL
                    </button>
                </div>

                <!-- Modal Backup -->
                <div class="modal fade" id="backupModal" tabindex="-1" aria-labelledby="backupModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="backupModalLabel">Konfirmasi Backup Database</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form method="post">
                                <div class="modal-body">
                                    <div class="mb-3">
                                        <label for="password" class="form-label">Masukkan Password untuk Backup</label>
                                        <input type="password" class="form-control" id="password" name="password" required>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                    <button type="submit" name="backup" class="btn btn-primary">Backup</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="table-responsive backup-table">
                    <table class="table table-bordered table-hover" id="backupTable">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama File</th>
                                <th>Ukuran (KB)</th>
                                <th>Tanggal</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($backup_files as $index => $file): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($file['name']) ?></td>
                                <td><?= $file['size'] ?></td>
                                <td><?= $file['date'] ?></td>
                                <td>
                                    <a href="backups/<?= urlencode($file['name']) ?>" 
                                       class="btn btn-sm btn-primary" 
                                       download>
                                        <i class="bi bi-download"></i> 
                                        Download
                                    </a>
                                    <a href="delete_backup.php?file=<?= urlencode($file['name']) ?>" 
                                       class="btn btn-sm btn-danger"
                                       onclick="return confirm('Apakah Anda yakin ingin menghapus file backup ini?')">
                                        <i class="fas fa-trash"></i> Hapus
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($backup_files)): ?>
                            <tr>
                                <td colspan="5" class="text-center">Belum ada file backup</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
    <script>
        $(document).ready(function() {
            $('#backupTable').DataTable({
                "order": [[3, "desc"]], // Sort by date column descending
                "pageLength": 10,
                "language": {
                    "lengthMenu": "Tampilkan _MENU_ data per halaman",
                    "zeroRecords": "Data tidak ditemukan",
                    "info": "Menampilkan halaman _PAGE_ dari _PAGES_",
                    "infoEmpty": "Tidak ada data yang tersedia",
                    "infoFiltered": "(difilter dari _MAX_ total data)",
                    "search": "Cari:",
                    "paginate": {
                        "first": "Pertama",
                        "last": "Terakhir",
                        "next": "Selanjutnya",
                        "previous": "Sebelumnya"
                    }
                }
            });
        });
    </script>
</body>
</html> 