-- Database Backup SPPD System
-- Generated: 2025-04-27 09:08:56

DROP TABLE IF EXISTS catatan;
CREATE TABLE `catatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `judul` varchar(255) NOT NULL,
  `isi` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL ON UPDATE current_timestamp(),
  `kategori` varchar(50) DEFAULT 'Umum',
  `status` enum('aktif','arsip') DEFAULT 'aktif',
  PRIMARY KEY (`id`),
  KEY `idx_catatan_user` (`user_id`),
  KEY `idx_catatan_kategori` (`kategori`),
  KEY `idx_catatan_status` (`status`),
  KEY `idx_catatan_created` (`created_at`),
  CONSTRAINT `catatan_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS chat_messages;
CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `info_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_info_id` (`info_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`info_id`) REFERENCES `informasi` (`id_info`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO chat_messages VALUES("25","40","71","tes tes chat","2025-04-26 14:53:51","2025-04-26 14:53:51");
INSERT INTO chat_messages VALUES("26","40","69","halooooo","2025-04-26 14:54:01","2025-04-26 14:54:01");
INSERT INTO chat_messages VALUES("27","40","71","halo juga rega","2025-04-26 14:54:09","2025-04-26 14:54:09");
INSERT INTO chat_messages VALUES("28","40","69","kypa","2025-04-27 08:38:42","2025-04-27 08:38:42");
INSERT INTO chat_messages VALUES("29","40","73","baik hja","2025-04-27 08:39:57","2025-04-27 08:39:57");
INSERT INTO chat_messages VALUES("30","42","73","siap","2025-04-27 08:55:58","2025-04-27 08:55:58");


DROP TABLE IF EXISTS detail_rekap_sppd;
CREATE TABLE `detail_rekap_sppd` (
  `id_detail_rekap` int(11) NOT NULL AUTO_INCREMENT,
  `id_rekap` int(11) DEFAULT NULL,
  `id_surat` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_detail_rekap`),
  KEY `id_rekap` (`id_rekap`),
  KEY `id_surat` (`id_surat`),
  CONSTRAINT `detail_rekap_sppd_ibfk_1` FOREIGN KEY (`id_rekap`) REFERENCES `rekap_sppd` (`id_rekap`),
  CONSTRAINT `detail_rekap_sppd_ibfk_2` FOREIGN KEY (`id_surat`) REFERENCES `surat_tugas` (`id_surat`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO detail_rekap_sppd VALUES("31","15","77");
INSERT INTO detail_rekap_sppd VALUES("32","15","76");
INSERT INTO detail_rekap_sppd VALUES("33","16","84");
INSERT INTO detail_rekap_sppd VALUES("34","16","83");
INSERT INTO detail_rekap_sppd VALUES("35","16","85");
INSERT INTO detail_rekap_sppd VALUES("38","18","88");
INSERT INTO detail_rekap_sppd VALUES("39","18","87");


DROP TABLE IF EXISTS detail_surat_tugas;
CREATE TABLE `detail_surat_tugas` (
  `id_detail` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` int(11) DEFAULT NULL,
  `id_pegawai` int(11) DEFAULT NULL,
  `tujuan_pegawai` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_detail`),
  KEY `id_surat` (`id_surat`),
  KEY `id_pegawai` (`id_pegawai`),
  CONSTRAINT `detail_surat_tugas_ibfk_1` FOREIGN KEY (`id_surat`) REFERENCES `surat_tugas` (`id_surat`),
  CONSTRAINT `detail_surat_tugas_ibfk_2` FOREIGN KEY (`id_pegawai`) REFERENCES `pegawai` (`id_pegawai`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO detail_surat_tugas VALUES("218","84","11456",NULL);
INSERT INTO detail_surat_tugas VALUES("219","85","11456",NULL);
INSERT INTO detail_surat_tugas VALUES("220","83","11456",NULL);
INSERT INTO detail_surat_tugas VALUES("238","88","11354","Smpn 4 Paringin");
INSERT INTO detail_surat_tugas VALUES("239","88","11343","Smpn 4 Paringin");
INSERT INTO detail_surat_tugas VALUES("240","88","11342","Smpn 1 Paringin");
INSERT INTO detail_surat_tugas VALUES("241","88","11357","Smpn 4 Paringin");
INSERT INTO detail_surat_tugas VALUES("242","88","11339","Smpn 1 Paringin");
INSERT INTO detail_surat_tugas VALUES("243","88","11337","Smpn 1 Paringin");
INSERT INTO detail_surat_tugas VALUES("244","88","11332","Smpn 1 Paringin");
INSERT INTO detail_surat_tugas VALUES("245","76","11317",NULL);
INSERT INTO detail_surat_tugas VALUES("246","76","11340",NULL);
INSERT INTO detail_surat_tugas VALUES("247","76","11357",NULL);
INSERT INTO detail_surat_tugas VALUES("248","76","11332",NULL);
INSERT INTO detail_surat_tugas VALUES("249","76","11319",NULL);
INSERT INTO detail_surat_tugas VALUES("254","87","11343","Smpn 1 Paringin");
INSERT INTO detail_surat_tugas VALUES("255","87","11332","Smpn 1 Paringin");
INSERT INTO detail_surat_tugas VALUES("259","77","11317",NULL);
INSERT INTO detail_surat_tugas VALUES("260","77","11357",NULL);
INSERT INTO detail_surat_tugas VALUES("261","77","11319",NULL);


DROP TABLE IF EXISTS file_uploads;
CREATE TABLE `file_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` int(11) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `upload_date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_surat` (`id_surat`),
  CONSTRAINT `file_uploads_ibfk_1` FOREIGN KEY (`id_surat`) REFERENCES `surat_tugas` (`id_surat`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO file_uploads VALUES("2","77","uploads/SPPD_0162_03_2025.pdf","2025-04-15 23:03:29");
INSERT INTO file_uploads VALUES("3","76","uploads/SPPD_0161_01_2025.pdf","2025-04-16 07:44:06");


DROP TABLE IF EXISTS informasi;
CREATE TABLE `informasi` (
  `id_info` int(11) NOT NULL AUTO_INCREMENT,
  `judul` varchar(30) NOT NULL,
  `isi` text NOT NULL,
  `prioritas` enum('normal','tinggi','mendesak') DEFAULT 'normal',
  `status` enum('aktif','nonaktif') DEFAULT 'aktif',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_info`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `informasi_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO informasi VALUES("40","Pemberitahuan","tesdbashbdasbabdjkbasbdbsajbdasbjabsjbasbdbjasd","normal","aktif","69","2025-04-26 14:38:21","2025-04-26 14:38:21");
INSERT INTO informasi VALUES("42","pengumpulan spj","tessssssssssssssssssssssssssssssssssss","normal","aktif","80","2025-04-27 08:55:27","2025-04-27 08:55:27");


DROP TABLE IF EXISTS label_catatan;
CREATE TABLE `label_catatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `warna` varchar(7) DEFAULT '#000000',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO label_catatan VALUES("1","Penting","#ff0000","2025-04-05 23:15:08");
INSERT INTO label_catatan VALUES("2","Mendesak","#ff6b00","2025-04-05 23:15:08");
INSERT INTO label_catatan VALUES("3","Tugas","#4caf50","2025-04-05 23:15:08");
INSERT INTO label_catatan VALUES("4","Rapat","#2196f3","2025-04-05 23:15:08");
INSERT INTO label_catatan VALUES("5","Pribadi","#9c27b0","2025-04-05 23:15:08");


DROP TABLE IF EXISTS laporan;
CREATE TABLE `laporan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` varchar(255) DEFAULT NULL,
  `no_sppd` varchar(255) DEFAULT NULL,
  `nama_pegawai` text DEFAULT NULL,
  `tempat_kegiatan` varchar(255) DEFAULT NULL,
  `tanggal_berangkat` date DEFAULT NULL,
  `tanggal_kembali` date DEFAULT NULL,
  `isi_laporan` text DEFAULT NULL,
  `dokumentasi` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO laporan VALUES("16","76","097/0161/SPPD-01/DISDIKBUD/2025","Rafiul Amal, M.Pd, H. Abiji, S.Pd. M.AP, Noprianti, S.Pd, Kamran Thalibin, S.Ag, Eddy Mufiannoor, S.Pd., M.Pd","BPKP Provinsi Kalimantan  Selatan ","2025-01-14","2025-01-15","<p>Melaksanakan koordinasi dengan BPKP Provinsi Kalimantan Selatan dalam rangka persiapan pelaksanaan EFOS Training bagi calon penerima beasiswa luar negeri, khususnya terkait aspek pengelolaan anggaran, pelaporan, serta mekanisme pengawasan kegiatan.</p><p>Kegiatan koordinasi ini berjalan dengan lancar dan menghasilkan beberapa kesepakatan penting yang mendukung kelancaran dan akuntabilitas pelaksanaan EFOS Training. Diharapkan sinergi ini dapat terus berlanjut demi meningkatkan kualitas program beasiswa luar negeri.</p>","[\"67fe07b11e69a_WhatsApp Image 2025-04-15 at 10.19.10.jpeg\",\"67fe07b11ecb8_WhatsApp Image 2025-04-15 at 10.18.48.jpeg\"]");
INSERT INTO laporan VALUES("17","77","097/0162/SPPD-03/DISDIKBUD/2025","Rafiul Amal, M.Pd, H. Abiji, S.Pd. M.AP, Eddy Mufiannoor, S.Pd., M.Pd","BPKP Provinsi Kalimantan  Selatan ","2025-03-06","2025-03-07","<p>Melaksanakan <strong data-start=\"471\" data-end=\"553\">koordinasi pelaksanaan pemberian insentif Non PNS Guru dan Tenaga Kependidikan</strong> ke BPKP Provinsi Kalimantan Selatan, dalam rangka mendukung kelancaran penyaluran dan akuntabilitas pelaporan penggunaan dana insentif dimaksud. Diperoleh kesepahaman bersama terkait mekanisme pelaporan dan monitoring pemberian insentif.</p><p data-start=\"1390\" data-end=\"1417\" class=\"\"><strong data-start=\"1390\" data-end=\"1415\">Hasil yang Dicapai</strong></p><p>
\n</p><ul data-start=\"1418\" data-end=\"1731\">
\n<li data-start=\"1418\" data-end=\"1514\" class=\"\">
\n<p data-start=\"1420\" data-end=\"1514\" class=\"\">Diperoleh kesepahaman bersama terkait mekanisme pelaporan dan monitoring pemberian insentif.</p>
\n</li>
\n<li data-start=\"1515\" data-end=\"1641\" class=\"\">
\n<p data-start=\"1517\" data-end=\"1641\" class=\"\">Diperoleh arahan dari BPKP untuk penyesuaian prosedur pelaporan agar sesuai dengan prinsip transparansi dan akuntabilitas.</p>
\n</li>
\n<li data-start=\"1642\" data-end=\"1731\" class=\"\">
\n<p data-start=\"1644\" data-end=\"1731\" class=\"\">Pihak BPKP siap memberikan pendampingan teknis bila diperlukan oleh instansi pengelola.</p></li></ul><p><br></p><p><br></p>","[\"20250415174032_67fe299072002.jpeg\",\"20250415174032_67fe2990721fd.jpeg\",\"20250415174032_67fe299072451.jpeg\"]");
INSERT INTO laporan VALUES("18","84","097/0167/SPPD-02/DISDIKBUD/2025","Muhammad Maria Rusadi","BPKP Provinsi Kalimantan  Selatan ","2025-03-06","2025-03-07","<h3 data-start=\"294\" data-end=\"306\" class=\"\"><span style=\"font-size: 16px;\">Perintah tugas dari atasan langsung untuk melaksanakan perjalanan dinas dalam rangka mendampingi Kepala Dinas melakukan koordinasi terkait pelaksanaan pemberian insentif Non PNS bagi guru dan tenaga kependidikan.</span></h3><h3 data-start=\"294\" data-end=\"306\" class=\"\"><span style=\"font-size: 16px;\">Mengantar dan mendampingi Kepala Dinas dalam kegiatan koordinasi pelaksanaan pemberian insentif Non PNS Guru dan Tenaga Kependidikan di wilayah dalam provinsi.&nbsp;</span></h3><h3 data-start=\"294\" data-end=\"306\" class=\"\"><span style=\"font-size: 16px;\">Selama pelaksanaan tugas, perjalanan berjalan dengan lancar dan aman, serta kendaraan dinas digunakan dalam kondisi baik dan layak jalan. Saya juga bertugas menjaga kesiapan kendaraan dan memastikan keamanan selama perjalanan.</span></h3>","[\"20250420231206_68050ec61dd19.jpeg\",\"20250420231206_68050ec61e402.jpeg\",\"20250420231206_68050ec61e8db.jpeg\"]");
INSERT INTO laporan VALUES("19","85","097/0166/SPPD-01/DISDIKBUD/2025","Muhammad Maria Rusadi","BPKP Provinsi Kalimantan  Selatan ","2025-01-14","2025-01-15","<p data-start=\"419\" data-end=\"847\" class=\"\">Saya selaku sopir KADIS telah melaksanakan tugas <strong data-start=\"503\" data-end=\"545\">mengantar dan mendampingi Kepala Dinas</strong> dalam rangka <strong data-start=\"559\" data-end=\"649\">koordinasi pelaksanaan kegiatan EFOS Training bagi calon penerima beasiswa luar negeri</strong>.<br data-start=\"650\" data-end=\"653\">
\nPerjalanan dinas dimulai dari kantor dinas , menuju lokasi kegiatan di BPKP Provinsi Kalimantan Selatan.&nbsp;</p><p>
\n</p><p data-start=\"849\" data-end=\"1030\" class=\"\">Kegiatan berjalan dengan lancar dan aman. Saya bertanggung jawab atas keselamatan perjalanan, serta memastikan kendaraan dalam kondisi prima sebelum, selama, dan sesudah perjalanan.</p>","[\"20250420231933_680510854cea6.jpeg\"]");
INSERT INTO laporan VALUES("20","87","097/0169/SPPD-04/DISDIKBUD/2025","Noprianti, S.Pd, Aries Junaidi, S.Pd",NULL,"2025-04-14","2025-04-14","<p>Hasil dari observasi menunjukkan bahwa secara umum fasilitas yang tersedia cukup memadai. Ruang pelatihan memiliki kapasitas yang sesuai, perangkat presentasi berfungsi dengan baik, serta koneksi internet tergolong stabil meskipun disarankan untuk menyediakan alternatif jaringan jika terjadi gangguan. Selain itu, pihak sekolah menyatakan dukungan penuh terhadap program ini dan siap membantu dalam pengaturan jadwal serta teknis pelaksanaan agar tidak mengganggu kegiatan belajar mengajar yang sedang berlangsung.</p>","[\"20250422085640_6806e9481833d.jpeg\",\"20250422085640_6806e94818780.jpeg\"]");
INSERT INTO laporan VALUES("21","83","097/0168/SPPD-02/DISDIKBUD/2025","Muhammad Maria Rusadi","Bandara Syamsudin Noor Banjarmasin","2025-02-05","2025-02-07","<p><span class=\"selectable-text copyable-text xkrh14z\" style=\"white-space-collapse: preserve;\">Telah dilakukan Pengantaran dan Penjemputan Kepala dinas di Bandara Bandara Syamsudin Noor Banjarmasin Melaksanakan Perjalanan Dinas Luar Daerah Luar Provinsi dalam rangka Koordinasi Penugasan Guru sebagai Kepala Sekolah dan Rekomendasi Kebututuhan Formasi JF Guru</span></p>","[\"20250422105753_680705b1a710f.png\",\"20250422105753_680705b1a72b8.png\"]");
INSERT INTO laporan VALUES("22","88","097/0170/SPPD-04/DISDIKBUD/2025","Noprianti, S.Pd, Mirawaty, S.Sos, Hj. Pahriati, Eddy Mufiannoor, S.Pd., M.Pd, Puryanto, S.Kom, Aries Junaidi, S.Pd, Abdul Sani, A.Ma.Pd","<br /><b>Deprecated</b>:  htmlspecialchars(): Pass","2025-04-21","2025-04-21","<p data-start=\"562\" data-end=\"915\" class=\"\">Kegiatan kunjungan dilaksanakan pada hari Senin, 21 April 2025. Tim tiba di lokasi pukul 13.30 WITA dan disambut oleh Kepala Sekolah bersama para guru peserta pelatihan. Kunjungan ini bertujuan untuk memastikan pelaksanaan pelatihan berjalan sesuai rencana, baik dari sisi materi, kehadiran peserta, serta efektivitas metode pembelajaran yang digunakan.</p><p data-start=\"1701\" data-end=\"2008\" class=\"\">
\n</p><p data-start=\"917\" data-end=\"1325\" class=\"\">Pelatihan difokuskan pada penguatan kompetensi guru dalam mengajar Bahasa Inggris menggunakan pendekatan Cambridge, yang menitikberatkan pada keterampilan komunikatif dan metode pengajaran aktif. Selama observasi, pelatihan berlangsung dalam suasana interaktif, dengan para guru menunjukkan partisipasi aktif dalam diskusi, simulasi mengajar, serta latihan pengembangan materi berbasis standar internasional.</p><p data-start=\"917\" data-end=\"1325\" class=\"\">Secara keseluruhan, pelaksanaan <em data-start=\"1610\" data-end=\"1638\">Cambridge English Training</em> untuk guru berjalan dengan lancar. Para guru menunjukkan semangat belajar yang tinggi dan keterbukaan terhadap metode pengajaran baru. Pihak sekolah juga memberikan dukungan penuh, termasuk dalam hal penyediaan waktu dan fasilitas pelatihan.</p>","[\"20250423092915_6808426b65ce7.jpeg\",\"20250423092915_6808426b6602e.jpeg\"]");


DROP TABLE IF EXISTS pegawai;
CREATE TABLE `pegawai` (
  `id_pegawai` int(11) NOT NULL AUTO_INCREMENT,
  `status_kepegawaian` enum('PNS','PPPK','PPPK Paruh Waktu','Non ASN') NOT NULL,
  `nip` varchar(25) NOT NULL,
  `nama_pegawai` varchar(100) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `unit_kerja` varchar(100) DEFAULT NULL,
  `golongan` varchar(25) DEFAULT NULL,
  `gol_aselon` varchar(20) DEFAULT NULL,
  `alamat` text DEFAULT NULL,
  `no_telp` varchar(15) DEFAULT NULL,
  `foto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_pegawai`)
) ENGINE=InnoDB AUTO_INCREMENT=11457 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO pegawai VALUES("11317","PNS","19690813 199412 1 002","H. Abiji, S.Pd. M.AP","Kepala Dinas","SKB BALANGAN","PEMBINA UTAMA MUDA (IV/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11318","PNS","19691118 199512 1 002","H. Imdiyah Fadli, S.Pd,M.AP","Sekretaris","SKB BALANGAN","PEMBINA TK I (IV/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11319","PNS","19720428 199702 1 002","Rafiul Amal, M.Pd","Kepala Bidang Pembinaan Pendidikan Dasar","SKB BALANGAN","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11320","PNS","19811228 201001 1 017","Juli Rahman, S.Pd","Kepala Bidang Pembinaan PAUD Dan Pendidikan Non Fo","SKB BALANGAN","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11321","PNS","19670809 198911 1 001","H. Marsono, S.Pd","Kepala Bidang Kelembagaan dan Sarana Prasarana","SKB BALANGAN","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11322","PNS","19670925 199303 1 005","Hasan, S.Sos","Kepala Bidang Kebudayaan","SKB BALANGAN","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11323","PNS","19820116 201001 2 019","Sri Wahyuningsih, SE. MM","Kasubbag Perencanaan  & Pelaporan","DISDIKBUD Kab. Balangan","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11324","PNS","19830514 200904 1 003","Arbani, SE, M.Sos","Kasubbag Umum dan Kepegawaian","DISDIKBUD Kab. Balangan","PENATA TK I (III/D)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11325","PNS","19770823 200604 2 022","Hj. Latifah Hani, S.Sos","Kasubbag Keuangan","DISDIKBUD Kab. Balangan","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11326","PNS","19820616 200801 1 014","Halianur, S.Pd","JF Pamong Budaya Ahli Muda","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11327","PNS","19691007 200003 2 007","Hj. Rusminah, S.Pd","JF Pamong Budaya Ahli Muda","DISDIKBUD Kab. Balangan","PENATA TK I (III/D)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11328","PNS","19810619 200701 2 015","Yansyah, S.Kom","JF Pamong Budaya Ahli Muda","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11329","PNS","19680304 198804 1 002","H. B a h u r","Pengadministrasi Perkantoran","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11330","PNS","19800521 200701 1 009","Deddy Rakhman, S.Sos, M.M","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11331","PNS","19811019 201001 2 025","Sumarni, S.AP","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA (III/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11332","PNS","19781102 200903 2 005","Noprianti, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA (III/A)",NULL,"","08123456789","");
INSERT INTO pegawai VALUES("11333","PNS","19770313 200701 1 011","Rahmadiansyah, S.Sos","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11334","PNS","19820829 200801 2 020","Rini Erliyante, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11335","PNS","19790330 200801 0 016","Saidi Munsi, S.Pd, M.M","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11336","PNS","19841106 201001 1 024","Tajerianor, S.AP","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA (III/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11337","PNS","19790505 200903 2 009","Mirawaty, S.Sos","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA (III/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11338","PNS","19821211 200801 2 009","Sariyatul Janah, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11339","PNS","19690529 200604 2 005","Hj. Pahriati","Pengadministrasi Perkantoran","DISDIKBUD Kab. Balangan","PENATA MUDA (III/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11340","PNS","19750525 201406 1 008","Kamran Thalibin, S.Ag","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11341","PNS","19800301 200604 2 024","Masitah, S.Sos","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11342","PNS","19841008 201101 1 007","Puryanto, S.Kom","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789","");
INSERT INTO pegawai VALUES("11343","PNS","19820405 201001 1 028","Aries Junaidi, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11344","PNS","19870420 201001 1 004","Rahmat Hidayat, A.Md","Pengola Data dan Informasi","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11345","PNS","19720830 199803 1 007","Agus Saipurahman, S.Pd, MM","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PEMBINA (IV/A)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11346","PNS","19861228 200904 1 003","Zeki Muttaqin, SH.M.IP","JF Analis Kebijakan Ahli Muda","DISDIKBUD Kab. Balangan","PENATA TK I (III/D)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11347","PNS","19701010 200501 1 025","Arbain, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11348","PNS","19830327 200501 1 003","Henderi Yadi, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11349","PNS","19820124 201001 2 003","Hartini, S.AP","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA MUDA TK I (III/B)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11350","PNS","19861210 200904 2 006","Mita Damayanti, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11351","PPPK","19860930 202421 1 001","Arif Rusman, S.Sos","JF Analis Sumber Daya Manusia Aparatur Ahli Pertam","DISDIKBUD Kab. Balangan","IX",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11352","PPPK","19930914 202421 0 002","Nur Rahimah, S.I.Pust","JF Arsiparis Ahli Pertama","DISDIKBUD Kab. Balangan","IX",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11353","PPPK","19870320 202421 1 001","Lilis Rahmannor, S.Kom","JF Pranata Komputer Ahli Pertama","DISDIKBUD Kab. Balangan","IX",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11354","PNS","19840914 201406 1 004","Abdul Sani, A.Ma.Pd","Pengadministrasi Perkantoran","DISDIKBUD Kab. Balangan","PENGATUR (II/C)",NULL,"","08123456789","");
INSERT INTO pegawai VALUES("11355","PNS","19690119 200604 1 004","Pahrujinor, A.Ma","Pengadministrasi Perkantoran","DISDIKBUD Kab. Balangan","PENGATUR TK I (II/D)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11356","PNS","19880528 201402 1 002","Handy Priya Utama, S.Pd","Penalaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11357","PNS","19830908 201001 1 018","Eddy Mufiannoor, S.Pd., M.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PEMBINA (IV/A)",NULL,"","08123456789","");
INSERT INTO pegawai VALUES("11358","PNS","19860620 201101 2 015","Eka Noresda, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA TK I (III/D)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11359","PNS","19721227 200604 1 006","Muhammad Nazir Azhar, S.T","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11360","PNS","19790529 200701 1 005","Sukerani, S.Pd","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11361","PNS","19830104 201402 1 001","Paimin, S.Pd, M.M","Penelaah Teknis Kebijakan","DISDIKBUD Kab. Balangan","PENATA (III/C)",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11362","","","Maya Setyo Rini, S.E","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11363","","","Dwi Wulandari, S.H","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11364","","","Iwan, S.Kom","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11365","","","Zainal Mukhlis, S.Kom","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11366","","","Asdi Yanuari, S.Sos","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11367","","","Luthfia Elma","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11368","","","Khairatul Mahmudah, S.P","Staf Subbag Perencanaan. & Pelaporan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11369","","","Ilmiah, S.E","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11370","","","Ardiansyah, S.A.P","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11371","","","Hani Fitria, S.Kom","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11372","","","Vera Aristiani, S.A.P","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11373","","","Faridatul Hasanah, S.Pd","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11374","","","Salsabila","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11375","","","Noor Syifa, S.E","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11376","","","Ahdyan Noor, S.E","Staf Subbag Umum & Kepegawaian","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11377","","","Dian Puspa Aprita","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11378","","","Tria Ayu Wulansari, SP","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11379","","","Agustina, S.Pd","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11380","","","Eko Hariadi","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11381","","","Hapizatun Nahdiah, S.Pd","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11382","","","Janawi, S.Sos","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11383","","","Hafizah Maulida, SE","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11384","","","Riska Ariyanti","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11385","","","Saniah Auliana","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11386","","","Pauziah","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11387","","","Nurul Hikmah Maulida","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11388","","","Heri Iriansyah","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11389","","","Rubiah, S.Pd","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11390","","","Rini Oktavia","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11391","","","Sofia Faridatun Nisa, S.Mat","Staf Subbag Keuangan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11392","","","Mardani, S.Sos","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11393","","","Fitriana, S.Pd","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11394","","","Amat","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11395","","","Nova Fahrina","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11396","","","Wiwik Damaiyanti, S,Sos","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11397","","","Frisca Damayanti","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11398","","","Saprianor","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11399","","","Meldasari","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11400","","","Arbainah","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11401","","","Siti Khusnul Khotimah","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11402","","","Muhammad Isma Ibrahim","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11403","","","Aulia Rahmah","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11404","","","Norliani, S.AP","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11405","","","Sarbani","Staf Bid. Pemb. PAUD & PNF","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11406","","","Hariyati Risydha, S.Sos","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11407","","","Fariz Fadillah, S.Kom","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11408","","","Yudi Dwi Raharjo, S.Kom","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11409","","","Muhammad Yudin Naparin, S.AP","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11410","","","Muhammad Rizal Wahyudi, S.AP","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11411","","","Jahratan Normujiah, S.AP","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11412","","","Moch Rifa\'i","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11413","","","Sri Razakia","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11414","","","Yahya Irfandi. S.Kom","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789","pegawai_6804986deb0c0.jpeg");
INSERT INTO pegawai VALUES("11415","","","Adam Mahmudi, SE","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11416","","","Ghina Syifa Salsabil, SH","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11417","","","Muhammad Rega Pratama Putera","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11418","","","Nurhuda Maulana","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11419","","","Sahrani","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11420","","","Haderiyah","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11421","","","Muhammad Nor Firdaus","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11422","","","Jhony Maulana","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11423","","","Helmalia Putri","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11424","","","Nisa Armia","Staf Bid. Pembinaan Pendidikan Dasar","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11425","","","Nanda Fitriani, S.AP","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11426","","","M. Habibi, S.Pd.I","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11427","","","Yudi Ilham","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11428","","","Vina Khairunnisa, S.AP","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11429","","","Nurul Ain, S.S","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11430","","","Rina","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11431","","","Dwi Kartika Puteri","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11432","","","Dody Ronald","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11433","","","Ahmad Asrarul Na\'any","Staf Bid. Kebudayaan","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11434","","","Surya Iman Mahyudi, ST","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11435","","","Wardah Hafidz, S.AP","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11436","","","Abd. Gafar","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11437","","","Ridha Amaliah, S.Kom","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11438","","","Normilasari, S.Sos","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11439","","","Akhmad Suwandi, S.AP","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11440","","","Rahmayanti","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11441","","","Sugun Wibowo","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11442","","","Erlita Mayasari","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11443","","","Annisa Rahmah, ST","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11444","","","Rizky Setiawan","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11445","","","Norkhalisah","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11446","","","Akhdariyani","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11447","","","M. Noor Ilme","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11448","","","Feronia Azcharyah, S.T","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11449","","","Rifki Azhari, ST","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11450","","","Jum\'atul Khairiyah","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11451","","","Herawati, A.Ma","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11452","","","Noorhamidah","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11453","","","Aulya Novianti, Amd. Ak","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11454","","","Muhammad Khairil Mukmin, S.T","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11455","","","Amanda Lorenza, Amd. Ak","Staf Bid. Kelembagaan dan Sarana Prasarana","DISDIKBUD Kab. Balangan","Non-ASN",NULL,"","08123456789",NULL);
INSERT INTO pegawai VALUES("11456","PNS","","Muhammad Maria Rusadi","sopir","DISDIKBUD Kab. Balangan","Non ASN",NULL,NULL,NULL,NULL);


DROP TABLE IF EXISTS pejabat_daerah;
CREATE TABLE `pejabat_daerah` (
  `id_pejabat` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(25) DEFAULT NULL,
  `jabatan` varchar(100) NOT NULL,
  `pangkat` varchar(50) DEFAULT NULL,
  `golongan` varchar(10) DEFAULT NULL,
  `unit_kerja` varchar(100) DEFAULT NULL,
  `status` enum('aktif','tidak_aktif') DEFAULT 'aktif',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_pejabat`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO pejabat_daerah VALUES("1","H.ABIJI. S.Pd.,M.AP","19690813 199412 1 002","Kepala Dinas Pendidikan dan Kebudayaan Kabupaten Balangan","Pembina Utama Muda","IV/c","Dinas Pendikan dan Kebudayaan Kabupaten Balangan","aktif","2025-04-04 13:08:19","2025-04-25 19:13:13");
INSERT INTO pejabat_daerah VALUES("2","H. Abdul Hadi, S.Ag, M.I.Kom"," ","Bupati Balangan"," "," ","Bupati Balangan","aktif","2025-04-04 13:19:21","2025-04-04 13:19:21");
INSERT INTO pejabat_daerah VALUES("3","H. SUFRIANNOR, S.Sos, M.AP","19681012 198903 1 009","Sekretaris Daerah","Pembina Utama Muda","IV/c","Kantor Bupati Balangan","aktif","2025-04-25 17:49:20","2025-04-26 10:35:46");


DROP TABLE IF EXISTS pengaturan;
CREATE TABLE `pengaturan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kode` varchar(50) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nilai` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `kode` (`kode`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO pengaturan VALUES("1","nama_instansi","Nama Instansi","Dinas Pendidikan dan Kebudayaan Kabupaten Balangan","2025-04-17 09:06:49","2025-04-17 09:15:24");
INSERT INTO pengaturan VALUES("2","alamat_instansi","Alamat Instansi","Jl. A. Yani No. 30, Paringin, Balangan, Kalimantan Selatan","2025-04-17 09:06:49","2025-04-17 09:06:49");
INSERT INTO pengaturan VALUES("3","email_instansi","Email Instansi","disdikbud@balangankab.go.id","2025-04-17 09:06:49","2025-04-17 09:06:49");
INSERT INTO pengaturan VALUES("4","telepon_instansi","Telepon Instansi","(0526) 2028001","2025-04-17 09:06:49","2025-04-17 09:06:49");
INSERT INTO pengaturan VALUES("5","logo_instansi","Logo Instansi","logo.png","2025-04-17 09:06:49","2025-04-17 09:06:49");
INSERT INTO pengaturan VALUES("6","kop_line1","Kop Surat Baris 1","PEMERINTAH DARAH","2025-04-17 09:12:03","2025-04-17 09:14:41");
INSERT INTO pengaturan VALUES("7","kop_line2","Kop Surat Baris 2","DINAS PENDIDIKAN DAN KEBUDAYAAN","2025-04-17 09:12:03","2025-04-17 09:12:03");
INSERT INTO pengaturan VALUES("8","kop_line3","Kop Surat Baris 3","KABUPATEN BALANGAN","2025-04-17 09:12:03","2025-04-17 09:12:03");
INSERT INTO pengaturan VALUES("9","kop_font_size","Ukuran Font Kop Surat","14","2025-04-17 09:12:03","2025-04-17 09:12:03");
INSERT INTO pengaturan VALUES("10","kop_font_family","Jenis Font Kop Surat","Times New Roman","2025-04-17 09:12:03","2025-04-17 09:12:03");
INSERT INTO pengaturan VALUES("11","kop_line_spacing","Spasi Kop Surat","1.15","2025-04-17 09:12:03","2025-04-17 09:12:03");


DROP TABLE IF EXISTS rekap_sppd;
CREATE TABLE `rekap_sppd` (
  `id_rekap` int(11) NOT NULL AUTO_INCREMENT,
  `no_rekap` varchar(50) DEFAULT NULL,
  `tanggal_rekap` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_rekap`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO rekap_sppd VALUES("15","001/SPPD-REKAP/2025","2025-04-20","2025-04-20 12:22:46");
INSERT INTO rekap_sppd VALUES("16","002/SPPD-REKAP/2025","2025-04-21","2025-04-21 07:45:38");
INSERT INTO rekap_sppd VALUES("18","003/SPPD-REKAP/2025","2025-04-23","2025-04-23 09:42:43");


DROP TABLE IF EXISTS rincian_biaya;
CREATE TABLE `rincian_biaya` (
  `id_rincian` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` int(11) NOT NULL,
  `biaya_detail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`biaya_detail`)),
  `total_biaya` decimal(10,2) DEFAULT 0.00,
  `keterangan` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_rincian`),
  KEY `id_surat` (`id_surat`),
  CONSTRAINT `rincian_biaya_ibfk_1` FOREIGN KEY (`id_surat`) REFERENCES `surat_tugas` (`id_surat`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO rincian_biaya VALUES("21","76","{\"uang_harian\":\"760000\",\"uang_diklat\":\"0\",\"tujuan\":null,\"transport\":\"450000\",\"akomodasi\":\"162000\"}","1534000.00","-","2025-04-15 09:04:49","2025-04-15 09:09:36");
INSERT INTO rincian_biaya VALUES("22","77","{\"uang_harian\":\"760000\",\"uang_diklat\":\"0\",\"tujuan\":null,\"transport\":\"0\",\"akomodasi\":\"0\"}","760000.00","-","2025-04-15 16:49:54","2025-04-15 16:49:54");
INSERT INTO rincian_biaya VALUES("28","85","{\"uang_harian\":\"760000\",\"uang_diklat\":\"0\",\"tujuan\":null,\"transport\":\"0\",\"akomodasi\":\"162000\"}","1084000.00","","2025-04-21 07:29:02","2025-04-21 07:35:18");
INSERT INTO rincian_biaya VALUES("29","88","{\"uang_harian\":\"0\",\"transport\":\"40000\",\"jarak\":0,\"biaya_jarak\":0}","80000.00","","2025-04-22 09:48:42","2025-04-22 09:49:01");


DROP TABLE IF EXISTS rincian_biaya_perorangan;
CREATE TABLE `rincian_biaya_perorangan` (
  `id_rincian` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` int(11) DEFAULT NULL,
  `id_pegawai` int(11) DEFAULT NULL,
  `biaya_detail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`biaya_detail`)),
  `total_biaya` decimal(15,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tanggal_berangkat` date DEFAULT NULL,
  `tanggal_kembali` date DEFAULT NULL,
  PRIMARY KEY (`id_rincian`),
  UNIQUE KEY `unique_surat_pegawai` (`id_surat`,`id_pegawai`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO rincian_biaya_perorangan VALUES("21","76","11317","{\"uang_harian\":760000,\"representatif\":300000,\"uang_diklat\":0,\"transport\":0,\"akomodasi\":994800}","2054800.00","2025-04-15 09:05:26","2025-04-15 09:05:50","2025-01-14","2025-01-15");
INSERT INTO rincian_biaya_perorangan VALUES("22","76","11319","{\"uang_harian\":760000,\"representatif\":0,\"uang_diklat\":0,\"transport\":450000,\"akomodasi\":450000}","1660000.00","2025-04-15 09:08:29","2025-04-15 09:08:29","2025-01-14","2025-01-15");
INSERT INTO rincian_biaya_perorangan VALUES("23","77","11317","{\"uang_harian\":760000,\"representatif\":300000,\"uang_diklat\":0,\"transport\":0,\"akomodasi\":994800}","2054800.00","2025-04-15 16:50:18","2025-04-15 16:50:18","2025-03-06","2025-03-07");
INSERT INTO rincian_biaya_perorangan VALUES("24","77","11319","{\"uang_harian\":760000,\"representatif\":0,\"uang_diklat\":0,\"transport\":450000,\"akomodasi\":450000}","1660000.00","2025-04-15 16:51:38","2025-04-15 16:51:38","2025-03-06","2025-03-07");
INSERT INTO rincian_biaya_perorangan VALUES("25","77","11357","{\"uang_harian\":760000,\"representatif\":0,\"uang_diklat\":0,\"transport\":450000,\"akomodasi\":162000}","1372000.00","2025-04-15 16:54:19","2025-04-15 16:54:19","2025-03-06","2025-03-07");
INSERT INTO rincian_biaya_perorangan VALUES("35","83","11456","{\"uang_harian\":760000,\"representatif\":0,\"uang_diklat\":0,\"transport\":0,\"akomodasi\":0}","760000.00","2025-04-20 22:28:40","2025-04-20 22:28:40","2025-02-05","2025-02-06");
INSERT INTO rincian_biaya_perorangan VALUES("36","84","11456","{\"uang_harian\":760000,\"representatif\":0,\"uang_diklat\":0,\"transport\":0,\"akomodasi\":162000}","922000.00","2025-04-20 22:38:54","2025-04-20 22:38:54","2025-03-06","2025-03-07");
INSERT INTO rincian_biaya_perorangan VALUES("37","87","11343","{\"uang_harian\":0,\"transport\":40000,\"jarak\":0,\"biaya_jarak\":0}","40000.00","2025-04-22 08:39:53","2025-04-22 08:39:53",NULL,NULL);
INSERT INTO rincian_biaya_perorangan VALUES("38","87","11332","{\"uang_harian\":0,\"transport\":40000,\"jarak\":0,\"biaya_jarak\":0}","40000.00","2025-04-22 08:40:37","2025-04-22 08:40:37",NULL,NULL);


DROP TABLE IF EXISTS rincian_biaya_riil;
CREATE TABLE `rincian_biaya_riil` (
  `id_rincian_riil` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` int(11) DEFAULT NULL,
  `id_pegawai` int(11) DEFAULT NULL,
  `uraian` varchar(255) DEFAULT NULL,
  `jumlah` int(11) DEFAULT NULL,
  `keterangan` text DEFAULT NULL,
  PRIMARY KEY (`id_rincian_riil`),
  KEY `id_surat` (`id_surat`),
  KEY `id_pegawai` (`id_pegawai`),
  CONSTRAINT `rincian_biaya_riil_ibfk_1` FOREIGN KEY (`id_surat`) REFERENCES `surat_tugas` (`id_surat`),
  CONSTRAINT `rincian_biaya_riil_ibfk_2` FOREIGN KEY (`id_pegawai`) REFERENCES `pegawai` (`id_pegawai`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO rincian_biaya_riil VALUES("28","76",NULL,"Akomodasi","162000","30% tanpa bill");
INSERT INTO rincian_biaya_riil VALUES("31","85",NULL,"Akomodasi","162000","30% tanpa bill hotel");
INSERT INTO rincian_biaya_riil VALUES("32","88",NULL,"Transport","40000","Perbub dalam daerah");


DROP TABLE IF EXISTS rincian_biaya_riil_perorangan;
CREATE TABLE `rincian_biaya_riil_perorangan` (
  `id_rincian` int(11) NOT NULL AUTO_INCREMENT,
  `id_surat` int(11) DEFAULT NULL,
  `id_pegawai` int(11) DEFAULT NULL,
  `rincian_riil` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`rincian_riil`)),
  `total_riil` decimal(15,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_rincian`),
  UNIQUE KEY `unique_surat_pegawai` (`id_surat`,`id_pegawai`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO rincian_biaya_riil_perorangan VALUES("12","76","11317","[{\"uraian\":\"Akomodasi\",\"jumlah\":994800,\"keterangan\":\"30% tanpa bill\"}]","994800.00","2025-04-15 09:07:50","2025-04-15 09:07:50");
INSERT INTO rincian_biaya_riil_perorangan VALUES("13","76","11319","[{\"uraian\":\"Akomodasi\",\"jumlah\":450000,\"keterangan\":\"30% tanpa bill\"}]","450000.00","2025-04-15 09:08:50","2025-04-15 09:08:50");
INSERT INTO rincian_biaya_riil_perorangan VALUES("14","77","11317","[{\"uraian\":\"Akomodasi\",\"jumlah\":994800,\"keterangan\":\"30% tanpa bill hotel\"}]","994800.00","2025-04-15 16:50:46","2025-04-15 16:50:46");
INSERT INTO rincian_biaya_riil_perorangan VALUES("15","77","11319","[{\"uraian\":\"Akomodasi\",\"jumlah\":450000,\"keterangan\":\"30% tanpa bill hotel\"},{\"uraian\":\"Transportasi \",\"jumlah\":450000,\"keterangan\":\"Nota BBM SPBU 64.706.015\"}]","900000.00","2025-04-15 16:52:21","2025-04-15 16:53:03");
INSERT INTO rincian_biaya_riil_perorangan VALUES("16","77","11357","[{\"uraian\":\"Akomodasi\",\"jumlah\":162000,\"keterangan\":\"30% tanpa bill hotel\"}]","162000.00","2025-04-15 16:54:48","2025-04-15 16:54:48");
INSERT INTO rincian_biaya_riil_perorangan VALUES("19","84","11456","[{\"uraian\":\"Akomodasi\",\"jumlah\":162000,\"keterangan\":\"30% tanpa bill hotel\"}]","162000.00","2025-04-20 22:39:17","2025-04-20 22:39:17");
INSERT INTO rincian_biaya_riil_perorangan VALUES("20","83","11456","[{\"uraian\":\"Akomodasi\",\"jumlah\":162000,\"keterangan\":\"30% tanpa bill hotel\"}]","162000.00","2025-04-20 22:39:54","2025-04-20 22:39:54");
INSERT INTO rincian_biaya_riil_perorangan VALUES("21","87","11343","[{\"uraian\":\"Transport\",\"jumlah\":40000,\"keterangan\":\"Perbub dalam daerah\"}]","40000.00","2025-04-22 08:41:32","2025-04-22 08:41:32");
INSERT INTO rincian_biaya_riil_perorangan VALUES("22","87","11332","[{\"uraian\":\"Transport\",\"jumlah\":40000,\"keterangan\":\"Perbub dalam daerah\"}]","40000.00","2025-04-22 08:41:47","2025-04-22 08:41:47");
INSERT INTO rincian_biaya_riil_perorangan VALUES("25","76","11357","[{\"uraian\":\"Akomodasi\",\"jumlah\":162000,\"keterangan\":\"30% tanpa bill\"},{\"uraian\":\"Transportasi \",\"jumlah\":450000,\"keterangan\":\"tanpa nota\"}]","612000.00","2025-04-23 10:16:45","2025-04-23 10:16:45");
INSERT INTO rincian_biaya_riil_perorangan VALUES("26","76","11340","[{\"uraian\":\"Akomodasi\",\"jumlah\":162000,\"keterangan\":\"30% tanpa bill\"},{\"uraian\":\"Transportasi \",\"jumlah\":450000,\"keterangan\":\"tanpa nota\"}]","612000.00","2025-04-23 10:18:17","2025-04-23 10:18:17");
INSERT INTO rincian_biaya_riil_perorangan VALUES("27","76","11332","[{\"uraian\":\"Akomodasi\",\"jumlah\":162000,\"keterangan\":\"30% tanpa bill\"},{\"uraian\":\"Transportasi \",\"jumlah\":450000,\"keterangan\":\"tanpa nota\"}]","612000.00","2025-04-23 10:18:36","2025-04-23 10:18:36");


DROP TABLE IF EXISTS snake_scores;
CREATE TABLE `snake_scores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `snake_scores_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO snake_scores VALUES("18","69","yahya_","340","2025-04-22 23:39:04");
INSERT INTO snake_scores VALUES("50","69","yahya_","380","2025-04-23 15:23:54");
INSERT INTO snake_scores VALUES("52","69","yahya_","180","2025-04-26 10:50:53");


DROP TABLE IF EXISTS surat_tugas;
CREATE TABLE `surat_tugas` (
  `id_surat` int(11) NOT NULL AUTO_INCREMENT,
  `no_surat` varchar(50) NOT NULL,
  `jenis_surat` varchar(60) DEFAULT NULL,
  `nama_pegawai` varchar(100) NOT NULL,
  `no_sppd` varchar(50) DEFAULT NULL,
  `tanggal_surat` date NOT NULL,
  `dasar_surat` text DEFAULT NULL,
  `tujuan` varchar(100) NOT NULL,
  `tempat_kegiatan` varchar(50) DEFAULT NULL,
  `asal_berangkat` varchar(50) DEFAULT NULL,
  `maksud` varchar(255) NOT NULL,
  `tanggal_berangkat` date DEFAULT NULL,
  `tanggal_kembali` date DEFAULT NULL,
  `lama_perjalanan` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  `no_sub_kegiatan` varchar(50) DEFAULT NULL,
  `total_biaya` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_surat`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO surat_tugas VALUES("76","090/0161/ST-01/DISDIKBUD/2025","Luar Daerah Dalam Provinsi","","097/0161/SPPD-01/DISDIKBUD/2025","2025-01-13","","Kota Banjarbaru","BPKP Provinsi Kalimantan  Selatan ","Disdikbud Kab. Balangan","Koordinasi Pelaksanaan Kegiatan Efos Training Calon Penerima Beasiswa Luar Negeri","2025-01-14","2025-01-15","2","2025-04-15 09:03:37","9","1.01.01.2.06.0009.5.1.02.04.01.0010","7830800.00");
INSERT INTO surat_tugas VALUES("77","090/0162/ST-03/DISDIKBUD/2025","Luar Daerah Dalam Provinsi","","097/0162/SPPD-03/DISDIKBUD/20","2025-03-03","","Kota Banjarbaru","BPKP Provinsi Kalimantan  Selatan ","Disdikbud Kab. Balangan","Melaksanakan Perjalanan Dinas Luar Daerah Dalam Provinsi dalam rangka Koordinasi Pelaksanaan Pemberian Insentif Non PNS Guru dan Tenaga Kependidikan","2025-03-06","2025-03-07","2","2025-04-15 16:48:46","9","1.01.01.2.06.0009.5.1.02.04.01.0010","5086800.00");
INSERT INTO surat_tugas VALUES("83","097/0168/SPPD-02/DISDIKBUD/2025","Luar Daerah Dalam Provinsi","","097/0168/SPPD-02/DISDIKBUD/2025","2025-02-04","","Kota Banjarbaru","Bandara Syamsudin Noor Banjarmasin","Disdikbud Kab. Balangan","Mengantar dan Menjumput Kadis Melakukan Perjalanan Dinas Luar Daerah Luar Provinsi dalam rangka Koordinasi Penugasan Guru sebagai Kepala Sekolah dan Rekomendasi Kebutuhan Formasi JF Guru","2025-02-05","2025-02-07","2","2025-04-20 22:22:54","75","1.01.01.2.06.0009.5.1.02.04.01.0001","760000.00");
INSERT INTO surat_tugas VALUES("84","090/0167/SPPD-02/DISDIKBUD/2025","Luar Daerah Dalam Provinsi","","097/0167/SPPD-02/DISDIKBUD/2025","2025-03-06","","Kota Banjarbaru","BPKP Provinsi Kalimantan  Selatan ","Disdikbud Kab. Balangan","Mengantar dan Mendampingi Kadis Melakukan Perjalanan Dinas Luar Daerah Dalam Provinsi dalam rangka Koordinasi Pelaksanaan Pemberian Insentif Non PNS Guru dan tenaga Kependidikan","2025-03-06","2025-03-07","2","2025-04-20 22:34:46","75","1.01.04.2.01.0002.51.02.04.01.0001","922000.00");
INSERT INTO surat_tugas VALUES("85","090/0166/SPPD-01/DISDIKBUD/2025","Luar Daerah Dalam Provinsi","","097/0166/SPPD-01/DISDIKBUD/2025","2025-01-14","","Kota Banjarbaru","BPKP Provinsi Kalimantan  Selatan ","Disdikbud Kab. Balangan","Mengantar dan Mendampingi Kadis Melaksanakan Koordinasi Pelaksanaan Kegiatan Efos Training Calon Penerima Beasiswa Luar Negeri","2025-01-14","2025-01-15","2","2025-04-20 22:38:28","75","1.01.04.2.01.0002.5.1.02.04.01.0001","922000.00");
INSERT INTO surat_tugas VALUES("87","090/0169/ST-04/DISDIKBUD/2025","Dalam Daerah Dalam Provinsi","","097/0169/SPPD-04/DISDIKBUD/2025","2025-04-11","","","<br /><b>Deprecated</b>:  htmlspecialchars(): Pass","Dinas Pendidikan dan Kebudayaan","Survei tempat persiapan Cambridge English Training ke SMPN 1 Paringin","2025-04-14","2025-04-14","1","2025-04-22 08:39:00","71","1.01.04.2.01.00025.1.02.04.01.0003","80000.00");
INSERT INTO surat_tugas VALUES("88","090/0170/ST-04/DISDIKBUD/2025","Dalam Daerah Dalam Provinsi","","097/0170/SPPD-04/DISDIKBUD/2025","2025-04-17","","","<br /><b>Deprecated</b>:  htmlspecialchars(): Pass","Dinas Pendidikan dan Kebudayaan","Kunjungan untuk Pengecekan Pelaksanaan Pelatihan Cambridge English Education di SMPN 1 Paringin dan SMPN 4 Paringin","2025-04-21","2025-04-21","1","2025-04-22 09:35:26","71","1.01.04.2.01.000225.1.02.04.01.0003","280000.00");


DROP TABLE IF EXISTS users;
CREATE TABLE `users` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL,
  `no_wa` varchar(13) DEFAULT NULL,
  `password` varchar(100) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL,
  `level` enum('admin','admin_sppd','pimpinan','bandahara') NOT NULL,
  `bidang` enum('paud','dikdas','keuangan','sarpras','umpeg','kebudayaan','khusus') DEFAULT NULL,
  `status` enum('pending','active','rejected') DEFAULT 'pending',
  `otp` varchar(6) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `foto` varchar(255) DEFAULT 'default_avatar.png',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO users VALUES("9","admin","cordgitar4@gm","e10adc3949ba59abbe56e057f20f883e","admin","admin","dikdas","active",NULL,"2025-04-14 01:43:14","user_9_1744774491.JPG");
INSERT INTO users VALUES("69","yahya_","085566778887","$2y$10$0VlmAuQLNebhRzVQy6CeLeI8T/xfYwBiiUoQVBwTVXmnqaFvuLK6K","Yahya Irfandi, S.Kom","admin","dikdas","active",NULL,"2025-04-20 00:07:00","user_69_1745394255.jpeg");
INSERT INTO users VALUES("70","Kabid Dikdas","098877665551","$2y$10$G3pyPiZ8KG5Q99NGrQi65uGxGJ.AoIGsZ3xlya3bD8nF6aIlFHLee","KABID DIKDAS","pimpinan","dikdas","active","343349","2025-04-20 01:17:56","default_avatar.png");
INSERT INTO users VALUES("71","rega","082251423567","$2y$10$YcKnB3epaa6LO6nVUcr1K.7rNEyjEWpgInUuxnr56xDHXpM4l2zPO","M. Rega Pratama Putra","admin_sppd","dikdas","active","913802","2025-04-20 13:17:48","default_avatar.png");
INSERT INTO users VALUES("72","Kabid Paud","082251423569","$2y$10$6fM3YwT.mGcUc4JUoxGPfuUImgys5LF1S7IoA9.zQN9eXy1NPcSjK","KABID PAUD","pimpinan","paud","active","636550","2025-04-20 13:20:52","default_avatar.png");
INSERT INTO users VALUES("73","mardani_","083364563735","$2y$10$Zbq5UL4mGpfLTI6DQd3k8.6A3cN8s6gSCE/L48GRmq/KzjjrI2gYS","Mardani, S.Sos","admin_sppd","paud","active","635713","2025-04-20 14:23:01","user_73_1745455933.png");
INSERT INTO users VALUES("75","sopir_","082251471943","$2y$10$RWiYrYIvNil.ttEIMiRInOkcfJ0gkhIGamnUIRIgGcrysrKiuy0Sy","Maria Rusadi","admin_sppd","khusus","active",NULL,"2025-04-20 16:19:28","default_avatar.png");
INSERT INTO users VALUES("77","Eko123","0822514784654","$2y$10$U6geWuYTE0Jk2833gbQHbO/2iLsfKcZTM3TJlyokGmjaWZnxguugW","Eko","admin_sppd","keuangan","active","320641","2025-04-21 13:14:16","default_avatar.png");
INSERT INTO users VALUES("78","ADAM","082240235240","$2y$10$NDzxQB3zJobZiAc4SAY7o.1w1ReY6VAt2AadSG7EvZP.m/.lPrCcS","ADAM MAHMUDI. S.E","admin_sppd","dikdas","active","666264","2025-04-23 09:07:23","default_avatar.png");
INSERT INTO users VALUES("79","yahyair_","087464534256","$2y$10$zwXsdb1mu0u44sIIjc3oJuJMFpp0zVUB7LeuZknLlYQnmr7s7c/9C","yahya Ir","admin_sppd","dikdas","active","819286","2025-04-24 20:11:08","default_avatar.png");
INSERT INTO users VALUES("80","Bandahara_","082251471946","$2y$10$qt.FpwNX2GHlyzGgrm5fbOseLfpRQ7T9FQJMUixHdWK3ZxTqKa.VW","Bandahara Keuangan","bandahara","keuangan","active",NULL,"2025-04-26 13:28:21","default_avatar.png");


