-- Table for group bimtek costs
CREATE TABLE rincian_bimtek (
    id_rincian_bimtek INT PRIMARY KEY AUTO_INCREMENT,
    id_surat INT NOT NULL,
    biaya_detail JSON,
    total_biaya DECIMAL(15,2) DEFAULT 0,
    keterangan TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (id_surat) REFERENCES surat_tugas(id_surat) ON DELETE CASCADE
);

-- Table for individual bimtek costs
CREATE TABLE rincian_bimtek_perorangan (
    id_rincian_bimtek_perorangan INT PRIMARY KEY AUTO_INCREMENT,
    id_surat INT NOT NULL,
    id_pegawai INT NOT NULL,
    biaya_detail JSON,
    total_biaya DECIMAL(15,2) DEFAULT 0,
    keterangan TEXT,
    tanggal_berangkat DATE,
    tanggal_kembali DATE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (id_surat) REFERENCES surat_tugas(id_surat) ON DELETE CASCADE,
    FOREIGN KEY (id_pegawai) REFERENCES pegawai(id_pegawai) ON DELETE CASCADE
);

-- Table for real bimtek costs
CREATE TABLE rincian_bimtek_riil (
    id_rincian_bimtek_riil INT PRIMARY KEY AUTO_INCREMENT,
    id_surat INT NOT NULL,
    tanggal DATE,
    uraian TEXT,
    jumlah DECIMAL(15,2),
    keterangan TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (id_surat) REFERENCES surat_tugas(id_surat) ON DELETE CASCADE
);

-- Table for individual real bimtek costs
CREATE TABLE rincian_bimtek_riil_perorangan (
    id_rincian_bimtek_riil_perorangan INT PRIMARY KEY AUTO_INCREMENT,
    id_surat INT NOT NULL,
    id_pegawai INT NOT NULL,
    tanggal DATE,
    uraian TEXT,
    jumlah DECIMAL(15,2),
    keterangan TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (id_surat) REFERENCES surat_tugas(id_surat) ON DELETE CASCADE,
    FOREIGN KEY (id_pegawai) REFERENCES pegawai(id_pegawai) ON DELETE CASCADE
); 