<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

if (!isset($_GET['id_surat']) || !isset($_GET['id_pegawai'])) {
    die("Error: ID Surat dan ID Pegawai harus disertakan");
}

$id_surat = $_GET['id_surat'];
$id_pegawai = $_GET['id_pegawai'];

// Query untuk data surat dan semua pegawai dalam surat tugas
$query = "SELECT DISTINCT st.*, p.id_pegawai, p.nama_pegawai, p.nip, p.jabatan, p.golongan,
          rbp.total_uang_harian, rbp.total_representatif, rbp.transport_dalam_provinsi,
          rbp.transport_luar_provinsi, rbp.akomodasi, rbp.biaya_jarak, rbp.jarak,
          rbp.waktu_kedatangan_aktual, rbp.waktu_kepulangan_aktual, rbp.lama_perjalanan_aktual,
          rbp.biaya_pesawat_berangkat, rbp.biaya_pesawat_pulang
          FROM surat_tugas st 
          INNER JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          INNER JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat AND p.id_pegawai = rbp.id_pegawai
          WHERE st.id_surat = ? AND p.id_pegawai = ?";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "ii", $id_surat, $id_pegawai);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_assoc($result);

if (!$data) {
    die("Data surat tidak ditemukan");
}

// Initialize pegawai data from the query result
$pegawai = [
    'nama_pegawai' => $data['nama_pegawai'] ?? '',
    'nip' => $data['nip'] ?? '',
    'jabatan' => $data['jabatan'] ?? '',
    'golongan' => $data['golongan'] ?? ''
];

// Query untuk mengambil semua pegawai dalam surat tugas
$query_all_pegawai = "SELECT p.*, rbp.* 
                      FROM pegawai p 
                      JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai 
                      LEFT JOIN rincian_bimtek_perorangan rbp ON dst.id_surat = rbp.id_surat 
                      AND p.id_pegawai = rbp.id_pegawai
                      WHERE dst.id_surat = ?
                      ORDER BY 
                          CASE 
                              WHEN p.jabatan LIKE '%Sopir%' THEN 1
                              WHEN p.jabatan LIKE '%Pengawas%' THEN 2
                              WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 3
                              WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
                              WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 5
                              WHEN p.jabatan LIKE '%Sekretaris%' THEN 6
                              WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 7
                              ELSE 8
                          END DESC,
                          p.golongan DESC,
                          p.nama_pegawai ASC";
$stmt = mysqli_prepare($conn, $query_all_pegawai);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result_all_pegawai = mysqli_stmt_get_result($stmt);
$all_pegawai = [];
while ($row = mysqli_fetch_assoc($result_all_pegawai)) {
    $all_pegawai[] = $row;
}

function penyebut($nilai) {
    if ($nilai == 0) {
        return " ";
    }
    
    $nilai = abs($nilai);
    $huruf = array("", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas");
    $temp = "";
    
    if ($nilai < 12) {
        $temp = " " . $huruf[$nilai];
    } else if ($nilai < 20) {
        $temp = penyebut($nilai - 10) . " Belas";
    } else if ($nilai < 100) {
        $temp = penyebut(floor($nilai/10)) . " Puluh" . penyebut($nilai % 10);
    } else if ($nilai < 200) {
        $temp = " Seratus" . penyebut($nilai - 100);
    } else if ($nilai < 1000) {
        $temp = penyebut(floor($nilai/100)) . " Ratus" . penyebut($nilai % 100);
    } else if ($nilai < 2000) {
        $temp = " Seribu" . penyebut($nilai - 1000);
    } else if ($nilai < 1000000) {
        $temp = penyebut(floor($nilai/1000)) . " Ribu" . penyebut($nilai % 1000);
    } else if ($nilai < 1000000000) {
        $temp = penyebut(floor($nilai/1000000)) . " Juta" . penyebut($nilai % 1000000);
    } else if ($nilai < 1000000000000) {
        $temp = penyebut(floor($nilai/1000000000)) . " Milyar" . penyebut($nilai % 1000000000);
    }
    return $temp;
}

function terbilang($nilai) {
    if ($nilai == 0) {
        return "";
    }
    if ($nilai < 0) {
        return "Minus " . trim(penyebut(abs($nilai)));
    }
    return trim(penyebut($nilai));
}

// Tambahkan fungsi untuk konversi bulan ke bahasa Indonesia
function tanggal_indo($tanggal) {
    if (empty($tanggal) || $tanggal == '0000-00-00') return '';
    
    // Jika tanggal mengandung jam, ambil hanya bagian tanggalnya
    if (strpos($tanggal, ' ') !== false) {
        $tanggal = explode(' ', $tanggal)[0];
    }
    
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Fungsi untuk mendapatkan rincian biaya
function getRincianBiaya($conn, $id_surat, $id_pegawai) {
    $rincian_list = [];
    $total = 0;

    // Query untuk mengambil data dari rincian_biaya_riil
    $query_riil = "SELECT * FROM rincian_biaya_riil 
                  WHERE id_surat = ? AND id_pegawai = ?";
    $stmt = mysqli_prepare($conn, $query_riil);
    mysqli_stmt_bind_param($stmt, "ii", $id_surat, $id_pegawai);
    mysqli_stmt_execute($stmt);
    $result_riil = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result_riil) > 0) {
        while ($row = mysqli_fetch_assoc($result_riil)) {
            $rincian = array(
                'uraian' => $row['uraian'] ?? '',
                'keterangan' => $row['keterangan'] ?? '',
                'jumlah' => $row['jumlah'] ?? 0
            );
            $rincian_list[] = $rincian;
            $total += (float)($rincian['jumlah']);
        }
    }

    // Query untuk mengambil data dari rincian_bimtek_perorangan
    $query_bimtek = "SELECT * FROM rincian_bimtek_perorangan 
                     WHERE id_surat = ? AND id_pegawai = ?";
    $stmt = mysqli_prepare($conn, $query_bimtek);
    mysqli_stmt_bind_param($stmt, "ii", $id_surat, $id_pegawai);
    mysqli_stmt_execute($stmt);
    $result_bimtek = mysqli_fetch_assoc(mysqli_stmt_get_result($stmt));

    return [
        'rincian' => $rincian_list,
        'total' => $total,
        'waktu_kedatangan_aktual' => $result_bimtek['waktu_kedatangan_aktual'] ?? null,
        'waktu_kepulangan_aktual' => $result_bimtek['waktu_kepulangan_aktual'] ?? null,
        'total_uang_harian' => $result_bimtek['total_uang_harian'] ?? 0,
        'total_representatif' => $result_bimtek['total_representatif'] ?? 0,
        'transport_dalam_provinsi' => $result_bimtek['transport_dalam_provinsi'] ?? 0,
        'transport_luar_provinsi' => $result_bimtek['transport_luar_provinsi'] ?? 0,
        'akomodasi' => $result_bimtek['akomodasi'] ?? 0,
        'biaya_jarak' => $result_bimtek['biaya_jarak'] ?? 0,
        'jarak' => $result_bimtek['jarak'] ?? 0,
        'biaya_pesawat_berangkat' => $result_bimtek['biaya_pesawat_berangkat'] ?? 0,
        'biaya_pesawat_pulang' => $result_bimtek['biaya_pesawat_pulang'] ?? 0
    ];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Cetak Rincian Biaya - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <style>
        @page {
            size: 215.9mm 330mm !important; /* Ukuran F4 */
            margin: 5mm 14mm 12.5mm 14mm; /* Mengurangi margin atas */
        }
        
        html {
            display: flex;
            justify-content: center;
            width: 215.9mm;
            min-height: 330mm;
            margin: 0 auto;
        }
        
        body {
            font-family: Times New Roman, serif;
            line-height: 1.4; /* Mengurangi line height */
            font-size: 12pt;
            margin: 0 auto;
            padding: 0;
            width: 187.9mm;
            min-height: 330mm;
            transform-origin: 0 0;
            transform: none !important;
        }
        
        @media print {
            @page {
                size: 215.9mm 330mm !important;
                margin: 5mm 14mm 12.5mm 14mm;
            }
            
            html, body {
                width: 215.9mm !important;
                height: 330mm !important;
                transform: none !important;
            }

            body {
                margin: 0 auto;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            #printSection {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
            }
        }
        .header {
            text-align: center;
            margin-bottom: 10px; /* Mengurangi margin bottom */
            margin-top: 10px; /* Mengurangi margin top */
        }
        .header h2 {
            margin: 0;
            font-size: 14pt;
            text-decoration: underline;
            line-height: 1.2;
        }
        .header h3 {
            margin: 3px 0 0 0; /* Mengurangi margin */
            font-size: 14pt;
            line-height: 1.2;
        }
        .content {
            margin: 10px 0; /* Mengurangi margin */
            line-height: 1.3;
        }
        .identitas-row {
            display: flex;
            margin: 3px 0; /* Mengurangi margin */
            line-height: 1.3;
        }
        .identitas-label {
            width: 100px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0; /* Mengurangi margin */
        }
        table.main-table, .main-table th, .main-table td {
            border: 1px solid black;
        }
        th, td {
            padding: 6px 8px; /* Mengurangi padding */
            font-size: 12pt;
            line-height: 1.3;
        }
        .no-border {
            border: none !important;
        }
        .footer {
            margin-top: 20px; /* Mengurangi margin */
            display: flex;
            justify-content: space-between;
        }
        .footer-section {
            width: 30%;
        }
        .footer-section p {
            margin: 0 0 5px 0; /* Mengurangi margin */
            line-height: 1.3;
        }
        .signature-section {
            margin-top: 40px; /* Mengurangi margin */
        }
        .rampung-section {
            border-top: 1px solid black;
            margin-top: 20px; /* Mengurangi margin */
            padding-top: 8px; /* Mengurangi padding */
        }
        .rampung-section h3 {
            margin: 0 0 8px 0; /* Mengurangi margin */
            font-size: 12pt;
            line-height: 1.2;
        }
        .rampung-section table tr td {
            padding: 3px 8px; /* Mengurangi padding */
            line-height: 1.3;
        }
        .page-break {
            page-break-after: always;
            break-after: page;
            margin-bottom: 0;
        }
        .nama-pegawai {
            text-transform: uppercase;
        }
        /* Tambahkan style untuk mengatur halaman ganjil-genap */
        .page-container:nth-child(odd) {
            page-break-after: always;
        }
        
        .page-container:nth-child(even) {
            page-break-after: always;
        }
        
        .page-container:last-child {
            page-break-after: avoid;
            break-after: avoid;
        }

        /* Style untuk kedua jenis rincian */
        .rincian-riil, .rincian-biaya {
            width: 100%;
        }
    </style>
</head>
<body>
    <div id="printSection">
        <?php foreach ($all_pegawai as $index => $pegawai): 
            $rincian_data = getRincianBiaya($conn, $id_surat, $pegawai['id_pegawai']);
            $rincian_list = $rincian_data['rincian'];
            $total_riil = $rincian_data['total'];

            // Hitung total biaya untuk rincian biaya
            $total_biaya = 0;
            if ($data['jenis_surat'] == 'Dalam Daerah Dalam Provinsi') {
                $total_biaya = ($rincian_data['total_uang_harian'] ?? 0) + 
                             ($rincian_data['total_representatif'] ?? 0) + 
                             ($rincian_data['transport_dalam_provinsi'] ?? 0) + 
                             ($rincian_data['akomodasi'] ?? 0) + 
                             ($rincian_data['biaya_jarak'] ?? 0);
            } else if ($data['jenis_surat'] == 'Luar Daerah Dalam Provinsi') {
                $total_biaya = ($rincian_data['total_uang_harian'] ?? 0) + 
                             ($rincian_data['total_representatif'] ?? 0) + 
                             ($rincian_data['transport_dalam_provinsi'] ?? 0) + 
                             ($rincian_data['akomodasi'] ?? 0);
            } else {
                $total_biaya = ($rincian_data['total_uang_harian'] ?? 0) + 
                             ($rincian_data['total_representatif'] ?? 0) + 
                             ($rincian_data['transport_dalam_provinsi'] ?? 0) + 
                             ($rincian_data['transport_luar_provinsi'] ?? 0) + 
                             ($rincian_data['akomodasi'] ?? 0) + 
                             ($rincian_data['biaya_pesawat_berangkat'] ?? 0) + 
                             ($rincian_data['biaya_pesawat_pulang'] ?? 0);
            }
        ?>
            <!-- Halaman 1 - Rincian Biaya -->
            <div class="page-container page-break">
                <div class="judul" style="text-align: center;">
                    <h2 style="margin-bottom: 0; text-decoration: underline;">RINCIAN BIAYA PERJALANAN DINAS</h2>
                    <h3 style="margin-top: 0;"><?= strtoupper($data['jenis_surat']) ?></h3>
                </div>
                <div style="margin: 8px 0;">
                    Lampiran SPPD Nomor : <?= htmlspecialchars($data['no_sppd']) ?><br>
                    Tanggal             : <?= tanggal_indo($data['tanggal_surat']) ?>
                </div>

                <table class="main-table">
                    <tr>
                        <th width="5%">No</th>
                        <th width="65%">PERINCIAN BIAYA</th>
                        <th width="30%">JUMLAH</th>
                        <th width="30%">KETERANGAN</th>
                    </tr>
                    <?php
                    $no = 1;
                    $total = 0;
                    
                    // Sesuaikan items berdasarkan jenis surat
                    if ($data['jenis_surat'] == 'Dalam Daerah Dalam Provinsi') {
                            // Gunakan data langsung dari database untuk pegawai saat ini
                            // Hitung total hari termasuk hari pertama dan terakhir
                            if ($rincian_data['waktu_kedatangan_aktual'] && $rincian_data['waktu_kepulangan_aktual']) {
                                $start_date = new DateTime($rincian_data['waktu_kedatangan_aktual']);
                                $end_date = new DateTime($rincian_data['waktu_kepulangan_aktual']);
                                $total_hari = $start_date->diff($end_date)->days + 1;
                            } else {
                                $start_date = new DateTime($data['tanggal_berangkat']);
                                $end_date = new DateTime($data['tanggal_kembali']);
                                $total_hari = $start_date->diff($end_date)->days + 1;
                            }
                            
                            // Check if actual dates exist for this person
                            $tanggal_berangkat = $rincian_data['waktu_kedatangan_aktual'] ? tanggal_indo($rincian_data['waktu_kedatangan_aktual']) : tanggal_indo($data['tanggal_berangkat']);
                            $tanggal_kembali = $rincian_data['waktu_kepulangan_aktual'] ? tanggal_indo($rincian_data['waktu_kepulangan_aktual']) : tanggal_indo($data['tanggal_kembali']);
                            
                        $items = [
                            ['uraian' => 'Uang Harian',
                                 'nilai' => $rincian_data['total_uang_harian'] ?? 0,
                                 'keterangan' => $total_hari . ' hari']
                        ];
                        
                        // Add representatif only if it exists and is greater than 0
                            if (($rincian_data['total_representatif'] ?? 0) > 0) {
                            $items[] = [
                                'uraian' => 'Uang Representatif',
                                    'nilai' => $rincian_data['total_representatif'],
                                    'keterangan' => $total_hari . ' hari'
                            ];
                        }
                        
                        $items = array_merge($items, [
                            ['uraian' => 'Transport', 
                                 'nilai' => $rincian_data['transport_dalam_provinsi'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Akomodasi',
                                 'nilai' => $rincian_data['akomodasi'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Biaya Jarak',
                                 'nilai' => $rincian_data['biaya_jarak'] ?? 0,
                                 'keterangan' => ($rincian_data['jarak'] ?? 0) > 0 ? ($rincian_data['jarak'] . ' KM') : '']
                        ]);
                    } 
                    else if ($data['jenis_surat'] == 'Luar Daerah Dalam Provinsi') {
                            // Hitung total hari termasuk hari pertama dan terakhir
                            if ($rincian_data['waktu_kedatangan_aktual'] && $rincian_data['waktu_kepulangan_aktual']) {
                                $start_date = new DateTime($rincian_data['waktu_kedatangan_aktual']);
                                $end_date = new DateTime($rincian_data['waktu_kepulangan_aktual']);
                                $total_hari = $start_date->diff($end_date)->days + 1;
                            } else {
                                $start_date = new DateTime($data['tanggal_berangkat']);
                                $end_date = new DateTime($data['tanggal_kembali']);
                                $total_hari = $start_date->diff($end_date)->days + 1;
                            }
                            
                            // Check if actual dates exist for this person
                            $tanggal_berangkat = $rincian_data['waktu_kedatangan_aktual'] ? tanggal_indo($rincian_data['waktu_kedatangan_aktual']) : tanggal_indo($data['tanggal_berangkat']);
                            $tanggal_kembali = $rincian_data['waktu_kepulangan_aktual'] ? tanggal_indo($rincian_data['waktu_kepulangan_aktual']) : tanggal_indo($data['tanggal_kembali']);
                            
                        $items = [
                            ['uraian' => 'Uang Harian',
                                 'nilai' => $rincian_data['total_uang_harian'] ?? 0,
                                 'keterangan' => $total_hari . ' hari']
                            ];
                            
                            if (($rincian_data['total_representatif'] ?? 0) > 0) {
                            $items[] = [
                                'uraian' => 'Uang Representatif',
                                    'nilai' => $rincian_data['total_representatif'],
                                    'keterangan' => $total_hari . ' hari'
                            ];
                        }
                        
                        $items = array_merge($items, [
                            ['uraian' => 'Transport', 
                                 'nilai' => $rincian_data['transport_dalam_provinsi'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Akomodasi', 
                                 'nilai' => $rincian_data['akomodasi'] ?? 0,
                             'keterangan' => '']
                        ]);
                    }
                    else { // Luar Daerah Luar Provinsi
                            // Hitung total hari termasuk hari pertama dan terakhir
                            if ($rincian_data['waktu_kedatangan_aktual'] && $rincian_data['waktu_kepulangan_aktual']) {
                                $start_date = new DateTime($rincian_data['waktu_kedatangan_aktual']);
                                $end_date = new DateTime($rincian_data['waktu_kepulangan_aktual']);
                                $total_hari = $start_date->diff($end_date)->days + 1;
                            } else {
                                $start_date = new DateTime($data['tanggal_berangkat']);
                                $end_date = new DateTime($data['tanggal_kembali']);
                                $total_hari = $start_date->diff($end_date)->days + 1;
                            }
                            
                            // Check if actual dates exist for this person
                            $tanggal_berangkat = $rincian_data['waktu_kedatangan_aktual'] ? tanggal_indo($rincian_data['waktu_kedatangan_aktual']) : tanggal_indo($data['tanggal_berangkat']);
                            $tanggal_kembali = $rincian_data['waktu_kepulangan_aktual'] ? tanggal_indo($rincian_data['waktu_kepulangan_aktual']) : tanggal_indo($data['tanggal_kembali']);
                            
                        $items = [
                            ['uraian' => 'Uang Harian',
                                 'nilai' => $rincian_data['total_uang_harian'] ?? 0,
                                 'keterangan' => $total_hari . ' hari']
                            ];
                            
                            if (($rincian_data['total_representatif'] ?? 0) > 0) {
                            $items[] = [
                                'uraian' => 'Uang Representatif',
                                    'nilai' => $rincian_data['total_representatif'],
                                    'keterangan' => $total_hari . ' hari'
                            ];
                        }
                        
                        $items = array_merge($items, [
                            ['uraian' => 'Transport Dalam Provinsi', 
                                 'nilai' => $rincian_data['transport_dalam_provinsi'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Transport Luar Provinsi', 
                                 'nilai' => $rincian_data['transport_luar_provinsi'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Akomodasi', 
                                 'nilai' => $rincian_data['akomodasi'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Pesawat Berangkat', 
                                 'nilai' => $rincian_data['biaya_pesawat_berangkat'] ?? 0,
                             'keterangan' => ''],
                            ['uraian' => 'Pesawat Pulang', 
                                 'nilai' => $rincian_data['biaya_pesawat_pulang'] ?? 0,
                             'keterangan' => '']
                        ]);
                    }

                    foreach ($items as $item):
                        $total += $item['nilai'];
                    ?>
                    <tr>
                        <td align="center"><?= $no++ ?>.</td>
                        <td><?= $item['uraian'] ?></td>
                        <td>Rp. <?= number_format($item['nilai'], 0, ',', '.') ?></td>
                        <td><?= $item['keterangan'] ?></td>
                    </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td colspan="2" align="center">JUMLAH</td>
                        <td>Rp. <?= number_format($total, 0, ',', '.') ?></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="4">Terbilang : <?php 
                            try {
                                $hasil_terbilang = terbilang($total);
                                echo !empty($hasil_terbilang) ? ucwords($hasil_terbilang) . " Rupiah" : "Rupiah";
                            } catch (Exception $e) {
                                echo "Rupiah";
                            }
                        ?></td>
                    </tr>
                </table>

                <div class="footer">
                    <div class="footer-section">
                        <p>
                            Telah dibayar sejumlah<br>
                            Rp. <?= number_format($total, 0, ',', '.') ?><br><br>
                            Bendahara<br><br>
                            <br><br>
                            SUMARNI, S.AP<br>
                            NIP 19811019 201001 2 025
                        </p>
                    </div>
                    <div class="footer-section">
                        <p>
                            Paringin, <?= tanggal_indo($data['tanggal_kembali']) ?><br>
                            Telah menerima jumlah uang sebesar<br>
                            Rp. <?= number_format($total, 0, ',', '.') ?><br>
                            Yang Menerima<br>
                            <br><br><br>
                                <?= strtoupper(htmlspecialchars($pegawai['nama_pegawai'])) ?><br>
                                NIP. <?= htmlspecialchars($pegawai['nip']) ?>
                        </p>    
                    </div>
                </div>

                <div class="rampung-section">
                    <h3>PERHITUNGAN SPPD RAMPUNG</h3>
                    <table class="no-border">
                        <tr>
                            <td width="200">Ditetapkan</td>
                            <td width="10">:</td>
                            <td>Rp. <?= number_format($total, 0, ',', '.') ?></td>
                        </tr>
                        <tr>
                            <td>Yang telah dibayar semula</td>
                            <td>:</td>
                            <td>Rp. <?= number_format($total, 0, ',', '.') ?></td>
                        </tr>
                        <tr>
                            <td>Sisa Lebih</td>
                            <td>:</td>
                            <td>Rp. 0</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Halaman 2 - Rincian Riil -->
            <div class="page-container page-break">
                <div class="kop-surat">
                    <img src="../assets/img/kop/kopdinas.png" alt="Kop Surat" style="width: 100%; margin-bottom: 10px;">
                </div>

                <div class="judul" style="text-align: center;">
                    <h2 style="margin-bottom: 0;">SURAT PERNYATAAN</h2>
                    <h2 style="margin-top: 0;">DAFTAR PENGELUARAN RIIL</h2>
                </div>

                <div class="content">
                    Yang bertandatangan dibawah ini :<br><br>
                    
                    <table class="no-border" style="margin-top: 0;">
                        <tr>
                            <td style="width: 100px;">Nama</td>
                            <td style="width: 10px;">:</td>
                            <td><?= strtoupper(htmlspecialchars($pegawai['nama_pegawai'])) ?></td>
                        </tr>
                        <tr>
                            <td>NIP</td>
                            <td>:</td>
                            <td><?= htmlspecialchars($pegawai['nip']) ?></td>
                        </tr>
                        <tr>
                            <td>Jabatan</td>
                            <td>:</td>
                            <td><?= htmlspecialchars($pegawai['jabatan']) ?></td>
                        </tr>
                    </table>

                    <p style="margin-top: 20px;">Berdasarkan Surat Perintah Perjalanan Dinas ( SPPD ) tanggal <?= tanggal_indo($data['tanggal_surat']) ?> Nomor : <?= htmlspecialchars($data['no_sppd']) ?>, dengan ini kami menyatakan dengan sesungguhnya bahwa :</p>

                    <p>1. Biaya Penginapan dan transportasi pegawai dibawah ini yang tidak dapat diperoleh bukti - bukti pengeluaran berupa, meliputi :</p>
                </div>

                <table class="main-table" style="margin-top: 10px;">
                    <tr>
                        <th style="width: 10%">No</th>
                        <th style="width: 60%">URAIAN</th>
                        <th style="width: 30%">JUMLAH</th>
                    </tr>
                    <?php 
                    $no = 1;
                    foreach ($rincian_list as $row): 
                        // Tambahkan keterangan dalam kurung jika ada
                        $uraian = $row['uraian'];
                        if (!empty($row['keterangan'])) {
                            $uraian .= ' (' . $row['keterangan'] . ')';
                        }
                    ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td><?= htmlspecialchars($uraian) ?></td>
                            <td class="text-end">Rp <?= number_format($row['jumlah'], 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <tr>
                        <td colspan="2" class="text-center"><strong>Total</strong></td>
                        <td class="text-end">Rp <?= number_format($total_riil, 0, ',', '.') ?></td>
                    </tr>
                    <tr>
                        <td colspan="3" style="text-align: left; padding: 10px;">
                            <strong>Terbilang : <?= ucwords(terbilang($total_riil)) ?> Rupiah</strong>
                        </td>
                    </tr>
                </table>

                <div class="content" style="margin-top: 20px;">
                    <p>2. Jumlah uang tersebut pada angka 1 di atas benar-benar dikeluarkan untuk pelaksanaan perjalanan dinas dimaksud dan apabila di kemudian hari terdapat kelebihan atas pembayaran, kami bersedia untuk menyetor kelebihan tersebut ke Kas Negara.</p>
                    
                    <p>Demikian Pernyataan ini kami buat dengan sebenarnya, untuk dipergunakan sebagaimana mestinya.</p>
                </div>

                <table class="no-border" style="margin-top: 30px;">
                    <tr>
                        <td style="width: 50%; vertical-align: top;">
                            <p style="margin: 0;">Mengetahui / Menyetujui</p>
                            <p style="margin: 0;">Pengguna Anggaran</p>
                            <br><br><br>
                            <p style="margin: 0;"><u>H. ABIJI, S.Pd, M.AP</u></p>
                            <p style="margin: 0;">NIP. 19690813 199412 1 002</p>
                        </td>
                        <td style="width: 50%; vertical-align: top;">
                            <div style="width: 200px; margin-left: auto; padding-right: 40px;">
                                <p style="margin: 0;">Paringin, <?= tanggal_indo($data['tanggal_kembali']) ?></p>
                                <p style="margin: 0;">Pelaksana Perjalanan Dinas</p>
                                <br><br><br>
                                <p style="margin: 0;"><u><?= strtoupper(htmlspecialchars($pegawai['nama_pegawai'])) ?></u></p>
                                <p style="margin: 0;">NIP. <?= htmlspecialchars($pegawai['nip']) ?></p>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
        <?php endforeach; ?>
    </div>

    <style>
        @page {
            size: 215.9mm 330mm !important; /* Ukuran F4 */
            margin: 5mm 14mm 12.5mm 14mm; /* Mengurangi margin atas */
        }
        
        html {
            display: flex;
            justify-content: center;
            width: 215.9mm;
            min-height: 330mm;
            margin: 0 auto;
        }
        
        body {
            font-family: Times New Roman, serif;
            line-height: 1.4; /* Mengurangi line height */
            font-size: 12pt;
            margin: 0 auto;
            padding: 0;
            width: 187.9mm;
            min-height: 330mm;
            transform-origin: 0 0;
            transform: none !important;
        }
        
        @media print {
            @page {
                size: 215.9mm 330mm !important;
                margin: 5mm 14mm 12.5mm 14mm;
            }
            
            html, body {
                width: 215.9mm !important;
                height: 330mm !important;
                transform: none !important;
            }

            body {
                margin: 0 auto;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            #printSection {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
            }
        }
        .header {
            text-align: center;
            margin-bottom: 10px; /* Mengurangi margin bottom */
            margin-top: 10px; /* Mengurangi margin top */
        }
        .header h2 {
            margin: 0;
            font-size: 14pt;
            text-decoration: underline;
            line-height: 1.2;
        }
        .header h3 {
            margin: 3px 0 0 0; /* Mengurangi margin */
            font-size: 14pt;
            line-height: 1.2;
        }
        .content {
            margin: 10px 0; /* Mengurangi margin */
            line-height: 1.3;
        }
        .identitas-row {
            display: flex;
            margin: 3px 0; /* Mengurangi margin */
            line-height: 1.3;
        }
        .identitas-label {
            width: 100px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0; /* Mengurangi margin */
        }
        table.main-table, .main-table th, .main-table td {
            border: 1px solid black;
        }
        th, td {
            padding: 6px 8px; /* Mengurangi padding */
            font-size: 12pt;
            line-height: 1.3;
        }
        .no-border {
            border: none !important;
        }
        .footer {
            margin-top: 20px; /* Mengurangi margin */
            display: flex;
            justify-content: space-between;
        }
        .footer-section {
            width: 30%;
        }
        .footer-section p {
            margin: 0 0 5px 0; /* Mengurangi margin */
            line-height: 1.3;
        }
        .signature-section {
            margin-top: 40px; /* Mengurangi margin */
        }
        .rampung-section {
            border-top: 1px solid black;
            margin-top: 20px; /* Mengurangi margin */
            padding-top: 8px; /* Mengurangi padding */
        }
        .rampung-section h3 {
            margin: 0 0 8px 0; /* Mengurangi margin */
            font-size: 12pt;
            line-height: 1.2;
        }
        .rampung-section table tr td {
            padding: 3px 8px; /* Mengurangi padding */
            line-height: 1.3;
        }
        .page-break {
            page-break-after: always;
            break-after: page;
            margin-bottom: 0;
        }
        .nama-pegawai {
            text-transform: uppercase;
        }
        /* Tambahkan style untuk mengatur halaman ganjil-genap */
        .page-container:nth-child(odd) {
            page-break-after: always;
        }
        
        .page-container:nth-child(even) {
            page-break-after: always;
        }
        
        .page-container:last-child {
            page-break-after: avoid;
            break-after: avoid;
        }

        /* Style untuk kedua jenis rincian */
        .rincian-riil, .rincian-biaya {
            width: 100%;
        }
    </style>

    <script>
        window.onload = function() {
            // Mengatur properti pencetakan
            const style = document.createElement('style');
            style.innerHTML = `
```
```
</script>
</body>
</html>