<?php
session_start();
require_once '../config/database.php';

if (isset($_GET['id'])) {
    $id_surat = $_GET['id'];
    
    try {
        // Mulai transaksi
        $conn->begin_transaction();

        // Hapus rincian biaya dari tabel rincian_bimtek_perorangan
        $query = "DELETE FROM rincian_bimtek_perorangan WHERE id_surat = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $id_surat);
        
        if ($stmt->execute()) {
            $conn->commit();
            $_SESSION['alert'] = [
                'type' => 'success',
                'message' => 'Rincian biaya berhasil dihapus'
            ];
        } else {
            throw new Exception("Gagal menghapus rincian biaya");
        }
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Gagal menghapus rincian biaya: ' . $e->getMessage()
        ];
    }
}

header("Location: detail_rincian.php?id=" . $id_surat);
exit();
?> 