<?php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_surat = $_POST['id_surat'] ?? null;
    $no_sub_kegiatan = $_POST['no_sub_kegiatan'] ?? null;
    
    if (!$id_surat || !$no_sub_kegiatan) {
        echo json_encode(['success' => false, 'message' => 'Data tidak lengkap']);
        exit;
    }

    try {
        // Mulai transaksi
        mysqli_begin_transaction($conn);

        // Update tabel rincian_bimtek_perorangan
        $query1 = "UPDATE rincian_bimtek_perorangan SET no_sub_kegiatan = ? WHERE id_surat = ?";
        $stmt1 = mysqli_prepare($conn, $query1);
        mysqli_stmt_bind_param($stmt1, "si", $no_sub_kegiatan, $id_surat);
        $success1 = mysqli_stmt_execute($stmt1);

        // Update tabel surat_tugas
        $query2 = "UPDATE surat_tugas SET no_sub_kegiatan = ? WHERE id_surat = ?";
        $stmt2 = mysqli_prepare($conn, $query2);
        mysqli_stmt_bind_param($stmt2, "si", $no_sub_kegiatan, $id_surat);
        $success2 = mysqli_stmt_execute($stmt2);

        if ($success1 && $success2) {
            mysqli_commit($conn);
            echo json_encode([
                'success' => true, 
                'message' => 'Nomor Sub Kegiatan berhasil disimpan'
            ]);
        } else {
            mysqli_rollback($conn);
            echo json_encode([
                'success' => false, 
                'message' => 'Gagal menyimpan Nomor Sub Kegiatan'
            ]);
        }
    } catch (Exception $e) {
        mysqli_rollback($conn);
        echo json_encode([
            'success' => false, 
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'success' => false, 
        'message' => 'Method tidak diizinkan'
    ]);
}

mysqli_close($conn);
?> 