<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_surat = $_POST['id_surat'];
    $id_pegawai = $_GET['id_pegawai'];
    $jenis_surat = $_POST['jenis_surat'];
    $total_biaya = 0;
    $keterangan = $_POST['keterangan'];
    
    // Query untuk mengambil data surat
    $query_surat = "SELECT * FROM surat_tugas WHERE id_surat = ?";
    $stmt = mysqli_prepare($conn, $query_surat);
    mysqli_stmt_bind_param($stmt, "i", $id_surat);
    mysqli_stmt_execute($stmt);
    $result_surat = mysqli_stmt_get_result($stmt);
    $surat_data = mysqli_fetch_assoc($result_surat);
    
    // Ambil dan bersihkan data input
    $uang_harian_per_hari = str_replace('.', '', $_POST['uang_harian_per_hari']);
    $total_uang_harian = $uang_harian_per_hari * 2; // Selalu 2 hari (pertama dan terakhir)
    
    $uang_diklat_per_hari = str_replace('.', '', $_POST['uang_diklat']);
    $sisa_hari_diklat = max(0, $surat_data['lama_perjalanan'] - 2); // Sisa hari untuk diklat
    $total_uang_diklat = $uang_diklat_per_hari * $sisa_hari_diklat;
    
    $representatif_per_hari = str_replace('.', '', $_POST['representatif'] ?? '0');
    $total_representatif = $representatif_per_hari * $surat_data['lama_perjalanan'];
    
    $transport_dalam_provinsi = str_replace('.', '', $_POST['transport_dalam'] ?? '0');
    $transport_luar_provinsi = str_replace('.', '', $_POST['transport_luar'] ?? '0');
    $biaya_pesawat_berangkat = str_replace('.', '', $_POST['pesawat_berangkat'] ?? '0');
    $biaya_pesawat_pulang = str_replace('.', '', $_POST['pesawat_kembali'] ?? '0');
    $akomodasi = str_replace('.', '', $_POST['akomodasi'] ?? '0');
    $tujuan = $_POST['tujuan'] ?? '';
    
    // Hitung total biaya
    $total_biaya = $total_uang_harian + $total_uang_diklat + $total_representatif + $transport_dalam_provinsi + 
                   $transport_luar_provinsi + $biaya_pesawat_berangkat + 
                   $biaya_pesawat_pulang + $akomodasi;
    
    // Cek apakah sudah ada rincian biaya
    $check_query = "SELECT id_rincian_perorangan FROM rincian_bimtek_perorangan WHERE id_surat = ? AND id_pegawai = ?";
    $stmt = mysqli_prepare($conn, $check_query);
    mysqli_stmt_bind_param($stmt, "ii", $id_surat, $id_pegawai);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        // Update data yang ada
        $query = "UPDATE rincian_bimtek_perorangan SET 
                  uang_harian_per_hari = ?,
                  total_uang_harian = ?,
                  uang_diklat_per_hari = ?,
                  total_uang_diklat = ?,
                  representatif_per_hari = ?,
                  total_representatif = ?,
                  transport_dalam_provinsi = ?,
                  transport_luar_provinsi = ?,
                  biaya_pesawat_berangkat = ?,
                  biaya_pesawat_pulang = ?,
                  akomodasi = ?,
                  total_biaya = ?,
                  updated_at = CURRENT_TIMESTAMP
                  WHERE id_surat = ? AND id_pegawai = ?";
        
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "ddddddiiiiidii", 
            $uang_harian_per_hari,
            $total_uang_harian,
            $uang_diklat_per_hari,
            $total_uang_diklat,
            $representatif_per_hari,
            $total_representatif,
            $transport_dalam_provinsi,
            $transport_luar_provinsi,
            $biaya_pesawat_berangkat,
            $biaya_pesawat_pulang,
            $akomodasi,
            $total_biaya,
            $id_surat,
            $id_pegawai
        );
    } else {
        // Insert data baru
        $query = "INSERT INTO rincian_bimtek_perorangan (
                    id_surat, 
                    id_pegawai, 
                    uang_harian_per_hari,
                    total_uang_harian,
                    uang_diklat_per_hari,
                    total_uang_diklat,
                    representatif_per_hari,
                    total_representatif,
                    transport_dalam_provinsi,
                    transport_luar_provinsi,
                    biaya_pesawat_berangkat,
                    biaya_pesawat_pulang,
                    akomodasi,
                    total_biaya
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "iiddddddiiiiid", 
            $id_surat,
            $id_pegawai,
            $uang_harian_per_hari,
            $total_uang_harian,
            $uang_diklat_per_hari,
            $total_uang_diklat,
            $representatif_per_hari,
            $total_representatif,
            $transport_dalam_provinsi,
            $transport_luar_provinsi,
            $biaya_pesawat_berangkat,
            $biaya_pesawat_pulang,
            $akomodasi,
            $total_biaya
        );
    }

    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Rincian biaya berhasil disimpan'
        ];
        header("Location: detail_rincian_perorangan.php?id_surat=" . $id_surat . "&id_pegawai=" . $id_pegawai);
        exit();
    } else {
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Gagal menyimpan rincian biaya: ' . mysqli_error($conn)
        ];
    }
}

if (isset($_GET['id_surat'])) {
    $id_surat = $_GET['id_surat'];
    
    // Query untuk mengambil data surat tugas
    $query_surat = "SELECT st.*, 
                           GROUP_CONCAT(CONCAT(p.nama_pegawai, ' - ', COALESCE(dst.tujuan_pegawai, '-')) SEPARATOR '\n') as pegawai_tujuan,
                           GROUP_CONCAT(p.nama_pegawai SEPARATOR ', ') as nama_pegawai
                    FROM surat_tugas st 
                    LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
                    LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai 
                    WHERE st.id_surat = ?
                    GROUP BY st.id_surat";
    
    $stmt = mysqli_prepare($conn, $query_surat);
    mysqli_stmt_bind_param($stmt, "i", $id_surat);
    mysqli_stmt_execute($stmt);
    $result_surat = mysqli_stmt_get_result($stmt);
    $surat = mysqli_fetch_assoc($result_surat);

    // Query untuk mengambil rincian biaya perorangan jika ada, jika tidak ambil dari rincian kelompok
    $query_rincian = "SELECT 
        COALESCE(rbp.id_rincian_perorangan, rb.id_rincian) as id_rincian,
        COALESCE(rbp.uang_harian_per_hari, rb.uang_harian_per_hari) as uang_harian_per_hari,
        COALESCE(rbp.total_uang_harian, rb.total_uang_harian) as total_uang_harian,
        COALESCE(rbp.uang_diklat_per_hari, rb.uang_diklat_per_hari) as uang_diklat_per_hari,
        COALESCE(rbp.total_uang_diklat, rb.total_uang_diklat) as total_uang_diklat,
        COALESCE(rbp.representatif_per_hari, rb.representatif_per_hari) as representatif_per_hari,
        COALESCE(rbp.total_representatif, rb.total_representatif) as total_representatif,
        COALESCE(rbp.transport_dalam_provinsi, rb.transport_dalam_provinsi) as transport_dalam_provinsi,
        COALESCE(rbp.transport_luar_provinsi, rb.transport_luar_provinsi) as transport_luar_provinsi,
        COALESCE(rbp.biaya_pesawat_berangkat, rb.biaya_pesawat_berangkat) as biaya_pesawat_berangkat,
        COALESCE(rbp.biaya_pesawat_pulang, rb.biaya_pesawat_pulang) as biaya_pesawat_pulang,
        COALESCE(rbp.akomodasi, rb.akomodasi) as akomodasi,
        COALESCE(rbp.total_biaya, rb.total_biaya) as total_biaya,
        rb.tujuan,
        rb.keterangan,
        CASE 
            WHEN rbp.id_rincian_perorangan IS NOT NULL THEN 'perorangan'
            ELSE 'umum'
        END as sumber_data
    FROM surat_tugas st
    LEFT JOIN rincian_bimtek_perorangan rbp ON (rbp.id_surat = st.id_surat AND rbp.id_pegawai = ?)
    LEFT JOIN rincian_bimtek rb ON rb.id_surat = st.id_surat
    WHERE st.id_surat = ?
    ORDER BY rbp.id_rincian_perorangan DESC, rb.id_rincian DESC
    LIMIT 1";

    $stmt = mysqli_prepare($conn, $query_rincian);
    mysqli_stmt_bind_param($stmt, "ii", $_GET['id_pegawai'], $id_surat);
    mysqli_stmt_execute($stmt);
    $result_rincian = mysqli_stmt_get_result($stmt);
    $rincian = mysqli_fetch_assoc($result_rincian);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Tambah/Edit Rincian Biaya - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .card {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .header-wrapper {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            padding: 1.5rem;
            border-radius: 0.5rem;
            margin-bottom: 2rem;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-wrapper">
            <h2 class="mb-0">Tambah/Edit Rincian Biaya</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="../dashboard.php" class="text-white-50">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="index.php" class="text-white-50">Rincian Biaya</a></li>
                    <li class="breadcrumb-item active text-white">Tambah/Edit Rincian</li>
                </ol>
            </nav>
        </div>

        <?php if (isset($surat)): ?>
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Informasi Surat Tugas</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="150">ID Surat</th>
                                <td><?= htmlspecialchars($surat['id_surat']) ?></td>
                            </tr>
                            <tr>
                                <th>Jenis Surat</th>
                                <td><?= htmlspecialchars($surat['jenis_surat']) ?></td>
                            </tr>
                            <tr>
                                <th>No. Surat</th>
                                <td><?= htmlspecialchars($surat['no_surat']) ?></td>
                            </tr>
                            <tr>
                                <th>No. SPPD</th>
                                <td><?= htmlspecialchars($surat['no_sppd']) ?></td>
                            </tr>
                            <tr>
                                <th width="150">Nama Pegawai</th>
                                <td><?= htmlspecialchars($surat['nama_pegawai']) ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th>Tanggal Berangkat</th>
                                <td><?= date('d/m/Y', strtotime($surat['tanggal_berangkat'])) ?></td>
                            </tr>
                            <tr>
                                <th>Tanggal Kembali</th>
                                <td><?= date('d/m/Y', strtotime($surat['tanggal_kembali'])) ?></td>
                            </tr>
                            <tr>
                                <th>Tujuan</th>
                                <td><?= htmlspecialchars($surat['tujuan']) ?></td>
                            </tr>
                            <tr>
                                <th>Tempat Kegiatan</th>
                                <td><?php 
                                    if ($surat['jenis_surat'] == 'Dalam Daerah Dalam Provinsi') {
                                        $pegawai_tujuan = explode("\n", $surat['pegawai_tujuan']);
                                        foreach ($pegawai_tujuan as $pt) {
                                            echo htmlspecialchars($pt) . "<br>";
                                        }
                                    } else {
                                        echo htmlspecialchars($surat['tempat_kegiatan'] ?: '-');
                                    }
                                ?></td>
                            </tr>
                            <tr>
                                <th>Lama Perjalanan</th>
                                <td><?= $surat['lama_perjalanan'] ?> Hari</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Form Rincian Biaya</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="" id="formRincian">
                    <input type="hidden" name="id_surat" value="<?= $id_surat ?>">
                    <input type="hidden" name="jenis_surat" value="<?= $surat['jenis_surat'] ?>">
                    
                    <!-- Uang Harian - Ditampilkan untuk semua jenis surat -->
                    <div class="mb-3">
                        <label class="form-label">Uang Harian (2 Hari)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" class="form-control money" name="uang_harian_per_hari" id="uang_harian_per_hari" 
                                   value="<?= isset($rincian['uang_harian_per_hari']) ? number_format($rincian['uang_harian_per_hari'], 0, ',', '.') : '0' ?>"
                                   onchange="hitungTotalUangHarian()" required>
                        </div>
                        <small class="text-muted" id="keterangan_uang_harian"></small>
                        <?php if (isset($rincian['sumber_data']) && $rincian['sumber_data'] == 'umum'): ?>
                        <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                        <?php endif; ?>
                    </div>
                        
                    <!-- Uang Diklat - Ditampilkan untuk semua jenis surat -->
                    <div class="mb-3">
                        <label class="form-label">Uang Diklat Per Hari (<?= max(0, $surat['lama_perjalanan'] - 2) ?> Hari)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" class="form-control money" name="uang_diklat" id="uang_diklat_per_hari"
                                   value="<?= isset($rincian['uang_diklat_per_hari']) ? number_format($rincian['uang_diklat_per_hari'], 0, ',', '.') : '0' ?>" 
                                   onchange="hitungUangDiklat()" required>
                        </div>
                        <small class="text-muted" id="keterangan_uang_diklat"></small>
                        <?php if (isset($rincian['sumber_data']) && $rincian['sumber_data'] == 'umum'): ?>
                        <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                        <?php endif; ?>
                    </div>

                    <?php if ($surat['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): ?>
                    <!-- Fields untuk Dalam Daerah Dalam Provinsi -->
                        <div class="mb-3">
                            <label class="form-label">Transport</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="transport_dalam" 
                                       value="<?= isset($rincian['transport_dalam_provinsi']) ? number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Akomodasi</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="akomodasi" 
                                       value="<?= isset($rincian['akomodasi']) ? number_format($rincian['akomodasi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>

                    <?php elseif ($surat['jenis_surat'] == 'Luar Daerah Dalam Provinsi'): ?>
                    <!-- Fields untuk Luar Daerah Dalam Provinsi -->
                        <div class="mb-3">
                            <label class="form-label">Transport</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="transport_dalam" 
                                       value="<?= isset($rincian['transport_dalam_provinsi']) ? number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Akomodasi</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="akomodasi" 
                                       value="<?= isset($rincian['akomodasi']) ? number_format($rincian['akomodasi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>

                    <?php elseif ($surat['jenis_surat'] == 'Luar Daerah Luar Provinsi'): ?>
                    <!-- Fields untuk Luar Daerah Luar Provinsi -->
                        <div class="mb-3">
                            <label class="form-label">Transport Dalam Provinsi</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="transport_dalam" 
                                       value="<?= isset($rincian['transport_dalam_provinsi']) ? number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Transport Luar Provinsi</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="transport_luar" 
                                       value="<?= isset($rincian['transport_luar_provinsi']) ? number_format($rincian['transport_luar_provinsi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Biaya Pesawat Berangkat</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="pesawat_berangkat" 
                                       value="<?= isset($rincian['biaya_pesawat_berangkat']) ? number_format($rincian['biaya_pesawat_berangkat'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Biaya Pesawat Pulang</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control money" name="pesawat_kembali" 
                                       value="<?= isset($rincian['biaya_pesawat_pulang']) ? number_format($rincian['biaya_pesawat_pulang'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>

                    <div class="mb-3">
                        <label class="form-label">Akomodasi</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" class="form-control money" name="akomodasi" 
                                   value="<?= isset($rincian['akomodasi']) ? number_format($rincian['akomodasi'], 0, ',', '.') : '0' ?>" required>
                            </div>
                            <?php if ($rincian['sumber_data'] == 'umum'): ?>
                            <small class="text-info">* Nilai default diambil dari rincian kelompok</small>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea class="form-control" name="keterangan" rows="3"><?= isset($rincian['keterangan']) ? htmlspecialchars($rincian['keterangan']) : '' ?></textarea>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                    <a href="detail_rincian.php?id=<?= $id_surat ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Kembali
                        </a>
                        <button type="submit" class="btn btn-primary">Simpan Rincian</button>
                    </div>
                </form>
            </div>
        </div>

        <?php else: ?>
        <div class="alert alert-danger">
            Data surat tugas tidak ditemukan.
        </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    // Format input uang
    $('.money').on('input', function() {
        let value = $(this).val().replace(/[^\d]/g, '');
        $(this).val(new Intl.NumberFormat('id-ID').format(value));
    });

    // Hitung total uang harian
    function hitungTotalUangHarian() {
        let perHari = parseInt($('#uang_harian_per_hari').val().replace(/[^\d]/g, '') || 0);
        let total = perHari * 2; // Selalu 2 hari
        
        $('#keterangan_uang_harian').html(
            '(Rp ' + new Intl.NumberFormat('id-ID').format(perHari) + 
            ' × 2 hari = Rp ' + 
            new Intl.NumberFormat('id-ID').format(total) + ')'
        );
        hitungTotal();
    }

    // Hitung uang diklat berdasarkan sisa hari
    function hitungUangDiklat() {
        let perHari = parseInt($('#uang_diklat_per_hari').val().replace(/[^\d]/g, '') || 0);
        let lamaPerjalanan = <?= $surat['lama_perjalanan'] ?>;
        let sisaHari = Math.max(0, lamaPerjalanan - 2); // Kurangi 2 hari dan pastikan tidak negatif
        let total = perHari * sisaHari;
        
        $('#keterangan_uang_diklat').html(
            '(Rp ' + new Intl.NumberFormat('id-ID').format(perHari) + 
            ' × ' + sisaHari + ' hari = Rp ' + 
            new Intl.NumberFormat('id-ID').format(total) + ')'
        );
        hitungTotal();
    }

    // Hitung total keseluruhan
    function hitungTotal() {
        let jenisSurat = '<?= $surat['jenis_surat'] ?>';
        let total = 0;

        // Hitung uang harian
        let uangHarianPerHari = parseInt($('#uang_harian_per_hari').val().replace(/[^\d]/g, '') || 0);
        let totalUangHarian = uangHarianPerHari * 2;

        // Hitung uang diklat
        let uangDiklatPerHari = parseInt($('#uang_diklat_per_hari').val().replace(/[^\d]/g, '') || 0);
        let lamaPerjalanan = <?= $surat['lama_perjalanan'] ?>;
        let totalUangDiklat = uangDiklatPerHari * Math.max(0, lamaPerjalanan - 2);

        total = totalUangHarian + totalUangDiklat;

        // Tambahkan biaya sesuai jenis surat
        if (jenisSurat === 'Dalam Daerah Dalam Provinsi') {
            let transport = parseInt($('input[name="transport_dalam"]').val()?.replace(/[^\d]/g, '') || 0);
            let akomodasi = parseInt($('input[name="akomodasi"]').val()?.replace(/[^\d]/g, '') || 0);
            total += transport + akomodasi;
        } 
        else if (jenisSurat === 'Luar Daerah Dalam Provinsi') {
            let transport = parseInt($('input[name="transport_dalam"]').val()?.replace(/[^\d]/g, '') || 0);
            let akomodasi = parseInt($('input[name="akomodasi"]').val()?.replace(/[^\d]/g, '') || 0);
            total += transport + akomodasi;
        }
        else if (jenisSurat === 'Luar Daerah Luar Provinsi') {
            let transportDalam = parseInt($('input[name="transport_dalam"]').val()?.replace(/[^\d]/g, '') || 0);
            let transportLuar = parseInt($('input[name="transport_luar"]').val()?.replace(/[^\d]/g, '') || 0);
            let pesawatBerangkat = parseInt($('input[name="pesawat_berangkat"]').val()?.replace(/[^\d]/g, '') || 0);
            let pesawatKembali = parseInt($('input[name="pesawat_kembali"]').val()?.replace(/[^\d]/g, '') || 0);
            total += transportDalam + transportLuar + pesawatBerangkat + pesawatKembali;
        }

        $('#total_biaya').val(new Intl.NumberFormat('id-ID').format(total));
    }

    // Panggil fungsi saat halaman dimuat
    $(document).ready(function() {
        hitungTotalUangHarian();
        hitungUangDiklat();
        
        // Tambahkan event listener untuk semua input yang mempengaruhi total
        $('.money').on('input', function() {
            hitungTotal();
        });

        // Form validation
        $('#formRincian').on('submit', function(e) {
            let isValid = true;
            $('.money').each(function() {
                let value = $(this).val().replace(/[^\d]/g, '');
                if (value === '' || value === '0') {
                    isValid = false;
                    $(this).addClass('is-invalid');
                } else {
                    $(this).removeClass('is-invalid');
                }
            });

            if (!isValid) {
                e.preventDefault();
                alert('Semua field biaya harus diisi dengan nilai lebih dari 0');
            }
        });
    });
    </script>
</body>
</html> 