<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

if (isset($_GET['id_surat'])) {
    $id_surat = $_GET['id_surat'];
} else if (isset($_GET['id'])) {
    $id_surat = $_GET['id'];
    
    // Query untuk mengambil data surat tugas
    $query_surat = "SELECT st.*, 
                           GROUP_CONCAT(p.nama_pegawai SEPARATOR ', ') as nama_pegawai_list
                    FROM surat_tugas st 
                    LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
                    LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai 
                    WHERE st.id_surat = ?
                    GROUP BY st.id_surat";
    
    $stmt = mysqli_prepare($conn, $query_surat);
    mysqli_stmt_bind_param($stmt, "i", $id_surat);
    mysqli_stmt_execute($stmt);
    $result_surat = mysqli_stmt_get_result($stmt);
    $surat = mysqli_fetch_assoc($result_surat);

    // Query untuk mengambil data rincian riil yang unik
    $query_rincian_riil = "SELECT DISTINCT uraian, jumlah, keterangan 
                          FROM rincian_biaya_riil 
                          WHERE id_surat = ? 
                          ORDER BY id_rincian_riil";
    $stmt = mysqli_prepare($conn, $query_rincian_riil);
    mysqli_stmt_bind_param($stmt, "i", $id_surat);
    mysqli_stmt_execute($stmt);
    $result_rincian_riil = mysqli_stmt_get_result($stmt);
    $rincian_riil = [];
    while ($row = mysqli_fetch_assoc($result_rincian_riil)) {
        $rincian_riil[] = $row;
    }
} else {
    $_SESSION['alert'] = [
        'type' => 'error',
        'message' => 'Data surat tugas tidak ditemukan.'
    ];
    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Tambah Rincian Biaya Riil - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .card {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .rincian-item {
            position: relative;
        }
        .hapus-item-btn {
            position: absolute;
            right: 0;
            top: 50%;
            transform: translateY(-50%);
            z-index: 1;
        }
        .form-label {
            margin-bottom: 0.2rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-section bg-primary text-white p-3 rounded mb-3">
            <h2 class="mb-0">Tambah Rincian Biaya Riil</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="../dashboard.php" class="text-white">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="index.php" class="text-white">Rincian Biaya</a></li>
                    <li class="breadcrumb-item"><a href="detail_rincian.php?id=<?= $id_surat ?>" class="text-white">Detail</a></li>
                    <li class="breadcrumb-item active text-white" aria-current="page">Tambah Rincian Riil</li>
                </ol>
            </nav>
        </div>

        <?php if (isset($surat)): ?>
        <!-- Informasi Surat -->
        <div class="card mb-4">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">Informasi Surat Tugas</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">No. Surat</th>
                                <td><?= htmlspecialchars($surat['no_surat']) ?></td>
                            </tr>
                            <tr>
                                <th>No. SPPD</th>
                                <td><?= htmlspecialchars($surat['no_sppd']) ?></td>
                            </tr>
                            <tr>
                                <th>Nama Pegawai</th>
                                <td><?= htmlspecialchars($surat['nama_pegawai_list']) ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Rincian Biaya Riil -->
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Form Rincian Biaya Riil</h5>
            </div>
            <div class="card-body">
                <form action="aksi_tambah_rincian_riil.php" method="POST">
                    <input type="hidden" name="id_surat" value="<?= $id_surat ?>">
                    
                    <div id="form-container">
                        <?php if (empty($rincian_riil)): ?>
                        <div class="rincian-item mb-4 border-bottom pb-3">
                            <div class="row align-items-end">
                                <div class="col-md-5">
                                    <label class="form-label">Uraian</label>
                                    <input type="text" class="form-control" name="uraian[]" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Jumlah</label>
                                    <div class="input-group">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" class="form-control money" name="jumlah[]" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Keterangan</label>
                                    <input type="text" class="form-control" name="keterangan[]">
                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                            <?php foreach ($rincian_riil as $index => $riil): ?>
                            <div class="rincian-item mb-4 border-bottom pb-3">
                                <?php if ($index > 0): ?>
                                <div class="hapus-item-btn">
                                    <button type="button" class="btn btn-danger btn-sm hapus-item">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                                <?php endif; ?>
                                <div class="row align-items-end">
                                    <div class="col-md-5">
                                        <label class="form-label">Uraian</label>
                                        <input type="text" class="form-control" name="uraian[]" value="<?= htmlspecialchars($riil['uraian']) ?>" required>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Jumlah</label>
                                        <div class="input-group">
                                            <span class="input-group-text">Rp</span>
                                            <input type="text" class="form-control money" name="jumlah[]" value="<?= number_format($riil['jumlah'], 0, ',', '.') ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Keterangan</label>
                                        <input type="text" class="form-control" name="keterangan[]" value="<?= htmlspecialchars($riil['keterangan']) ?>">
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                    <div class="mb-3">
                        <button type="button" class="btn btn-success" id="tambah-item">
                            <i class="bi bi-plus-circle"></i> Tambah Item
                        </button>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save"></i> Simpan
                        </button>
                        <a href="detail_rincian.php?id=<?= $id_surat ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
        <?php else: ?>
            <div class="alert alert-danger">
                Data surat tugas tidak ditemukan.
            </div>
        <?php endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            // Format input uang
            $(document).on('input', '.money', function() {
                let value = $(this).val().replace(/[^\d]/g, '');
                $(this).val(new Intl.NumberFormat('id-ID').format(value));
            });

            // Tambah form item
            $('#tambah-item').click(function() {
                let newItem = `
                    <div class="rincian-item mb-4 border-bottom pb-3">
                        <div class="hapus-item-btn">
                            <button type="button" class="btn btn-danger btn-sm hapus-item">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                        <div class="row align-items-end">
                            <div class="col-md-5">
                                <label class="form-label">Uraian</label>
                                <input type="text" class="form-control" name="uraian[]" required>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Jumlah</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" class="form-control money" name="jumlah[]" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Keterangan</label>
                                <input type="text" class="form-control" name="keterangan[]">
                            </div>
                        </div>
                    </div>
                `;
                $('#form-container').append(newItem);
            });

            // Hapus form item
            $(document).on('click', '.hapus-item', function() {
                $(this).closest('.rincian-item').remove();
            });
        });
    </script>
</body>
</html> 