<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

header('Content-Type: application/json');

// Debug: Log all POST data
error_log("POST Data received: " . print_r($_POST, true));

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $response = ['success' => false, 'message' => ''];
    
    try {
        // Fungsi untuk membersihkan format uang
        function cleanMoneyFormat($value) {
            $cleaned = (float) preg_replace('/[^0-9]/', '', $value);
            error_log("Cleaning money format: {$value} -> {$cleaned}");
            return $cleaned;
        }
        
        // Ambil data dari POST
        $id_rincian = $_POST['id_rincian'] ?? null;
        $id_surat = $_POST['id_surat'] ?? null;
        $id_pegawai = $_POST['id_pegawai'] ?? null;

        // Validasi data wajib
        if (!$id_rincian || !$id_surat || !$id_pegawai) {
            throw new Exception("Data ID tidak lengkap: id_rincian={$id_rincian}, id_surat={$id_surat}, id_pegawai={$id_pegawai}");
        }
        
        // Ambil dan bersihkan data biaya
        $uang_harian = cleanMoneyFormat($_POST['uang_harian']);
        $representatif_per_hari = cleanMoneyFormat($_POST['representatif']);
        $transport_dalam = cleanMoneyFormat($_POST['transport_dalam']);
        $transport_luar = cleanMoneyFormat($_POST['transport_luar']);
        $pesawat_berangkat = cleanMoneyFormat($_POST['pesawat_berangkat']);
        $pesawat_kembali = cleanMoneyFormat($_POST['pesawat_kembali']);
        $akomodasi = cleanMoneyFormat($_POST['akomodasi']);
        
        // Data jarak
        $jarak = isset($_POST['jarak']) ? (int)$_POST['jarak'] : 0;
        $biaya_jarak = isset($_POST['biaya_jarak']) ? cleanMoneyFormat($_POST['biaya_jarak']) : 0;

        error_log("Processed values:");
        error_log("uang_harian: {$uang_harian}");
        error_log("representatif_per_hari: {$representatif_per_hari}");
        error_log("transport_dalam: {$transport_dalam}");
        error_log("transport_luar: {$transport_luar}");
        error_log("pesawat_berangkat: {$pesawat_berangkat}");
        error_log("pesawat_kembali: {$pesawat_kembali}");
        error_log("akomodasi: {$akomodasi}");
        error_log("jarak: {$jarak}");
        error_log("biaya_jarak: {$biaya_jarak}");
        
        // Ambil lama perjalanan dari surat tugas
        $query_lama = "SELECT DATEDIFF(tanggal_kembali, tanggal_berangkat) + 1 as lama_perjalanan 
                      FROM surat_tugas WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query_lama);
        mysqli_stmt_bind_param($stmt, "i", $id_surat);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $row = mysqli_fetch_assoc($result);
        $lama_perjalanan = $row['lama_perjalanan'];
        
        error_log("Lama perjalanan: {$lama_perjalanan} hari");
        
        // Hitung total uang harian dan representatif
        $total_uang_harian = $uang_harian * $lama_perjalanan;
        $total_representatif = $representatif_per_hari * $lama_perjalanan;
        
        error_log("Total uang harian: {$total_uang_harian}");
        error_log("Total representatif: {$total_representatif}");
        
        // Hitung total biaya
        $total_biaya = $total_uang_harian + $total_representatif + 
                      $transport_dalam + $transport_luar + 
                      $pesawat_berangkat + $pesawat_kembali + 
                      $akomodasi + $biaya_jarak;
        
        error_log("Total biaya: {$total_biaya}");
        
        // Update data
        $query = "UPDATE rincian_bimtek_perorangan SET 
                  uang_harian_per_hari = ?,
                  total_uang_harian = ?,
                  representatif_per_hari = ?,
                  total_representatif = ?,
                  transport_dalam_provinsi = ?,
                  transport_luar_provinsi = ?,
                  biaya_pesawat_berangkat = ?,
                  biaya_pesawat_pulang = ?,
                  akomodasi = ?,
                  jarak = ?,
                  biaya_jarak = ?,
                  total_biaya = ?,
                  updated_at = CURRENT_TIMESTAMP
                  WHERE id_rincian_perorangan = ? AND id_surat = ? AND id_pegawai = ?";
                  
        error_log("Query: {$query}");
        
        $stmt = mysqli_prepare($conn, $query);
        if (!$stmt) {
            throw new Exception("Gagal mempersiapkan query: " . mysqli_error($conn));
        }
        
        $bind_result = mysqli_stmt_bind_param($stmt, "ddddddddddddiiii", 
            $uang_harian,
            $total_uang_harian,
            $representatif_per_hari,
            $total_representatif,
            $transport_dalam,
            $transport_luar,
            $pesawat_berangkat,
            $pesawat_kembali,
            $akomodasi,
            $jarak,
            $biaya_jarak,
            $total_biaya,
            $id_rincian,
            $id_surat,
            $id_pegawai
        );
        
        if (!$bind_result) {
            throw new Exception("Gagal binding parameter: " . mysqli_stmt_error($stmt));
        }
        
        if (mysqli_stmt_execute($stmt)) {
            $response['success'] = true;
            $response['message'] = 'Data berhasil diupdate';
            error_log("Query berhasil dieksekusi");
        } else {
            throw new Exception("Gagal mengupdate data: " . mysqli_stmt_error($stmt));
        }
        
    } catch (Exception $e) {
        error_log("Error caught: " . $e->getMessage());
        $response['message'] = $e->getMessage();
    }
    
    echo json_encode($response);
    exit;
}

// Jika bukan POST request
http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']); 