<?php
require_once '../config/database.php';
require_once '../config/config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

// Ambil data dari POST request
$id_surat = $_POST['id_surat'];
$id_pegawai_array = $_POST['id_pegawai'];
$uraian = $_POST['uraian'];
$jumlah = $_POST['jumlah_clean']; // Menggunakan jumlah yang sudah dibersihkan
$keterangan = isset($_POST['keterangan']) ? $_POST['keterangan'] : array_fill(0, count($uraian), '');

try {
    // Mulai transaksi
    $conn->begin_transaction();

    // Hapus rincian riil yang lama hanya untuk pegawai yang diedit
    $delete_query = "DELETE FROM rincian_biaya_riil WHERE id_surat = ? AND id_pegawai = ?";
    $stmt = $conn->prepare($delete_query);

    // Insert data baru untuk setiap pegawai
    $insert_query = "INSERT INTO rincian_biaya_riil (id_surat, id_pegawai, uraian, jumlah, keterangan) VALUES (?, ?, ?, ?, ?)";
    $insert_stmt = $conn->prepare($insert_query);

    // Untuk setiap pegawai, hapus data lama dan insert data baru
    foreach ($id_pegawai_array as $id_pegawai) {
        // Hapus data lama untuk pegawai ini
        $stmt->bind_param("ii", $id_surat, $id_pegawai);
        $stmt->execute();

        // Insert data baru untuk pegawai ini
        for ($i = 0; $i < count($uraian); $i++) {
            if (!empty($uraian[$i])) { // Hanya insert jika uraian tidak kosong
                $insert_stmt->bind_param("iisds", 
                    $id_surat, 
                    $id_pegawai, 
                    $uraian[$i], 
                    $jumlah[$i], 
                    $keterangan[$i]
                );
                if (!$insert_stmt->execute()) {
                    throw new Exception("Gagal menyimpan data untuk pegawai ID: " . $id_pegawai);
                }
            }
        }
    }

    // Commit transaksi
    $conn->commit();
    
    echo json_encode([
        'success' => true, 
        'message' => 'Data rincian riil berhasil disimpan untuk semua pegawai'
    ]);

} catch (Exception $e) {
    // Rollback jika terjadi error
    $conn->rollback();
    echo json_encode([
        'success' => false, 
        'message' => 'Terjadi kesalahan: ' . $e->getMessage()
    ]);
}

$conn->close();
?> 