<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Cek login
if (!isset($_SESSION['user_id'])) {
    die('Unauthorized');
}

// Validasi parameter
$file_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$file_id) {
    die('Invalid file ID');
}

// Ambil informasi file
$query = "SELECT cf.*, cm.info_id 
          FROM chat_files cf 
          JOIN chat_messages cm ON cm.id = cf.message_id 
          WHERE cf.id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $file_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$file = mysqli_fetch_assoc($result);

if (!$file) {
    die('File not found');
}

// Cek akses ke file
$query = "SELECT i.*, u.level as creator_level, u.bidang as creator_bidang 
          FROM informasi i 
          LEFT JOIN users u ON i.created_by = u.id 
          WHERE i.id_info = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $file['info_id']);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$info = mysqli_fetch_assoc($result);

if (!$info) {
    die('Access denied');
}

// Cek hak akses berdasarkan level dan bidang
$has_access = false;
if ($_SESSION['level'] === 'admin') {
    $has_access = true;
} elseif ($_SESSION['level'] === 'admin_sppd') {
    // Admin SPPD bisa mengakses file jika:
    // 1. Info dari admin
    // 2. Info dari bidangnya
    // 3. Info yang dia buat
    // 4. Info dari bandahara
    $has_access = 
        $info['creator_level'] === 'admin' ||
        $info['creator_bidang'] === $_SESSION['bidang'] ||
        $_SESSION['user_id'] === $info['created_by'] ||
        $info['creator_level'] === 'bandahara';
} elseif ($_SESSION['level'] === 'pimpinan') {
    // Pimpinan bisa mengakses file jika:
    // 1. Info dari admin
    // 2. Info dari bidangnya
    // 3. Info yang dia buat sendiri
    // 4. Info dari bandahara
    $has_access = 
        $info['creator_level'] === 'admin' ||
        $info['creator_bidang'] === $_SESSION['bidang'] ||
        $_SESSION['user_id'] === $info['created_by'] ||
        $info['creator_level'] === 'bandahara';
} else {
    // Pengguna lain bisa mengakses file jika:
    // 1. Informasi dari bidang mereka
    // 2. Mereka adalah pembuat informasi
    // 3. Informasi dari bandahara
    $has_access = 
        $_SESSION['bidang'] === $info['creator_bidang'] ||
        $_SESSION['user_id'] === $info['created_by'] ||
        $info['creator_level'] === 'bandahara';
}

if (!$has_access) {
    die('Access denied');
}

// Path file
$file_path = '../assets/uploads/chat/' . $file['file_name'];
if (!file_exists($file_path)) {
    die('File not found on server');
}

// Set header untuk download
header('Content-Type: ' . $file['file_type']);
header('Content-Disposition: attachment; filename="' . $file['original_name'] . '"');
header('Content-Length: ' . $file['file_size']);
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Output file
readfile($file_path); 