<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Set header untuk response JSON
header('Content-Type: application/json');

// Cek login
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Ambil parameter
$info_id = isset($_GET['info_id']) ? (int)$_GET['info_id'] : 0;
$last_id = isset($_GET['last_id']) ? (int)$_GET['last_id'] : 0;

// Validasi info_id
if (empty($info_id)) {
    echo json_encode(['success' => false, 'message' => 'Invalid information ID']);
    exit();
}

// Query untuk mengambil pesan
$query = "
    SELECT 
        m.id,
        m.message,
        m.created_at,
        u.username,
        u.nama_lengkap,
        m.user_id = ? as is_sender
    FROM 
        chat_messages m
        JOIN users u ON m.user_id = u.id
    WHERE 
        m.info_id = ?
        " . ($last_id > 0 ? "AND m.id > ?" : "") . "
    ORDER BY 
        m.created_at ASC
";

$stmt = mysqli_prepare($conn, $query);

if ($last_id > 0) {
    mysqli_stmt_bind_param($stmt, "iii", $_SESSION['user_id'], $info_id, $last_id);
} else {
    mysqli_stmt_bind_param($stmt, "ii", $_SESSION['user_id'], $info_id);
}

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$messages = [];
while ($row = mysqli_fetch_assoc($result)) {
    $messages[] = [
        'id' => $row['id'],
        'message' => $row['message'],
        'user_name' => $row['nama_lengkap'] ?: $row['username'],
        'time' => date('H:i', strtotime($row['created_at'])),
        'is_sender' => (bool)$row['is_sender']
    ];
}

echo json_encode([
    'success' => true,
    'messages' => $messages
]); 