<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Cek login
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

// Ambil parameter
$info_id = isset($_GET['info_id']) ? (int)$_GET['info_id'] : 0;
$last_id = isset($_GET['last_id']) ? (int)$_GET['last_id'] : 0;

// Query untuk mengambil pesan baru
$query = "SELECT c.id, c.message, c.message_type, c.created_at, c.user_id,
          u.username, u.nama_lengkap, u.foto,
          cf.id as file_id, cf.file_name, cf.original_name, cf.file_type, cf.file_size 
          FROM chat_messages c
          LEFT JOIN users u ON c.user_id = u.id
          LEFT JOIN chat_files cf ON c.id = cf.message_id
          WHERE c.info_id = ? 
          AND c.id > ?
          ORDER BY c.created_at ASC";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "ii", $info_id, $last_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$messages = [];
while ($row = mysqli_fetch_assoc($result)) {
    // Skip pesan dari pengirim yang sama jika bukan pesan sendiri
    if ($row['user_id'] != $_SESSION['user_id']) {
        $message = [
            'id' => $row['id'],
            'message' => $row['message'],
            'message_type' => $row['message_type'],
            'user_name' => $row['nama_lengkap'] ?: $row['username'],
            'user_photo' => $row['foto'],
            'time' => date('H:i', strtotime($row['created_at'])),
            'is_sender' => false
        ];

        // Tambahkan informasi file jika ini adalah pesan file
        if ($row['message_type'] === 'file' && !empty($row['file_id'])) {
            $message['file'] = [
                'id' => $row['file_id'],
                'file_name' => $row['file_name'],
                'original_name' => $row['original_name'],
                'type' => $row['file_type'],
                'size' => $row['file_size']
            ];
        }

        $messages[] = $message;
    }
}

// Return response
header('Content-Type: application/json');
echo json_encode(['messages' => $messages]);

// Tutup koneksi
mysqli_close($conn); 