<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Set header untuk response JSON
header('Content-Type: application/json');

// Cek login
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Cek method request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

// Ambil data dari request
$info_id = isset($_POST['info_id']) ? (int)$_POST['info_id'] : 0;
$message = isset($_POST['message']) ? trim($_POST['message']) : '';
$user_id = $_SESSION['user_id'];

// Validasi data
if (empty($info_id) || empty($message)) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

// Cek apakah informasi masih ada
$query_check = "SELECT id_info FROM informasi WHERE id_info = ?";
$stmt = mysqli_prepare($conn, $query_check);
mysqli_stmt_bind_param($stmt, "i", $info_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (mysqli_num_rows($result) === 0) {
    echo json_encode(['success' => false, 'message' => 'Information not found']);
    exit();
}

// Cek duplikasi pesan dalam 5 detik terakhir
$query_duplicate = "SELECT COUNT(*) as count FROM chat_messages 
                   WHERE info_id = ? 
                   AND user_id = ? 
                   AND message = ? 
                   AND created_at >= NOW() - INTERVAL 5 SECOND";
$stmt = mysqli_prepare($conn, $query_duplicate);
mysqli_stmt_bind_param($stmt, "iis", $info_id, $user_id, $message);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$duplicate = mysqli_fetch_assoc($result);

if ($duplicate['count'] > 0) {
    echo json_encode(['success' => false, 'message' => 'Duplicate message detected']);
    exit();
}

// Simpan pesan
$query_insert = "INSERT INTO chat_messages (info_id, user_id, message, message_type) VALUES (?, ?, ?, 'text')";
$stmt = mysqli_prepare($conn, $query_insert);
mysqli_stmt_bind_param($stmt, "iis", $info_id, $user_id, $message);

if (mysqli_stmt_execute($stmt)) {
    $message_id = mysqli_insert_id($conn); // Ambil ID pesan yang baru dibuat
    
    // Ambil data user untuk response
    $query_user = "SELECT username, nama_lengkap, foto FROM users WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query_user);
    mysqli_stmt_bind_param($stmt, "i", $user_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $user = mysqli_fetch_assoc($result);
    
    echo json_encode([
        'success' => true,
        'message_id' => $message_id,
        'message' => $message,
        'message_type' => 'text',
        'user_name' => $user['nama_lengkap'] ?: $user['username'],
        'user_photo' => $user['foto'],
        'time' => date('H:i'),
        'is_sender' => true
    ]);
} else {
    $error = mysqli_error($conn);
    error_log("Error saving message: " . $error);
    echo json_encode([
        'success' => false, 
        'message' => 'Failed to save message',
        'error' => $error
    ]);
}

// Tutup koneksi
mysqli_close($conn); 