<?php
session_start();
require_once 'config/config.php';

header('Content-Type: application/json');

if (empty($_POST['username'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Username tidak ditemukan'
    ]);
    exit;
}

$username = htmlspecialchars(trim($_POST['username']));

// Cek status dan OTP user
$stmt = $conn->prepare("SELECT status, otp FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User tidak ditemukan'
    ]);
    exit;
}

$user = $result->fetch_assoc();

// Jika status sudah approved, kirim OTP
if ($user['status'] === 'active') {
    echo json_encode([
        'status' => 'approved',
        'otp' => $user['otp']
    ]);
} else {
    echo json_encode([
        'status' => 'pending'
    ]);
}

$stmt->close();
$conn->close();
?> 