<?php
// Definisikan BASE_URL sesuai dengan instalasi di server Anda
define('BASE_URL', 'https://sppdsytem.my.id/sppd');

// Root path
define('ROOT_PATH', $_SERVER['DOCUMENT_ROOT'] . '/sppd');

// Start session jika belum dimulai
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'sppdsyte_admin');
define('DB_PASS', 'a,Z#?TLwOYW0');
define('DB_NAME', 'sppdsyte_db_instansi');

// Create connection
$conn = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// Fungsi untuk mengecek koneksi
function check_connection($conn) {
    if (!$conn || !mysqli_ping($conn)) {
        global $db_host, $db_user, $db_pass, $db_name;
        $conn = mysqli_connect($db_host, $db_user, $db_pass, $db_name);
        if (!$conn) {
            die("Koneksi database gagal: " . mysqli_connect_error());
        }
    }
    return $conn;
}

// Set charset to utf8
mysqli_set_charset($conn, "utf8");

// Fungsi untuk mencegah SQL injection
function sanitize($conn, $str) {
    return mysqli_real_escape_string($conn, $str);
}

// Fungsi untuk cek active menu
function isActive($page) {
    $current_page = basename($_SERVER['PHP_SELF']);
    $current_dir = basename(dirname($_SERVER['PHP_SELF']));
    
    return ($page === $current_page || $page === $current_dir) ? 'active' : '';
}

// Set timezone
date_default_timezone_set('Asia/Makassar');

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Role definitions
define('ROLE_ADMIN', 'admin');
define('ROLE_PIMPINAN', 'pimpinan');
define('ROLE_ADMIN_SPPD', 'admin_sppd');

// Function to check if user has access to a specific module
function hasAccess($module, $level) {
    $access_rights = [
        'admin' => [
            'dashboard' => true,
            'informasi' => true,
            'pegawai' => true,
            'pejabat' => true,
            'surat_tugas' => true,
            'rincian_biaya' => true,
            'rincian_biaya_per_pegawai' => true,
            'cetak_sppd' => true,
            'laporan_perjalanan' => true,
            'upload_berkas' => true,
            'profil' => true,
            'verifikasi_user' => true
        ],
        'pimpinan' => [
            'dashboard' => true,
            'informasi' => true,
            'pegawai' => true,
            'pejabat' => true,
            'surat_tugas' => true,
            'rincian_biaya_per_pegawai' => true,
            'laporan_perjalanan' => true,
            'upload_berkas' => true,
            'profil' => true
        ],
        'admin_sppd' => [
            'dashboard' => true,
            'pegawai' => true,
            'pejabat' => true,
            'surat_tugas' => true,
            'rincian_biaya' => true,
            'cetak_sppd' => true,
            'laporan_perjalanan' => true,
            'upload_berkas' => true,
            'profil' => true
        ]
    ];
    
    return isset($access_rights[$level][$module]) && $access_rights[$level][$module] === true;
}

// Function to check authentication
function checkAuth() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: " . BASE_URL . "/login.php");
        exit();
    }
}

// Function to check module access
function checkModuleAccess($module) {
    if (!isset($_SESSION['level']) || !hasAccess($module, $_SESSION['level'])) {
        header("Location: " . BASE_URL . "/403.php");
        exit();
    }
}

// Function to generate secure random string
function generateRandomString($length = 10) {
    return bin2hex(random_bytes($length));
}

// Function to log activity
function logActivity($user_id, $activity, $module) {
    global $conn;
    $query = "INSERT INTO activity_logs (user_id, activity, module, ip_address) VALUES (?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $query);
    $ip = $_SERVER['REMOTE_ADDR'];
    mysqli_stmt_bind_param($stmt, "isss", $user_id, $activity, $module, $ip);
    mysqli_stmt_execute($stmt);
}

// Get all settings
$query_settings = "SELECT * FROM pengaturan";
$result_settings = mysqli_query($conn, $query_settings);
$settings = [];

while ($row = mysqli_fetch_assoc($result_settings)) {
    $settings[$row['kode']] = $row['nilai'];
}

// Check maintenance mode
if (isset($settings['maintenance_mode']) && $settings['maintenance_mode'] === '1') {
    // Allow access for admin
    if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
        // Check if not already on maintenance page
        $current_page = basename($_SERVER['PHP_SELF']);
        if ($current_page !== 'maintenance.php' && $current_page !== 'login.php') {
            header("Location: /sppd/maintenance.php");
            exit();
        }
    }
}
?> 