<?php
// Include config file
require_once 'config.php';

// Fungsi sanitize global
if (!function_exists('sanitize')) {
    function sanitize($conn, $str) {
        return mysqli_real_escape_string($conn, trim($str));
    }
}

// Fungsi untuk menampilkan error
function showError($message) {
    return "
        <div class='alert alert-danger' role='alert'>
            <i class='bi bi-exclamation-triangle-fill me-2'></i>
            {$message}
        </div>
    ";
}

// Fungsi untuk menampilkan success
function showSuccess($message) {
    return "
        <div class='alert alert-success' role='alert'>
            <i class='bi bi-check-circle-fill me-2'></i>
            {$message}
        </div>
    ";
}

// Fungsi untuk format tanggal Indonesia
function formatTanggal($date) {
    $bulan = array(
        1 => 'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
    );

    $split = explode('-', $date);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Fungsi untuk format rupiah
function formatRupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Fungsi untuk cek login
function checkLogin() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit();
    }
}

// Fungsi untuk cek level akses
function checkLevel($allowed_levels) {
    if (!in_array($_SESSION['level'], $allowed_levels)) {
        header("Location: 403.php");
        exit();
    }
}
?> 