<?php
session_start();
require_once 'config/database.php';
require_once 'config/config.php';

// Cek login dengan pengecekan yang lebih detail
if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Pastikan koneksi database masih aktif
if (!$conn) {
    die("Koneksi database terputus");
}

// Mengambil statistik
$query_pegawai = "SELECT COUNT(*) as total_pegawai FROM pegawai";
$query_surat = "SELECT COUNT(*) as total_surat FROM surat_tugas";
$query_laporan = "SELECT COUNT(*) as total_laporan FROM laporan";

$total_pegawai = $conn->query($query_pegawai)->fetch_assoc()['total_pegawai'];
$total_surat = $conn->query($query_surat)->fetch_assoc()['total_surat'];
$total_laporan = $conn->query($query_laporan)->fetch_assoc()['total_laporan'];

// Inisialisasi variabel untuk pagination
$rows_per_page = isset($_GET['rows']) ? (int)$_GET['rows'] : 10; // Default 10 rows
$page = isset($_GET['stat_page']) ? (int)$_GET['stat_page'] : 1;
$offset = ($page - 1) * $rows_per_page;

// Query untuk total data
$total_query = "SELECT COUNT(DISTINCT jabatan) as total FROM pegawai";
$total_result = mysqli_query($conn, $total_query);
$total_rows = mysqli_fetch_assoc($total_result)['total'];
$total_pages = ceil($total_rows / $rows_per_page);

// Query untuk mengambil data jumlah SPPD per bulan dan total nominal dari rincian biaya per pegawai
$query_sppd = "SELECT 
    MONTH(st.tanggal_surat) as bulan,
    COUNT(DISTINCT st.id_surat) as jumlah_sppd,
    SUM(COALESCE(rbp.total_biaya, 0)) as total_nominal
FROM surat_tugas st
LEFT JOIN users u ON st.created_by = u.id
LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
WHERE YEAR(st.tanggal_surat) = YEAR(CURRENT_DATE)";

// Add bidang filter for admin_sppd and pimpinan
if (($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') && !empty($user_bidang)) {
    $query_sppd .= " AND u.bidang = ?";
}

$query_sppd .= " GROUP BY MONTH(st.tanggal_surat)
ORDER BY MONTH(st.tanggal_surat)";

// Execute query with bidang filter if needed
if (($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') && !empty($user_bidang)) {
    $stmt = mysqli_prepare($conn, $query_sppd);
    mysqli_stmt_bind_param($stmt, "s", $user_bidang);
    mysqli_stmt_execute($stmt);
    $result_sppd = mysqli_stmt_get_result($stmt);
} else {
    $result_sppd = mysqli_query($conn, $query_sppd);
}

$bulan_array = array();
$jumlah_sppd = array();
$total_nominal = array();
$nama_bulan = array(
    1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
    'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
);

// Inisialisasi array dengan nilai 0 untuk semua bulan
for ($i = 1; $i <= 12; $i++) {
    $bulan_array[$i-1] = $nama_bulan[$i];
    $jumlah_sppd[$i-1] = 0;
    $total_nominal[$i-1] = 0;
}

while ($row = mysqli_fetch_assoc($result_sppd)) {
    $index = $row['bulan'] - 1;
    $jumlah_sppd[$index] = intval($row['jumlah_sppd']);
    $total_nominal[$index] = floatval($row['total_nominal']);
}

// Near the Aktivitas Terbaru section, update the card header:
// Add these variables at the top of the file with other PHP variables
$aktivitas_per_page = isset($_GET['aktivitas_rows']) ? (int)$_GET['aktivitas_rows'] : 5;

// Get user's bidang if admin_sppd or pimpinan
$user_bidang = '';
if ($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') {
    $user_id = $_SESSION['user_id'];
    $stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
        mysqli_stmt_close($stmt);
    }
}

// Update the query to include jenis_surat instead of tujuan and filter by bidang
$query_aktivitas = "
    SELECT 
        st.no_sppd,
        st.tanggal_surat,
        st.maksud,
        CASE 
            WHEN st.jenis_surat = 'SPPD' THEN 'Surat Perjalanan Dinas'
            WHEN st.jenis_surat = 'SPT' THEN 'Surat Perintah Tugas'
            ELSE st.jenis_surat
        END as jenis_surat,
        COALESCE(u.nama_lengkap, u.username, 'Admin') as pembuat
    FROM surat_tugas st
    LEFT JOIN users u ON st.created_by = u.id
    WHERE st.created_by IS NOT NULL";

// Add bidang filter for admin_sppd and pimpinan
if (($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') && !empty($user_bidang)) {
    $query_aktivitas .= " AND u.bidang = ?";
    $query_aktivitas .= " ORDER BY st.tanggal_surat DESC LIMIT 3";
    
    $stmt = mysqli_prepare($conn, $query_aktivitas);
    mysqli_stmt_bind_param($stmt, "s", $user_bidang);
} else {
    $query_aktivitas .= " ORDER BY st.tanggal_surat DESC LIMIT 3";
    $stmt = mysqli_prepare($conn, $query_aktivitas);
}

mysqli_stmt_execute($stmt);
$result_aktivitas = mysqli_stmt_get_result($stmt);

// Query untuk mengambil informasi aktif
$query_info = "SELECT i.*, u.username, u.nama_lengkap, u.level, u.bidang,
               (SELECT COUNT(*) FROM chat_messages WHERE info_id = i.id_info) as chat_count 
               FROM informasi i 
               LEFT JOIN users u ON i.created_by = u.id 
               WHERE i.status = 'aktif' AND i.created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";


// Tambahkan filter berdasarkan level dan bidang
if ($_SESSION['level'] === 'admin_sppd') {
    // Admin SPPD bisa melihat:
    // 1. Info dari admin
    // 2. Info dari bandahara
    // 3. Info dari pimpinan yang sama bidangnya
    $query_info .= " AND (
        u.level = 'admin' 
        OR u.level = 'bandahara'
        OR (u.level = 'pimpinan' AND u.bidang = ?)
    )
    ORDER BY i.created_at DESC";
    
    $stmt = mysqli_prepare($conn, $query_info);
    mysqli_stmt_bind_param($stmt, "s", $_SESSION['bidang']);
    mysqli_stmt_execute($stmt);
    $result_info = mysqli_stmt_get_result($stmt);
} elseif ($_SESSION['level'] === 'pimpinan') {
    // Pimpinan bisa melihat:
    // 1. Info dari admin
    // 2. Info dari bidangnya
    // 3. Info yang dia buat sendiri
    // 4. Info dari bandahara
    $query_info .= " AND (
        u.level = 'admin' 
        OR u.bidang = ? 
        OR i.created_by = ? 
        OR u.level = 'bandahara'
    )
    ORDER BY i.created_at DESC";
    
    $stmt = mysqli_prepare($conn, $query_info);
    mysqli_stmt_bind_param($stmt, "si", $_SESSION['bidang'], $_SESSION['user_id']);
    mysqli_stmt_execute($stmt);
    $result_info = mysqli_stmt_get_result($stmt);
} elseif ($_SESSION['level'] !== 'admin') {
    // User biasa bisa melihat:
    // 1. Info dari admin
    // 2. Info dari bidangnya
    // 3. Info dari bandahara
    $query_info .= " AND (
        u.level = 'admin' 
        OR u.bidang = ? 
        OR u.level = 'bandahara'
    )
    ORDER BY i.created_at DESC";
    
    $stmt = mysqli_prepare($conn, $query_info);
    mysqli_stmt_bind_param($stmt, "s", $_SESSION['bidang']);
    mysqli_stmt_execute($stmt);
    $result_info = mysqli_stmt_get_result($stmt);
} else {
    // Admin bisa melihat semua informasi
    $query_info .= " ORDER BY i.created_at DESC";
    $result_info = mysqli_query($conn, $query_info);
}

?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard SPPD</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/pemkab.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/pemkab.png">
    
    <!-- Existing links -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.highcharts.com/highcharts-3d.js"></script>
    <script src="https://code.highcharts.com/modules/exporting.js"></script>
    <script src="https://code.highcharts.com/modules/export-data.js"></script>
    <style>
    :root {
        --sidebar-width: 280px;
        --sidebar-mini-width: 70px;
    }

    body {
        margin: 0;
        padding: 0;
        min-height: 100vh;
        background-image: url('assets/img/peta1.png') !important;
        background-size: cover !important;
        background-position: center !important;
        background-repeat: no-repeat !important;
        background-attachment: fixed !important;
        padding-left: 0 !important;
        position: relative;
        z-index: 0;
    }

    /* Main Layout Structure */
    .wrapper {
        display: flex;
        min-height: 100vh;
        width: 100%;
        position: relative;
        background: transparent !important;
    }

    /* Sidebar Wrapper */
    .sidebar-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        height: 100vh;
        width: var(--sidebar-width);
        z-index: 1000;
        transition: all 0.3s ease;
    }

    .sidebar-wrapper.collapsed {
        width: var(--sidebar-mini-width);
    }

    /* Main Content Area */
    .main-content {
        position: relative;
        margin-left: var(--sidebar-width);
        transition: all 0.3s ease;
        width: calc(100% - var(--sidebar-width));
        min-height: 100vh;
        background: transparent !important;
    }

    .main-content.expanded {
        margin-left: var(--sidebar-mini-width);
        width: calc(100% - var(--sidebar-mini-width));
    }

    /* Container Modifications */
    .container {
        max-width: 100% !important;
        padding: 2rem;
        margin: 0;
        transition: all 0.3s ease;
    }

    /* Card Adjustments */
    .card {
        margin-bottom: 1.5rem;
        width: 100%;
        transition: all 0.3s ease;
    }

    /* Chart container adjustments */
    .chart-container {
        width: 100% !important;
        transition: all 0.3s ease;
    }

    #sppd_chart,
    #nominal_chart {
        width: 100% !important;
        height: 400px !important;
        transition: all 0.3s ease;
    }

    /* Row and Column Adjustments */
    .row {
        width: 100%;
        margin: 0;
        transition: all 0.3s ease;
    }

    .col-md-4,
    .col-md-6,
    .col-md-8,
    .col-xl-6 {
        padding: 0.5rem;
        transition: all 0.3s ease;
    }

    /* Mobile Responsiveness */
    @media (max-width: 768px) {
        /* Sidebar adjustments */
        .sidebar-wrapper {
            width: 0;
            transform: translateX(-100%);
        }
        
        .sidebar-wrapper.show {
            width: 250px;
            transform: translateX(0);
        }

        /* Main content adjustments */
        .main-content {
            margin-left: 0 !important;
            width: 100% !important;
            padding: 1rem;
        }

        /* Container and spacing */
        .container {
            padding: 1rem !important;
        }

        .row {
            margin: 0 -0.5rem;
        }

        .col-md-4, .col-md-6, .col-md-8, .col-xl-6 {
            padding: 0.5rem;
        }

        /* Card adjustments */
        .card {
            margin-bottom: 1rem;
        }

        /* Stat cards */
        .stat-card {
            min-height: auto;
            padding: 1rem;
        }

        .stat-card .icon {
            width: 35px;
            height: 35px;
            font-size: 1rem;
        }

        .stat-card .value {
            font-size: 1.5rem;
        }

        /* Charts */
        #sppd_chart, #nominal_chart {
            height: 300px !important;
        }

        /* Tables */
        .table-responsive {
            margin: 0;
            border-radius: 10px;
        }

        .table th, .table td {
            padding: 0.75rem;
            font-size: 0.9rem;
        }

        /* Activity cards */
        .aktivitas-card .list-group-item {
            padding: 1rem;
        }

        /* Info cards */
        .info-item {
            padding: 1rem;
        }

        .info-meta {
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        /* Buttons and controls */
        .btn {
            padding: 0.5rem 1rem;
            min-height: 44px;
        }

        .dropdown-menu {
            width: 100%;
            max-width: 300px;
        }
    }

    /* Small mobile devices */
    @media (max-width: 576px) {
        .container {
            padding: 0.75rem !important;
        }

        .stat-card {
            padding: 0.75rem;
        }

        .stat-card .value {
            font-size: 1.25rem;
        }

        .table th, .table td {
            padding: 0.5rem;
            font-size: 0.8rem;
        }

        #sppd_chart, #nominal_chart {
            height: 250px !important;
        }

        .btn {
            padding: 0.4rem 0.8rem;
            font-size: 0.9rem;
        }
    }

    /* Touch device optimizations */
    @media (hover: none) and (pointer: coarse) {
        .btn, .nav-link, .dropdown-item {
            min-height: 44px;
            display: flex;
            align-items: center;
        }

        input, select, textarea {
            font-size: 16px !important;
            min-height: 44px;
        }
    }

    /* iOS specific fixes */
    @supports (-webkit-touch-callout: none) {
        .main-content {
            padding-bottom: env(safe-area-inset-bottom);
        }
    }

    /* Dashboard Header Styling */
    .dashboard-header {
        background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
        border-radius: 15px;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    .dashboard-header h2 {
        color: white;
        font-size: 1.75rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .dashboard-header p {
        color: rgba(255, 255, 255, 0.8);
        font-size: 1rem;
        margin-bottom: 0;
    }

    /* Stat Cards Styling */
    .stat-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
        border: none;
        border-radius: 15px;
        padding: 1.5rem;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .stat-card.pegawai {
        background: linear-gradient(135deg, #6B73FF 0%, #000DFF 100%);
    }

    .stat-card.surat {
        background: linear-gradient(135deg, #FF6B6B 0%, #FF2525 100%);
    }

    .stat-card.laporan {
        background: linear-gradient(135deg, #36D1DC 0%, #5B86E5 100%);
    }

    .stat-card .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        margin-bottom: 1rem;
    }

    .stat-card .title {
        color: rgba(255, 255, 255, 0.9);
        font-size: 0.875rem;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 0.2rem;
    }

    .stat-card .value {
        font-size: 2.5rem;
        font-weight: 700;
        color: #ffffff;
        margin: 0;
        line-height: 1;
    }

    .stat-card .icon {
        color: #ffffff;
    }

    /* Chart Cards Styling */
    .card {
        border: none;
        border-radius: 15px;
        background: white;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        padding: 1.5rem;
    }

    .card-header h6 {
        color: white;
        font-weight: 600;
        margin: 0;
        font-size: 1.1rem;
    }

    .card-body {
        padding: 0 !important;
    }

    /* Table Styling */
    .table-responsive {
        background: white;
        border-radius: 15px;
        padding: 1rem;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .table {
        width: 100%;
        margin-bottom: 0;
    }

    .table thead th {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 1rem;
        font-weight: 600;
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    /* Column widths */
    .table th:nth-child(1),
    .table td:nth-child(1) {
        width: 80px;
        text-align: center;
    }

    .table th:nth-child(2),
    .table td:nth-child(2) {
        width: 35%;
    }

    .table th:nth-child(3),
    .table td:nth-child(3) {
        width: 20%;
        white-space: nowrap;
    }

    .table th:nth-child(4),
    .table td:nth-child(4) {
        width: 40%;
    }

    /* Progress bar container */
    .progress-container {
        display: flex;
        align-items: center;
        gap: 1rem;
        width: 100%;
    }

    .progress {
        height: 8px;
        border-radius: 4px;
        background-color: #e9ecef;
        overflow: hidden;
    }

    .progress-bar {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .progress-value {
        min-width: 45px;
        text-align: right;
        font-size: 0.875rem;
        color: #6b7280;
    }

    /* Card body padding adjustment */
    .card-body {
        padding: 0;
    }

    /* Responsive adjustments */
    @media (min-width: 1200px) {
        .table-responsive {
            overflow-x: hidden;
        }
        
        .table {
            table-layout: fixed;
        }
    }

    @media (max-width: 1199px) {
        .table {
            min-width: 800px;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
    }

    /* Activity Card Styling */
    .aktivitas-card {
        background: white;
        border-radius: 15px;
        overflow: hidden;
    }

    .aktivitas-card .list-group {
        counter-reset: activity-counter;
        padding: 0;
    }

    .list-group-item {
        padding: 1.25rem;
        border: none;
        border-bottom: 1px solid rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }

    .list-group-item::before {
        display: none; /* Hide the counter */
    }

    .list-group-item:hover {
        background: rgba(102, 126, 234, 0.05);
        transform: translateX(5px);
    }

    .aktivitas-header {
        display: flex;
        align-items: center;
        margin-bottom: 1rem;
    }

    .aktivitas-header i {
        width: 40px;
        height: 40px;
        border-radius: 12px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
        margin-right: 1rem;
    }

    .aktivitas-date {
        background: rgba(14, 165, 233, 0.1);
        color: #0ea5e9;
        padding: 0.5rem 1rem;
        border-radius: 20px;
        font-size: 0.875rem;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }

    /* Utility Buttons */
    .btn {
        border-radius: 10px;
        padding: 0.75rem 1.5rem;
        font-weight: 500;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-info {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        color: white;
    }

    .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    /* Dropdown Menu Styling */
    .dropdown-menu {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        padding: 0.75rem;
    }

    .dropdown-item {
        padding: 0.75rem 1rem;
        border-radius: 10px;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .dropdown-item:hover {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        transform: translateX(5px);
    }

    /* Animation for stat cards */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .stat-card {
        animation: fadeInUp 0.5s ease backwards;
    }

    .stat-card:nth-child(1) { animation-delay: 0.1s; }
    .stat-card:nth-child(2) { animation-delay: 0.2s; }
    .stat-card:nth-child(3) { animation-delay: 0.3s; }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .container {
            padding: 1rem;
        }

        .dashboard-header {
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            min-height: 90px;
            padding: 0.6rem 0.75rem;
        }

        .stat-card .icon {
            width: 30px;
            height: 30px;
            font-size: 0.9rem;
            margin-bottom: 0.25rem;
        }

        .stat-card .title {
            font-size: 0.7rem;
            margin-bottom: 0.15rem;
        }

        .stat-card .value {
            font-size: 1.75rem;
            margin-top: 0.1rem;
        }
    }

    /* Additional Mobile Optimizations */
    @media (max-width: 576px) {
        .card-header h5 {
            font-size: 0.9rem;
        }

        .form-label {
            font-size: 0.8rem;
        }

        .btn {
            font-size: 0.8rem;
            padding: 0.4rem 0.8rem;
        }

        .table td, .table th {
            padding: 0.4rem;
            font-size: 0.8rem;
        }

        .dropdown-item {
            padding: 0.5rem;
            font-size: 0.9rem;
        }

        /* Improve touch targets */
        .nav-link,
        .btn,
        .dropdown-item {
            min-height: 44px;
            display: flex;
            align-items: center;
        }

        /* Fix modal on mobile */
        .modal-dialog {
            margin: 0;
            max-width: none;
            height: 100%;
        }

        .modal-content {
            border-radius: 0;
            min-height: 100%;
        }
    }

    /* Fix for bottom nav bar on iOS */
    @supports (-webkit-touch-callout: none) {
        .container {
            padding-bottom: env(safe-area-inset-bottom);
        }
    }

    /* Activity Card Header Styling */
    .aktivitas-card .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 1.25rem;
        border: none;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .aktivitas-card .card-header .header-content {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .aktivitas-card .card-header .header-actions {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .aktivitas-card .form-select {
        background-color: rgba(255, 255, 255, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        color: white;
        font-size: 0.875rem;
        padding: 0.4rem 2rem 0.4rem 0.75rem;
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .aktivitas-card .form-select:hover {
        background-color: rgba(255, 255, 255, 0.15);
    }

    .aktivitas-card .form-select:focus {
        box-shadow: 0 0 0 2px rgba(255, 255, 255, 0.3);
        outline: none;
    }

    .aktivitas-card .form-select option {
        background: #fff;
        color: #1f2937;
    }

    .badge {
        padding: 0.5em 1em;
        font-weight: 500;
        font-size: 0.75rem;
        border-radius: 20px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        white-space: normal;
        text-align: center;
        line-height: 1.2;
    }

    .bg-primary {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    }

    .bg-success {
        background: linear-gradient(135deg,rgb(109, 215, 179) 0%, #059669 100%) !important;
    }

    /* Add flexbox to the main layout */
    .main-layout {
        display: flex;
    }

    /* Sidebar positioning */
    .sidebar-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        height: 100vh;
        z-index: 1000;
        transition: all 0.3s ease;
    }

    .sidebar-wrapper.collapsed {
        width: 70px;
    }

    /* Main content positioning */
    .main-content {
        position: relative;
        margin-left: var(--sidebar-width);
        transition: all 0.3s ease;
        width: calc(100% - var(--sidebar-width));
        min-height: 100vh;
        padding: 20px;
    }

    .main-content.expanded {
        margin-left: 70px;
        width: calc(100% - 70px);
    }

    /* Mobile responsiveness */
    @media (max-width: 768px) {
        .sidebar-wrapper {
            transform: translateX(-100%);
        }
        
        .sidebar-wrapper.collapsed {
            transform: translateX(0);
            width: 70px;
        }
        
        .main-content {
            margin-left: 0;
            width: 100%;
        }
        
        .main-content.expanded {
            margin-left: 70px;
            width: calc(100% - 70px);
        }
    }

    /* Container adjustments */
    .container {
        max-width: 100% !important;
        padding: 2rem;
        transition: all 0.3s ease;
    }

    /* Content wrapper adjustments */
    .content-wrapper {
        width: 100%;
        transition: all 0.3s ease;
    }

    /* Pagination Adjustments */
    .pagination-container {
        padding: 10px;
        background: #fff;
        border-top: 1px solid #e5e7eb;
    }

    /* Remove any fixed heights */
    .card.h-100 {
        height: auto !important;
    }

    /* Styling untuk tombol balas */
    .btn-outline-primary {
        border: 2px solid #0ea5e9;
        color: #0ea5e9;
        background: transparent;
        transition: all 0.3s ease;
    }

    .btn-outline-primary:hover {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        border-color: transparent;
        color: white;
        transform: translateY(-2px);
    }

    /* Animasi hover untuk card informasi */
    .list-group-item {
        transition: all 0.3s ease;
        border-left: 4px solid transparent;
    }

    .list-group-item:hover {
        background-color: rgba(14, 165, 233, 0.05);
        border-left: 4px solid #0ea5e9;
    }

    /* Styling untuk tooltip */
    .tooltip {
        font-size: 0.875rem;
    }

    .tooltip-inner {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    }

    .position-relative {
        position: relative !important;
    }
    .position-absolute {
        position: absolute !important;
    }
    .top-0 {
        top: 0 !important;
    }
    .start-100 {
        left: 100% !important;
    }
    .translate-middle {
        transform: translate(-50%, -50%) !important;
    }
    .rounded-pill {
        border-radius: 50rem !important;
    }
    .bg-danger {
        background-color: #dc3545 !important;
    }
    .badge {
        padding: 0.35em 0.65em;
        font-size: 0.75em;
        font-weight: 700;
        line-height: 1;
        color: #fff;
        text-align: center;
        white-space: nowrap;
        vertical-align: baseline;
    }

    /* Styling untuk list item informasi */
    .list-group-item {
        padding: 1.25rem;
        border: none;
        border-bottom: 1px solid #e2e8f0;
        transition: all 0.3s ease;
    }

    /* Styling untuk container flex yang menampung nomor dan konten */
    .info-container {
        display: flex;
        align-items: flex-start;
        gap: 1rem;
    }

    /* Styling untuk bagian nomor */
    .info-number {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        min-width: 80px;
    }

    .info-number .badge {
        width: 28px;
        height: 28px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 0.875rem;
        padding: 0;
    }

    /* Styling untuk konten informasi */
    .info-content {
        flex: 1;
    }

    .info-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 0.5rem;
    }

    .info-title {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin: 0;
    }

    .info-actions {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    /* Styling untuk badge prioritas */
    .priority-badge {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
        margin-right: 0.5rem;
    }

    /* Styling untuk meta informasi */
    .info-meta {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 0.5rem;
        font-size: 0.875rem;
    }

    /* Informasi Penting Styling */
    .info-card {
        border: none;
        border-radius: 20px;
        box-shadow: 0 5px 25px rgba(0,0,0,0.05);
        background: white;
        overflow: hidden;
    }

    .info-card .card-header {
        background: linear-gradient(135deg, #FF6B6B 0%, #FFB88C 100%);
        padding: 1.5rem;
        border: none;
    }

    .header-icon {
        width: 48px;
        height: 48px;
        background: rgba(255,255,255,0.2);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
    }

    .header-icon i {
        font-size: 1.5rem;
        color: white;
    }

    .header-text h5 {
        color: white;
        font-weight: 600;
    }

    .header-text small {
        color: rgba(255,255,255,0.8);
    }

    .info-list {
        padding: 0;
    }

    .info-item {
        padding: 1.5rem;
        border-bottom: 1px solid rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }

    .info-item:last-child {
        border-bottom: none;
    }

    .info-item:hover {
        background: rgba(0,0,0,0.01);
        transform: translateX(5px);
    }

    .info-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 1rem;
    }

    .info-meta {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .info-number {
        width: 28px;
        height: 28px;
        background: linear-gradient(135deg, #FF6B6B 0%, #FFB88C 100%);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 0.875rem;
    }

    .priority-badge {
        background: linear-gradient(135deg, #FF4B4B 0%, #FF7676 100%);
        color: white;
        padding: 0.35rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .time-badge {
        background: rgba(0,0,0,0.05);
        color: #666;
        padding: 0.35rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .chat-button {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        color: white;
        width: 36px;
        height: 36px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .chat-button:hover {
        transform: translateY(-2px);
        color: white;
    }

    .chat-counter {
        position: absolute;
        top: -8px;
        right: -8px;
        background: #FF4B4B;
        color: white;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .info-body {
        margin-bottom: 1rem;
    }

    .info-title {
        color: #1f2937;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .info-text {
        color: #4b5563;
        margin-bottom: 0;
        line-height: 1.6;
    }

    .info-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 0.875rem;
        color: #6b7280;
    }

    .author, .date {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    /* Hover effects */
    .info-item {
        position: relative;
        overflow: hidden;
    }

    .info-item::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        width: 4px;
        background: linear-gradient(135deg, #FF6B6B 0%, #FFB88C 100%);
        opacity: 0;
        transition: all 0.3s ease;
    }

    .info-item:hover::before {
        opacity: 1;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .info-meta {
            flex-wrap: wrap;
        }
        
        .info-header {
            flex-direction: column;
            gap: 1rem;
        }
        
        .info-actions {
            align-self: flex-end;
        }
        
        .info-footer {
            flex-direction: column;
            gap: 0.5rem;
        }
    }

    /* Mobile Responsiveness Adjustments */
    @media (max-width: 576px) {
        .container {
            padding: 1rem !important;
        }

        /* Header adjustments */
        .dashboard-header h2 {
            font-size: 1.25rem;
        }

        /* Stat cards adjustments */
        .stat-card {
            padding: 0.75rem;
        }

        .stat-card .value {
            font-size: 1.5rem;
        }

        .stat-card .title {
            font-size: 0.7rem;
        }

        /* Chart container adjustments */
        #sppd_chart,
        #nominal_chart {
            height: 300px !important;
        }

        /* Table adjustments */
        .table th, 
        .table td {
            font-size: 0.8rem;
            padding: 0.5rem;
        }

        /* Card header adjustments */
        .card-header {
            padding: 0.75rem 1rem;
        }

        .card-header h6 {
            font-size: 0.9rem;
        }

        /* Info card adjustments */
        .info-item {
            padding: 1rem;
        }

        .info-meta {
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .info-number {
            min-width: 60px;
        }

        .priority-badge,
        .time-badge {
            font-size: 0.7rem;
            padding: 0.25rem 0.5rem;
        }

        .info-title {
            font-size: 0.9rem;
        }

        .info-text {
            font-size: 0.8rem;
        }

        /* Activity card adjustments */
        .aktivitas-card .list-group-item {
            padding: 0.75rem;
        }

        .aktivitas-header i {
            width: 30px;
            height: 30px;
            font-size: 1rem;
        }

        .aktivitas-date {
            font-size: 0.75rem;
            padding: 0.25rem 0.75rem;
        }

        /* Button adjustments */
        .btn {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        /* Dropdown adjustments */
        .dropdown-menu {
            min-width: 200px;
        }

        .dropdown-item {
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
        }
    }

    @media (max-width: 768px) {
        .row {
            margin: 0 -0.5rem;
        }

        .col-md-4,
        .col-md-6,
        .col-md-8,
        .col-xl-6 {
            padding: 0 0.5rem;
        }

        /* Improve chart responsiveness */
        .chart-container {
            margin-bottom: 1rem;
        }

        /* Adjust grid layout */
        .row > [class*='col-'] {
            margin-bottom: 1rem;
        }

        /* Improve table scrolling */
        .table-responsive {
            margin: 0;
            padding: 0.5rem;
        }

        /* Adjust utility modal */
        .modal-dialog {
            margin: 0.5rem;
        }

        .modal-body {
            padding: 1rem;
        }

        /* Improve form elements touch targets */
        input[type="text"],
        select,
        textarea,
        .form-control,
        .form-select {
            font-size: 16px !important; /* Prevent iOS zoom */
            height: auto;
            padding: 0.5rem;
        }
    }

    /* Fix iOS specific issues */
    @supports (-webkit-touch-callout: none) {
        /* Prevent rubber-band scrolling */
        html, body {
            position: fixed;
            width: 100%;
            height: 100%;
            overflow: auto;
            -webkit-overflow-scrolling: touch;
        }

        /* Fix input zoom */
        input[type="text"],
        select,
        textarea {
            font-size: 16px !important;
        }

        /* Fix bottom safe area */
        .container {
            padding-bottom: calc(1rem + env(safe-area-inset-bottom));
        }
    }

    /* Improve touch targets */
    @media (hover: none) and (pointer: coarse) {
        .btn,
        .nav-link,
        .dropdown-item {
            min-height: 44px;
            display: flex;
            align-items: center;
        }

        /* Improve table interaction on touch devices */
        .table th,
        .table td {
            min-height: 44px;
        }
    }

    /* Mobile Menu Styles */
    .mobile-menu-toggle {
        position: fixed;
        top: 1rem;
        right: 1rem;
        z-index: 1040;
        background: white;
        border: none;
        border-radius: 50%;
        width: 45px;
        height: 45px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        display: none;
    }

    .mobile-menu {
        position: fixed;
        top: 0;
        left: -100%;
        width: 280px;
        height: 100vh;
        background: white;
        z-index: 1050;
        transition: 0.3s ease-in-out;
        overflow-y: auto;
        box-shadow: 2px 0 5px rgba(0,0,0,0.1);
    }

    .mobile-menu.active {
        left: 0;
    }

    .mobile-menu-header {
        padding: 1rem;
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        color: white;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .mobile-menu-close {
        background: none;
        border: none;
        color: white;
        font-size: 1.5rem;
        padding: 0.5rem;
    }

    .mobile-menu-body {
        padding: 1rem 0;
    }

    .mobile-menu-item {
        display: flex;
        align-items: center;
        padding: 0.75rem 1rem;
        color: #1f2937;
        text-decoration: none;
        transition: 0.2s;
        gap: 0.75rem;
    }

    .mobile-menu-item:hover,
    .mobile-menu-item:focus {
        background-color: rgba(14, 165, 233, 0.1);
        color: #0ea5e9;
    }

    .mobile-menu-item i {
        font-size: 1.25rem;
        width: 24px;
        text-align: center;
    }

    .menu-label {
        padding: 0.5rem 1rem;
        font-size: 0.75rem;
        font-weight: 600;
        color: #6b7280;
        margin-top: 1rem;
    }

    .mobile-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        z-index: 1045;
        display: none;
    }

    .mobile-overlay.active {
        display: block;
    }

    @media (max-width: 768px) {
        .mobile-menu-toggle {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .sidebar-wrapper {
            display: none;
        }

        .main-content {
            margin-left: 0 !important;
            padding-top: 4rem;
        }
    }

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Source+Code+Pro:wght@400;500&display=swap');
        
        .kode-kegiatan {
            font-family: 'Source Code Pro', monospace;
            font-size: 0.95rem;
            color: #1f2937;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .kode-kegiatan i {
            color: #6366f1;
            font-size: 1rem;
        }
    </style>
    </style>
</head>
<body>
    <div class="wrapper">
        <?php 
        include 'includes/sidebar.php';
        include 'includes/mobile_menu.php'; 
        ?>
        <div class="main-content" id="mainContent">
            <div class="container py-4">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h2 class="mb-0 dashboard-title">Dashboard <Br><small>Informasi, Overview Statistik dan Aktivitas Terbaru</small></h2>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="dropdown d-inline-block me-2">
                            <button class="btn btn-info rounded-3 d-inline-flex align-items-center dropdown-toggle" type="button" id="gameMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-controller me-2"></i>
                                <span>Mini Games</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="gameMenuButton">
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/catch_star.php">
                                        <i class="bi bi-star me-2"></i>
                                        <span>Catch Star</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/memory_card.php">
                                        <i class="bi bi-grid-3x3-gap me-2"></i>
                                        <span>Memory Card</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/tetris.php">
                                        <i class="bi bi-square-fill me-2"></i>
                                        <span>Tetris Game</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/brick_game.php">
                                        <i class="bi bi-grid-1x2 me-2"></i>
                                        <span>Brick Game</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/snake_dots.php">
                                        <i class="bi bi-dot me-2"></i>
                                        <span>Snake Dots</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/flappy_bird.php">
                                        <i class="bi bi-emoji-smile me-2"></i>
                                        <span>Flappy Bird</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item d-flex align-items-center" href="game/rubik.php">
                                        <i class="bi bi-cube me-2"></i>
                                        <span>Rubik's Cube</span>
                                    </a>
                                </li>
                            </ul>
                        </div>

                    </div>
                </div>

                <!-- Informasi Section -->
                <?php if (mysqli_num_rows($result_info) > 0): ?>
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card info-card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <div class="header-icon">
                                        <i class="bi bi-megaphone-fill"></i>
                                    </div>
                                    <div class="header-text">
                                        <h5 class="mb-0">Informasi Penting</h5>
                                        <small class="text-muted">Pengumuman dan informasi terbaru</small>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <div class="info-list">
                                    <?php 
                                    $no = 1;
                                    while ($info = mysqli_fetch_assoc($result_info)): 
                                        $timeAgo = time() - strtotime($info['created_at']);
                                        $timeString = '';
                                        
                                        if ($timeAgo < 60) {
                                            $timeString = 'Baru saja';
                                        } elseif ($timeAgo < 3600) {
                                            $timeString = floor($timeAgo/60) . ' menit yang lalu';
                                        } elseif ($timeAgo < 86400) {
                                            $timeString = floor($timeAgo/3600) . ' jam yang lalu';
                                        } else {
                                            $timeString = floor($timeAgo/86400) . ' hari yang lalu';
                                        }
                                    ?>
                                        <div class="info-item">
                                            <div class="info-content">
                                                <div class="info-header">
                                                    <div class="info-meta">
                                                        <div class="info-number"><?= $no++ ?></div>
                                                        <?php if ($info['prioritas'] == 'tinggi'): ?>
                                                            <span class="priority-badge">
                                                                <i class="bi bi-exclamation-triangle-fill"></i>
                                                                Prioritas Tinggi
                                                            </span>
                                                        <?php endif; ?>
                                                        <span class="time-badge">
                                                            <i class="bi bi-clock"></i>
                                                            <?= $timeString ?>
                                                        </span>
                                                    </div>
                                                    <div class="info-actions">
                                                        <a href="chat/room.php?info_id=<?= $info['id_info'] ?>" 
                                                           class="chat-button" 
                                                           data-bs-toggle="tooltip" 
                                                           title="Balas di Room Chat">
                                                            <i class="bi bi-chat-dots-fill"></i>
                                                            <?php if (isset($info['chat_count']) && $info['chat_count'] > 0): ?>
                                                                <span class="chat-counter"><?= $info['chat_count'] ?></span>
                                                            <?php endif; ?>
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="info-body">
                                                    <h6 class="info-title"><?= htmlspecialchars($info['judul']) ?></h6>
                                                    <p class="info-text"><?= nl2br(htmlspecialchars($info['isi'])) ?></p>
                                                </div>
                                                <div class="info-footer">
                                                    <div class="author">
                                                        <i class="bi bi-person-circle"></i>
                                                        <?= htmlspecialchars($info['nama_lengkap'] ?: $info['username']) ?>
                                                    </div>
                                                    <div class="date">
                                                        <i class="bi bi-calendar3"></i>
                                                        <?= date('d/m/Y H:i', strtotime($info['created_at'])) ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Statistik Cards -->
                <div class="row g-3 mb-4">
                    <div class="col-md-4">
                        <div class="stat-card pegawai">
                            <div class="icon">
                                <i class="bi bi-people"></i>
                            </div>
                            <div class="title">Total Pegawai</div>
                            <div class="value"><?= number_format($total_pegawai) ?></div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-card surat">
                            <div class="icon">
                                <i class="bi bi-file-text"></i>
                            </div>
                            <div class="title">Surat Tugas</div>
                            <div class="value"><?= number_format($total_surat) ?></div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-card laporan">
                            <div class="icon">
                                <i class="bi bi-journal-check"></i>
                            </div>
                            <div class="title">Laporan</div>
                            <div class="value"><?= number_format($total_laporan) ?></div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 mb-4">
                        <div class="card">
                            <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                                <h6 class="m-0 font-weight-bold text-white">Total Nominal SPPD per Bulan</h6>
                            </div>
                            <div class="card-body">
                                <div id="nominal_chart" style="height: 400px"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Anggaran SPPD -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                                <h5 class="card-title mb-0 text-white">
                                    <i class="bi bi-cash-stack me-2"></i>Total Anggaran SPPD Per Sub Kegiatan
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th style="width: 40%">Kode Sub Kegiatan</th>
                                                <th style="width: 35%">Bidang</th>
                                                <th style="width: 25%">Total Anggaran Terealisasi</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                            <?php
                                            // Query untuk mendapatkan total anggaran per sub kegiatan dengan bidang
                                            $query_anggaran = "SELECT 
                                                COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan) as kode_kegiatan,
                                                u.bidang,
                                                SUM(COALESCE(rbp.total_biaya, 0)) as total_anggaran
                                            FROM surat_tugas st
                                            LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
                                            LEFT JOIN users u ON st.created_by = u.id
                                            WHERE YEAR(st.tanggal_surat) = YEAR(CURRENT_DATE)
                                                AND (st.no_sub_kegiatan IS NOT NULL OR rbp.no_sub_kegiatan IS NOT NULL)
                                            GROUP BY COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan), u.bidang
                                            ORDER BY u.bidang ASC, total_anggaran DESC";

                                            $result_anggaran = mysqli_query($conn, $query_anggaran);
                                            $total_keseluruhan = 0;
                                            $current_bidang = '';
                                            $total_per_bidang = 0;

                                            while ($row = mysqli_fetch_assoc($result_anggaran)):
                                                $total_keseluruhan += $row['total_anggaran'];
                                                
                                                // Jika berganti bidang, tampilkan total bidang sebelumnya dan reset total
                                                if ($current_bidang != '' && $current_bidang != $row['bidang']) {
                                                    ?>
                                                    <tr class="table-info">
                                                        <td colspan="2"></td>
                                                        <td class="text-end fw-bold">
                                                            Rp <?= number_format($total_per_bidang, 0, ',', '.') ?>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                    $total_per_bidang = 0;
                                                }
                                                
                                                // Tambahkan header bidang jika berganti bidang
                                                if ($current_bidang != $row['bidang']):
                                                    $current_bidang = $row['bidang'];
                                            ?>
                                                <tr class="table-secondary">
                                                    <td colspan="3" class="fw-bold text-center">
                                                        <i class="bi bi-diagram-2"></i> 
                                                        <?= htmlspecialchars($current_bidang ?: 'Bidang Tidak Tersedia') ?>
                                                    </td>
                                                </tr>
                                            <?php endif; 
                                                $total_per_bidang += $row['total_anggaran'];
                                            ?>
                                            <tr>
                                                <td class="kode-kegiatan">
                                                    <i class="bi bi-code-square"></i>
                                                    <?= htmlspecialchars($row['kode_kegiatan']) ?>
                                                </td>
                                                <td></td>
                                                <td class="text-end">Rp <?= number_format($row['total_anggaran'], 0, ',', '.') ?></td>
                                            </tr>
                                            <?php endwhile; 
                                            
                                            // Tampilkan total untuk bidang terakhir
                                            if ($current_bidang != '') {
                                                ?>
                                                <tr class="table-info">
                                                    <td colspan="2"></td>
                                                    <td class="text-end fw-bold">
                                                        Rp <?= number_format($total_per_bidang, 0, ',', '.') ?>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                            ?>

                                            <?php if (mysqli_num_rows($result_anggaran) == 0): ?>
                                            <tr>
                                                <td colspan="3" class="text-center py-4">
                                                    <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                                    Belum ada data anggaran SPPD untuk tahun <?= date('Y') ?>
                                                </td>
                                            </tr>
                                            <?php else: ?>
                                            <tr class="table-light fw-bold">
                                                <td>Total Keseluruhan</td>
                                                <td></td>
                                                <td class="text-end">Rp <?= number_format($total_keseluruhan, 0, ',', '.') ?></td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <!-- Grafik -->
                    <div class="col-md-8 mb-4">
                        <div class="card h-100">
                            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                                <div class="header-content">
                                    <i class="bi bi-bar-chart-line me-2"></i>
                                    <h6 class="card-title mb-0">Statistik SPPD</h6>
                                </div>
                                <div class="header-actions">
                                    <button class="btn btn-sm btn-light" onclick="refreshStats()">
                                        <i class="bi bi-arrow-clockwise"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <?php
                                // Query untuk statistik SPPD
                                $query_stats = "
                                    SELECT 
                                        jenis_surat,
                                        COUNT(*) as jumlah,
                                        CASE 
                                            WHEN jenis_surat = 'Dalam Daerah Dalam Provinsi' THEN 'bg-success'
                                            WHEN jenis_surat = 'Luar Daerah Dalam Provinsi' THEN 'bg-warning'
                                            WHEN jenis_surat = 'Luar Daerah Luar Provinsi' THEN 'bg-info'
                                            ELSE 'bg-secondary'
                                        END as badge_class,
                                        CASE 
                                            WHEN jenis_surat = 'Dalam Daerah Dalam Provinsi' THEN 'bi-geo-alt'
                                            WHEN jenis_surat = 'Luar Daerah Dalam Provinsi' THEN 'bi-geo'
                                            WHEN jenis_surat = 'Luar Daerah Luar Provinsi' THEN 'bi-globe'
                                            ELSE 'bi-file-text'
                                        END as icon_class
                                    FROM surat_tugas 
                                    WHERE YEAR(tanggal_surat) = YEAR(CURRENT_DATE)
                                    GROUP BY jenis_surat
                                    ORDER BY jumlah DESC";

                                $result_stats = mysqli_query($conn, $query_stats);
                                
                                // Query untuk total SPPD tahun ini
                                $query_total = "SELECT COUNT(*) as total FROM surat_tugas WHERE YEAR(tanggal_surat) = YEAR(CURRENT_DATE)";
                                $total_result = mysqli_query($conn, $query_total);
                                $total_sppd = mysqli_fetch_assoc($total_result)['total'];
                                ?>

                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th style="width: 50px">No</th>
                                                <th>Jenis SPPD</th>
                                                <th style="width: 100px">Jumlah</th>
                                                <th style="width: 200px">Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $no = 1;
                                            while ($row = mysqli_fetch_assoc($result_stats)): 
                                                // Query untuk mendapatkan status SPPD
                                                $query_status = "
                                                    SELECT 
                                                        COUNT(CASE WHEN l.id_surat IS NOT NULL THEN 1 END) as selesai,
                                                        COUNT(CASE WHEN l.id_surat IS NULL THEN 1 END) as proses
                                                    FROM surat_tugas st
                                                    LEFT JOIN laporan l ON st.id_surat = l.id_surat
                                                    WHERE st.jenis_surat = ? 
                                                    AND YEAR(st.tanggal_surat) = YEAR(CURRENT_DATE)";
                                                
                                                $stmt = mysqli_prepare($conn, $query_status);
                                                mysqli_stmt_bind_param($stmt, "s", $row['jenis_surat']);
                                                mysqli_stmt_execute($stmt);
                                                $status_result = mysqli_stmt_get_result($stmt);
                                                $status_data = mysqli_fetch_assoc($status_result);
                                            ?>
                                            <tr>
                                                <td class="text-center"><?= $no++ ?></td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="badge <?= $row['badge_class'] ?> me-2">
                                                            <i class="bi <?= $row['icon_class'] ?>"></i>
                                                        </span>
                                                        <?= $row['jenis_surat'] ?>
                                                    </div>
                                                </td>
                                                <td class="text-center"><?= number_format($row['jumlah']) ?></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="badge bg-success d-flex align-items-center gap-1">
                                                            <i class="bi bi-check-circle"></i>
                                                            <?= number_format($status_data['selesai']) ?> Selesai
                                                        </div>
                                                        <div class="badge bg-warning d-flex align-items-center gap-1">
                                                            <i class="bi bi-clock"></i>
                                                            <?= number_format($status_data['proses']) ?> Proses
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>

                                            <?php if (mysqli_num_rows($result_stats) == 0): ?>
                                            <tr>
                                                <td colspan="4" class="text-center py-4">
                                                    <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                                    Belum ada data SPPD untuk tahun <?= date('Y') ?>
                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                        <?php if (mysqli_num_rows($result_stats) > 0): ?>
                                        <tfoot>
                                            <tr class="table-light">
                                                <td colspan="2" class="fw-bold">Total SPPD Tahun <?= date('Y') ?></td>
                                                <td class="text-center fw-bold"><?= number_format($total_sppd) ?></td>
                                                <td>
                                                    <?php
                                                    // Query untuk total status
                                                    $query_total_status = "
                                                        SELECT 
                                                            COUNT(CASE WHEN l.id_surat IS NOT NULL THEN 1 END) as total_selesai,
                                                            COUNT(CASE WHEN l.id_surat IS NULL THEN 1 END) as total_proses
                                                        FROM surat_tugas st
                                                        LEFT JOIN laporan l ON st.id_surat = l.id_surat
                                                        WHERE YEAR(st.tanggal_surat) = YEAR(CURRENT_DATE)";
                                                    
                                                    $total_status_result = mysqli_query($conn, $query_total_status);
                                                    $total_status = mysqli_fetch_assoc($total_status_result);
                                                    ?>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="badge bg-success d-flex align-items-center gap-1">
                                                            <i class="bi bi-check-circle"></i>
                                                            <?= number_format($total_status['total_selesai']) ?> Total
                                                        </div>
                                                        <div class="badge bg-warning d-flex align-items-center gap-1">
                                                            <i class="bi bi-clock"></i>
                                                            <?= number_format($total_status['total_proses']) ?> Total
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                        <?php endif; ?>
                                    </table>
                                </div>

                                <?php
                                // Query untuk statistik SPPD Bimtek
                                $query_bimtek = "
                                    SELECT 
                                        COUNT(*) as total_bimtek,
                                        SUM(CASE WHEN is_bimtek = 1 THEN 1 ELSE 0 END) as jumlah_bimtek,
                                        SUM(CASE WHEN is_bimtek = 0 THEN 1 ELSE 0 END) as jumlah_non_bimtek
                                    FROM surat_tugas 
                                    WHERE YEAR(tanggal_surat) = YEAR(CURRENT_DATE)";
                                
                                $result_bimtek = mysqli_query($conn, $query_bimtek);
                                $bimtek_stats = mysqli_fetch_assoc($result_bimtek);
                                
                                if ($bimtek_stats['total_bimtek'] > 0):
                                ?>
                                <div class="mt-4">
                                    <h6 class="mb-3">SPPD Bimtek & Non-Bimtek</h6>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <div class="card bg-primary bg-opacity-10 border-0">
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center">
                                                        <div class="rounded-3 bg-primary bg-opacity-10 p-3 me-3">
                                                            <i class="bi bi-mortarboard text-primary fs-4"></i>
                                                        </div>
                                                        <div>
                                                            <h3 class="mb-0"><?= number_format($bimtek_stats['jumlah_bimtek']) ?></h3>
                                                            <span class="text-muted">SPPD Bimtek</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="card bg-success bg-opacity-10 border-0">
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center">
                                                        <div class="rounded-3 bg-success bg-opacity-10 p-3 me-3">
                                                            <i class="bi bi-file-text text-success fs-4"></i>
                                                        </div>
                                                        <div>
                                                            <h3 class="mb-0"><?= number_format($bimtek_stats['jumlah_non_bimtek']) ?></h3>
                                                            <span class="text-muted">SPPD Regular</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Aktivitas Terbaru -->
                    <div class="col-md-4 mb-4">
                        <div class="card aktivitas-card h-100">
                            <div class="card-header">
                                <div class="header-content">
                                    <i class="bi bi-clock-history"></i>
                                    <h5 class="card-title mb-0">Aktivitas Terbaru</h5>
                                </div>
                                <div class="header-actions">
                                    <button class="btn btn-sm btn-light" onclick="refreshAktivitas()">
                                        <i class="bi bi-arrow-clockwise"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <div class="list-group list-group-flush">
                                    <?php
                                    if ($result_aktivitas && mysqli_num_rows($result_aktivitas) > 0) {
                                        while ($aktivitas = mysqli_fetch_assoc($result_aktivitas)) {
                                            ?>
                                            <div class="list-group-item">
                                                <div class="aktivitas-header">
                                                    <i class="bi bi-file-text"></i>
                                                    <h6>SPPD: <?= htmlspecialchars($aktivitas['no_sppd'] ?: '-') ?></h6>
                                                </div>
                                                <div class="aktivitas-content">
                                                    <div class="aktivitas-info">
                                                        <strong>Maksud:</strong>
                                                        <span class="ms-2"><?= htmlspecialchars($aktivitas['maksud']) ?></span>
                                                    </div>
                                                    <div class="aktivitas-info">
                                                        <strong>Jenis Surat:</strong>
                                                        <span class="ms-2">
                                                            <?php 
                                                            $jenisSurat = htmlspecialchars($aktivitas['jenis_surat']);
                                                            $badgeClass = $jenisSurat == 'Surat Perjalanan Dinas' ? 'badge bg-primary' : 'badge bg-success';
                                                            echo "<span class='$badgeClass'>$jenisSurat</span>";
                                                            ?>
                                                        </span>
                                                    </div>
                                                    <div class="aktivitas-info">
                                                        <strong>Dibuat:</strong>
                                                        <span class="ms-2"><?= htmlspecialchars($aktivitas['pembuat']) ?></span>
                                                    </div>
                                                    <div class="mt-2">
                                                        <span class="aktivitas-date">
                                                            <i class="bi bi-calendar3 me-1"></i>
                                                            <?= date('d/m/Y', strtotime($aktivitas['tanggal_surat'])) ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    } else {
                                        ?>
                                        <div class="empty-state">
                                            <i class="bi bi-inbox"></i>
                                            <p class="mb-0">Belum ada surat tugas</p>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <!-- Modal Tambah Informasi -->
            <div class="modal fade" id="addInfoModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Tambah Informasi Baru</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form id="addInfoForm" action="actions/add_info.php" method="POST">
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label">Judul</label>
                                    <input type="text" class="form-control" name="judul" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Isi Informasi</label>
                                    <textarea class="form-control" name="isi" rows="3" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Prioritas</label>
                                    <select class="form-select" name="prioritas">
                                        <option value="normal">Normal</option>
                                        <option value="tinggi">Tinggi</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-primary">Simpan</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Modal Edit Informasi -->
            <div class="modal fade" id="editInfoModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Edit Informasi</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form id="editInfoForm" onsubmit="event.preventDefault(); editInfoSubmit();">
                            <div class="modal-body">
                                <input type="hidden" id="edit_id_info" name="id_info">
                                <div class="mb-3">
                                    <label class="form-label">Judul</label>
                                    <input type="text" class="form-control" id="edit_judul" name="judul" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Isi Informasi</label>
                                    <textarea class="form-control" id="edit_isi" name="isi" rows="3" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Prioritas</label>
                                    <select class="form-select" id="edit_prioritas" name="prioritas">
                                        <option value="normal">Normal</option>
                                        <option value="tinggi">Tinggi</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Modal Utility -->
            <div class="modal fade" id="utilityModal" tabindex="-1" aria-labelledby="utilityModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header bg-warning text-white">
                            <h5 class="modal-title" id="utilityModalLabel">
                                <i class="bi bi-tools me-2"></i>
                                Utility Tools
                            </h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="utilityForm">
                                <div class="row g-3">
                                    <!-- Backup Database -->
                                    <div class="col-md-6">
                                        <div class="card h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">
                                                    <i class="bi bi-database me-2"></i>
                                                    Backup Database
                                                </h5>
                                                <p class="card-text text-muted">Buat backup database sistem</p>
                                                <div class="d-grid">
                                                    <button type="button" class="btn btn-outline-primary" onclick="window.location.href='utility/backup_database.php'">
                                                        <i class="bi bi-download me-2"></i>
                                                        Backup Sekarang
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Log Aktivitas -->
                                    <div class="col-md-6">
                                        <div class="card h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">
                                                    <i class="bi bi-journal-text me-2"></i>
                                                    Log Aktivitas
                                                </h5>
                                                <p class="card-text text-muted">Lihat riwayat aktivitas sistem</p>
                                                <div class="d-grid">
                                                    <button type="button" class="btn btn-outline-info" onclick="window.location.href='utility/log_aktivitas.php'">
                                                        <i class="bi bi-eye me-2"></i>
                                                        Lihat Log
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Pengaturan Sistem -->
                                    <div class="col-md-6">
                                        <div class="card h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">
                                                    <i class="bi bi-gear me-2"></i>
                                                    Pengaturan Sistem
                                                </h5>
                                                <p class="card-text text-muted">Konfigurasi pengaturan sistem</p>
                                                <div class="d-grid">
                                                    <button type="button" class="btn btn-outline-warning" onclick="window.location.href='utility/pengaturan.php'">
                                                        <i class="bi bi-sliders me-2"></i>
                                                        Pengaturan
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Export Data -->
                                    <div class="col-md-6">
                                        <div class="card h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">
                                                    <i class="bi bi-file-earmark-excel me-2"></i>
                                                    Export Data
                                                </h5>
                                                <p class="card-text text-muted">Export data ke format Excel</p>
                                                <div class="d-grid">
                                                    <button type="button" class="btn btn-outline-success" onclick="window.location.href='utility/export_data.php'">
                                                        <i class="bi bi-file-excel me-2"></i>
                                                        Export Data
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    function changeRowsPerPage(rows) {
        const newUrl = new URL(window.location.href);
        newUrl.searchParams.set('rows', rows);
        newUrl.searchParams.set('stat_page', 1); // Reset ke halaman 1
        window.location.href = newUrl.toString();
    }

    function refreshStats() {
        location.reload();
    }

    // Set nilai dropdown sesuai parameter URL
    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        const rows = urlParams.get('rows') || 10;
        document.getElementById('rows_per_page').value = rows;
    });

    // Grafik Total Nominal
    Highcharts.chart('nominal_chart', {
        chart: {
            type: 'spline',
            backgroundColor: '#f8fafc'
        },
        title: {
            text: null
        },
        xAxis: {
            categories: <?php echo json_encode($bulan_array); ?>,
            labels: {
                style: {
                    color: '#64748b',
                    fontSize: '12px'
                }
            },
            lineColor: '#e2e8f0',
            tickColor: '#e2e8f0'
        },
        yAxis: {
            title: {
                text: 'Total Nominal (Rp)',
                style: {
                    color: '#64748b'
                }
            },
            labels: {
                formatter: function() {
                    return 'Rp ' + Highcharts.numberFormat(this.value, 0, ',', '.');
                },
                style: {
                    color: '#64748b'
                }
            },
            gridLineColor: '#e2e8f0'
        },
        tooltip: {
            headerFormat: '<span style="font-size: 10px">{point.key}</span><br/>',
            pointFormat: '<b>Rp {point.y:,.0f}</b>',
            backgroundColor: '#ffffff',
            borderColor: '#e2e8f0',
            borderRadius: 8,
            style: {
                color: '#1e293b'
            }
        },
        series: [{
            name: 'Total Nominal',
            data: <?php echo json_encode($total_nominal); ?>,
            color: '#3b82f6',
            lineWidth: 3,
            marker: {
                enabled: true,
                radius: 6,
                symbol: 'circle'
            },
            showInLegend: false
        }],
        credits: {
            enabled: false
        },
        plotOptions: {
            spline: {
                marker: {
                    enabled: true
                }
            }
        }
    });

    // Tambahkan interaktivitas rotasi 3D
    (function(H) {
        function dragStart(eStart) {
            eStart = charts[0].pointer.normalize(eStart);

            var posX = eStart.chartX,
                posY = eStart.chartY,
                alpha = charts[0].options.chart.options3d.alpha,
                beta = charts[0].options.chart.options3d.beta,
                sensitivity = 5;

            function drag(e) {
                e = charts[0].pointer.normalize(e);

                charts.forEach(function(chart) {
                    chart.update({
                        chart: {
                            options3d: {
                                alpha: alpha + (e.chartY - posY) / sensitivity,
                                beta: beta + (posX - e.chartX) / sensitivity
                            }
                        }
                    }, undefined, undefined, false);
                });
            }

            H.addEvent(document, 'mousemove', drag);
            H.addEvent(document, 'touchmove', drag);

            H.addEvent(document, 'mouseup', function() {
                H.removeEvent(document, 'mousemove', drag);
            });
            H.addEvent(document, 'touchend', function() {
                H.removeEvent(document, 'touchmove', drag);
            });
        }

        var charts = [
            Highcharts.charts[Highcharts.charts.length - 2],
            Highcharts.charts[Highcharts.charts.length - 1]
        ];
        
        charts.forEach(function(chart) {
            H.addEvent(chart.container, 'mousedown', dragStart);
            H.addEvent(chart.container, 'touchstart', dragStart);
        });
    })(Highcharts);

    function refreshAktivitas() {
        location.reload();
    }

    // Set nilai dropdown sesuai parameter URL
    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        const rows = urlParams.get('rows') || 10;
        document.getElementById('rows_per_page').value = rows;
    });

    function editInfo(id) {
        // Fetch info data
        fetch(`actions/get_info.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('edit_id_info').value = data.id_info;
                document.getElementById('edit_judul').value = data.judul;
                document.getElementById('edit_isi').value = data.isi;
                document.getElementById('edit_prioritas').value = data.prioritas;
                
                // Show modal
                new bootstrap.Modal(document.getElementById('editInfoModal')).show();
            });
    }

    function deleteInfo(id) {
        if (confirm('Apakah Anda yakin ingin menghapus informasi ini?')) {
            fetch(`actions/delete_info.php?id=${id}`, {
                method: 'POST'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Gagal menghapus informasi');
                }
            });
        }
    }

    // Handle edit form submission
    function editInfoSubmit() {
        const formData = new FormData(document.getElementById('editInfoForm'));
        
        fetch('actions/edit_info.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal mengubah informasi');
            }
        });
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Get elements
        const sidebarWrapper = document.querySelector('.sidebar-wrapper');  // Changed to .sidebar-wrapper
        const mainContent = document.getElementById('mainContent');
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        if (!sidebarWrapper || !mainContent || !sidebarToggle) {
            console.error('Required elements not found');
            return;
        }

        function updateLayout() {
            if (sidebarWrapper.classList.contains('collapsed')) {
                mainContent.classList.add('expanded');
                // Resize charts after sidebar toggle
                setTimeout(() => {
                    if (Highcharts.charts) {
                        Highcharts.charts.forEach(chart => {
                            if (chart) {
                                chart.reflow();
                            }
                        });
                    }
                }, 300);
            } else {
                mainContent.classList.remove('expanded');
                // Resize charts after sidebar toggle
                setTimeout(() => {
                    if (Highcharts.charts) {
                        Highcharts.charts.forEach(chart => {
                            if (chart) {
                                chart.reflow();
                            }
                        });
                    }
                }, 300);
            }
        }

        // Initial check
        updateLayout();

        // Toggle event
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            sidebarWrapper.classList.toggle('collapsed'); // Toggles collapsed class on sidebarWrapper
            updateLayout();
            localStorage.setItem('sidebarCollapsed', sidebarWrapper.classList.contains('collapsed'));
        });

        // Check saved state
        const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
        if (sidebarCollapsed) {
            sidebarWrapper.classList.add('collapsed');
            mainContent.classList.add('expanded');
        }

        // Handle window resize
        window.addEventListener('resize', function() {
            if (Highcharts.charts) {
                Highcharts.charts.forEach(chart => {
                    if (chart) {
                        chart.reflow();
                    }
                });
            }
        });
    });

    // Inisialisasi tooltip
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });
    });

    // Add this JavaScript at the end of the file
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
        const mobileMenu = document.querySelector('.mobile-menu');
        const mobileOverlay = document.querySelector('.mobile-overlay');
        const mobileMenuClose = document.querySelector('.mobile-menu-close');

        function toggleMobileMenu() {
            mobileMenu.classList.toggle('active');
            mobileOverlay.classList.toggle('active');
            document.body.style.overflow = mobileMenu.classList.contains('active') ? 'hidden' : '';
        }

        if(mobileMenuToggle) {
            mobileMenuToggle.addEventListener('click', toggleMobileMenu);
        }

        if(mobileMenuClose) {
            mobileMenuClose.addEventListener('click', toggleMobileMenu);
        }

        if(mobileOverlay) {
            mobileOverlay.addEventListener('click', toggleMobileMenu);
        }

        // Close menu on link click
        const mobileMenuItems = document.querySelectorAll('.mobile-menu-item');
        mobileMenuItems.forEach(item => {
            item.addEventListener('click', () => {
                toggleMobileMenu();
            });
        });
    });
    </script>
</body>
</html> 