<?php
session_start();
require_once 'config/config.php';

// Query untuk mengambil semua data rincian bimtek dengan tanggal
$query = "SELECT 
    rb.*,
    st.maksud,
    st.no_sppd,
    st.tanggal_berangkat,
    st.tanggal_kembali,
    p.nama_pegawai
FROM rincian_bimtek_perorangan rb
JOIN surat_tugas st ON rb.id_surat = st.id_surat
JOIN pegawai p ON rb.id_pegawai = p.id_pegawai
ORDER BY rb.id_surat, rb.id_pegawai";

$result = mysqli_query($conn, $query);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Debug Rincian Bimtek</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .debug-card {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
        }
        .warning {
            color: red;
            font-weight: bold;
        }
        .calculation {
            background-color: #f8f9fa;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
        }
        .total-section {
            background-color: #e9ecef;
            padding: 15px;
            margin-top: 20px;
            border-radius: 8px;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h2>Debug Rincian Biaya Bimtek</h2>
        
        <?php
        $current_surat = null;
        $total_all = 0;
        $surat_totals = array();
        
        while ($row = mysqli_fetch_assoc($result)) {
            if ($current_surat !== $row['id_surat']) {
                if ($current_surat !== null) {
                    // Tampilkan total per surat tugas
                    echo "<div class='total-section'>";
                    echo "<h5>Total Surat Tugas ID {$current_surat}: Rp " . 
                         number_format($surat_totals[$current_surat], 0, ',', '.') . "</h5>";
                    echo "</div><hr>";
                }
                $current_surat = $row['id_surat'];
                if (!isset($surat_totals[$current_surat])) {
                    $surat_totals[$current_surat] = 0;
                }
                
                echo "<div class='debug-card'>";
                echo "<h4>Surat Tugas ID: {$row['id_surat']}</h4>";
                echo "<p>No SPPD: {$row['no_sppd']}</p>";
                echo "<p>Maksud: {$row['maksud']}</p>";
                
                // Hitung jumlah hari
                $tgl_berangkat = new DateTime($row['tanggal_berangkat']);
                $tgl_kembali = new DateTime($row['tanggal_kembali']);
                $interval = $tgl_berangkat->diff($tgl_kembali);
                $jumlah_hari = $interval->days + 1;
                
                echo "<p>Tanggal: {$row['tanggal_berangkat']} s/d {$row['tanggal_kembali']} ({$jumlah_hari} hari)</p>";
            }
            
            // Hitung total manual dengan detail
            $total_uang_harian = $row['uang_harian_per_hari'] * $jumlah_hari;
            $total_uang_diklat = $row['uang_diklat_per_hari'] * $jumlah_hari;
            $total_representatif = $row['representatif_per_hari'] * $jumlah_hari;
            
            $manual_total = 
                $total_uang_harian +
                $total_uang_diklat +
                $total_representatif +
                $row['transport_dalam_provinsi'] +
                $row['transport_luar_provinsi'] +
                $row['biaya_pesawat_berangkat'] +
                $row['biaya_pesawat_pulang'] +
                $row['akomodasi'];
            
            echo "<div class='calculation'>";
            echo "<h5>Pegawai: {$row['nama_pegawai']}</h5>";
            echo "<div class='detail-row'>";
            echo "<span>Uang Harian:</span>";
            echo "<span>" . number_format($row['uang_harian_per_hari'], 0, ',', '.') . 
                 " × {$jumlah_hari} hari = " . number_format($total_uang_harian, 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Uang Diklat:</span>";
            echo "<span>" . number_format($row['uang_diklat_per_hari'], 0, ',', '.') . 
                 " × {$jumlah_hari} hari = " . number_format($total_uang_diklat, 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Representatif:</span>";
            echo "<span>" . number_format($row['representatif_per_hari'], 0, ',', '.') . 
                 " × {$jumlah_hari} hari = " . number_format($total_representatif, 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Transport Dalam:</span>";
            echo "<span>Rp " . number_format($row['transport_dalam_provinsi'], 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Transport Luar:</span>";
            echo "<span>Rp " . number_format($row['transport_luar_provinsi'], 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Pesawat Berangkat:</span>";
            echo "<span>Rp " . number_format($row['biaya_pesawat_berangkat'], 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Pesawat Pulang:</span>";
            echo "<span>Rp " . number_format($row['biaya_pesawat_pulang'], 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<span>Akomodasi:</span>";
            echo "<span>Rp " . number_format($row['akomodasi'], 0, ',', '.') . "</span>";
            echo "</div>";
            
            echo "<hr>";
            echo "<div class='detail-row'>";
            echo "<strong>Total di Database:</strong>";
            echo "<strong>Rp " . number_format($row['total_biaya'], 0, ',', '.') . "</strong>";
            echo "</div>";
            
            echo "<div class='detail-row'>";
            echo "<strong>Total Manual:</strong>";
            echo "<strong>Rp " . number_format($manual_total, 0, ',', '.') . "</strong>";
            echo "</div>";
            
            if ($manual_total != $row['total_biaya']) {
                echo "<p class='warning'>PERBEDAAN TOTAL: Rp " . 
                     number_format($row['total_biaya'] - $manual_total, 0, ',', '.') . "</p>";
            }
            
            echo "</div>";
            
            $total_all += $row['total_biaya'];
            $surat_totals[$current_surat] += $row['total_biaya'];
        }
        
        // Tampilkan total surat tugas terakhir
        if ($current_surat !== null) {
            echo "<div class='total-section'>";
            echo "<h5>Total Surat Tugas ID {$current_surat}: Rp " . 
                 number_format($surat_totals[$current_surat], 0, ',', '.') . "</h5>";
            echo "</div>";
        }
        
        echo "<hr>";
        echo "<div class='total-section'>";
        echo "<h3>Total Keseluruhan: Rp " . number_format($total_all, 0, ',', '.') . "</h3>";
        echo "<p>Detail per Surat Tugas:</p>";
        foreach ($surat_totals as $id_surat => $total) {
            echo "<div class='detail-row'>";
            echo "<span>Surat Tugas ID {$id_surat}:</span>";
            echo "<span>Rp " . number_format($total, 0, ',', '.') . "</span>";
            echo "</div>";
        }
        echo "</div>";
        ?>
        
    </div>
</body>
</html> 