<?php
session_start();
require_once 'config/config.php';

// Cek apakah user adalah admin
if (!isset($_SESSION['level']) || $_SESSION['level'] !== 'admin') {
    header("Location: dashboard.php");
    exit();
}

if (isset($_GET['file'])) {
    $filename = $_GET['file'];
    $filepath = "backups/" . $filename;
    
    // Validasi nama file
    if (preg_match('/^backup_[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}\.(sql|xlsx)$/', $filename)) {
        // Cek apakah file ada
        if (file_exists($filepath)) {
            // Coba hapus file
            if (unlink($filepath)) {
                $_SESSION['success'] = "File backup berhasil dihapus";
            } else {
                $_SESSION['error'] = "Gagal menghapus file backup";
            }
        } else {
            $_SESSION['error'] = "File backup tidak ditemukan";
        }
    } else {
        $_SESSION['error'] = "Nama file backup tidak valid";
    }
} else {
    $_SESSION['error'] = "Parameter file tidak ditemukan";
}

// Redirect kembali ke halaman backup
header("Location: backup.php");
exit();
?> 