<?php
session_start();
require_once 'config/config.php';

if (!isset($_GET['id'])) {
    header("Location: view_uploads.php");
    exit();
}

$id_surat = $_GET['id'];

// Handle file replacement
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['replace_upload'])) {
    // Get SPPD number and date
    $get_surat = mysqli_query($conn, "SELECT no_sppd, tanggal_surat FROM surat_tugas WHERE id_surat = $id_surat");
    $surat_data = mysqli_fetch_assoc($get_surat);
    
    // Extract number from SPPD (chars 5-8)
    $sppd_number = substr($surat_data['no_sppd'], 4, 4);
    
    // Get month and year from tanggal_surat
    $bulan = date('m', strtotime($surat_data['tanggal_surat']));
    $tahun = date('Y', strtotime($surat_data['tanggal_surat']));
    
    // Get file extension
    $fileType = strtolower(pathinfo($_FILES["newFile"]["name"], PATHINFO_EXTENSION));
    
    // Create new filename
    $newFileName = "SPPD_" . $sppd_number . "_" . $bulan . "_" . $tahun . "." . $fileType;
    $target_file = "uploads/" . $newFileName;
    
    $uploadOk = 1;

    // Check file size (50MB max)
    if ($_FILES["newFile"]["size"] > 50000000) {
        $_SESSION['error'] = "Maaf, ukuran file terlalu besar (maksimal 50MB).";
        $uploadOk = 0;
    }

    // Allow certain file formats
    if($fileType != "jpg" && $fileType != "png" && $fileType != "jpeg"
    && $fileType != "gif" && $fileType != "pdf" ) {
        $_SESSION['error'] = "Maaf, hanya file JPG, JPEG, PNG, GIF, & PDF yang diperbolehkan.";
        $uploadOk = 0;
    }

    if ($uploadOk == 1) {
        // Get old file
        $get_old_file = mysqli_query($conn, "SELECT file_name FROM file_uploads WHERE id_surat = $id_surat");
        $old_file_data = mysqli_fetch_assoc($get_old_file);
        $old_file = $old_file_data['file_name'];

        // Delete old file if exists
        if (file_exists($old_file)) {
            unlink($old_file);
        }

        if (move_uploaded_file($_FILES["newFile"]["tmp_name"], $target_file)) {
            // Update database with new file
            $update_query = "UPDATE file_uploads SET file_name = ? WHERE id_surat = ?";
            $stmt = mysqli_prepare($conn, $update_query);
            mysqli_stmt_bind_param($stmt, "si", $target_file, $id_surat);
            mysqli_stmt_execute($stmt);

            $_SESSION['success'] = "File berhasil diganti dengan: " . $newFileName;
        } else {
            $_SESSION['error'] = "Maaf, terjadi kesalahan saat mengganti file.";
        }
    }
    
    header("Location: detail_upload.php?id=" . $id_surat);
    exit();
}

// Fetch SPPD details
$query = "SELECT st.id_surat, st.no_sppd, st.maksud, st.tanggal_surat, fu.file_name,
          DATE_FORMAT(st.tanggal_surat, '%d-%m-%Y') as formatted_date
          FROM surat_tugas st 
          INNER JOIN file_uploads fu ON st.id_surat = fu.id_surat 
          WHERE st.id_surat = ?";
          
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_assoc($result);

if (!$data) {
    header("Location: view_uploads.php");
    exit();
}

$file_name = basename($data['file_name']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Upload SPPD - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <?php include 'includes/header.php' ?>
    
    <style>
        body {
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        
        .card-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border-radius: 15px 15px 0 0 !important;
            padding: 20px;
            border: none;
        }
        
        .card-header h5 {
            color: white;
            font-weight: 600;
            margin: 0;
            font-size: 1.25rem;
        }

        .home-section {
            background: linear-gradient(135deg,rgb(231, 255, 255) 0%,rgb(236, 255, 246) 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .preview-container {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }

        .preview-frame {
            width: 100%;
            height: 600px;
            border: 1px solid #dee2e6;
            border-radius: 4px;
        }

        .info-item {
            margin-bottom: 15px;
        }

        .info-label {
            font-weight: 600;
            color: #0f172a;
        }

        .info-value {
            color: #475569;
        }

        .btn-back {
            background: linear-gradient(135deg, #94a3b8 0%, #64748b 100%);
            color: white;
            border: none;
            margin-right: 10px;
        }

        .btn-back:hover {
            background: linear-gradient(135deg, #64748b 0%, #475569 100%);
            color: white;
        }

        .btn-replace {
            background: linear-gradient(135deg, #f43f5e 0%, #e11d48 100%);
            color: white;
            border: none;
        }

        .btn-replace:hover {
            background: linear-gradient(135deg, #e11d48 0%, #be123c 100%);
            color: white;
        }
    </style>
</head>
<body>
    <?php include 'includes/sidebar.php' ?>
    
    <section class="home-section">
        <div class="container mt-4">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Detail Upload SPPD</h5>
                </div>
                <div class="card-body">
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?= $_SESSION['success'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php unset($_SESSION['success']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?= $_SESSION['error'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-item">
                                <div class="info-label">Nomor SPPD</div>
                                <div class="info-value"><?= htmlspecialchars($data['no_sppd']) ?></div>
                            </div>
                            <div class="info-item">
                                <div class="info-label">Maksud</div>
                                <div class="info-value"><?= htmlspecialchars($data['maksud']) ?></div>
                            </div>
                            <div class="info-item">
                                <div class="info-label">Tanggal</div>
                                <div class="info-value"><?= $data['formatted_date'] ?></div>
                            </div>
                            <div class="info-item">
                                <div class="info-label">Nama File</div>
                                <div class="info-value"><?= $file_name ?></div>
                            </div>
                            <div class="mt-4">
                                <a href="upload.php" class="btn btn-back">
                                    <i class="bi bi-arrow-left"></i> Kembali
                                </a>
                                <button type="button" class="btn btn-replace" data-bs-toggle="modal" data-bs-target="#replaceModal">
                                    <i class="bi bi-arrow-repeat"></i> Ganti File
                                </button>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="preview-container">
                                <iframe src="<?= $data['file_name'] ?>" class="preview-frame"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Replace Modal -->
    <div class="modal fade" id="replaceModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ganti File SPPD</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <input type="hidden" name="replace_upload" value="1">
                        
                        <div class="mb-3">
                            <label class="form-label">File Saat Ini</label>
                            <input type="text" class="form-control" value="<?= $file_name ?>" readonly>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">File Baru</label>
                            <input type="file" class="form-control" name="newFile" required>
                            <div class="form-text">Format: JPG, JPEG, PNG, GIF, PDF (Maks. 50MB)</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-replace">Ganti File</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</body>
</html> 