<?php
session_start();
require_once 'config/config.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;

// Cek login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Clear any previous output
ob_clean();
ob_start();

// Query untuk mengambil data
$query = "SELECT 
    p.nama_pegawai,
    p.nip,
    p.golongan,
    p.jabatan,
    st.no_surat,
    st.jenis_surat,
    st.no_sppd,
    st.maksud,
    COALESCE(dst.tujuan_pegawai, st.tujuan) as tujuan,
    st.tempat_kegiatan,
    COALESCE(rbp.tanggal_berangkat, st.tanggal_berangkat) as tanggal_berangkat,
    COALESCE(rbp.tanggal_kembali, st.tanggal_kembali) as tanggal_kembali,
    u.username as pembuat,
    u.bidang as bidang_pembuat,
    st.created_at,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.uang_harian')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.uang_harian'))) as uang_harian,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.biaya_jarak')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.jarak')) * 10000) as biaya_jarak,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.representatif')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.representatif'))) as uang_representatif,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.uang_diklat')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.uang_diklat'))) as uang_diklat,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.transport')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.transport'))) as transport,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.transport_dalam')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.transport_dalam'))) as transport_dalam,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.transport_luar')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.transport_luar'))) as transport_luar,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.akomodasi')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.akomodasi'))) as akomodasi,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.pesawat_berangkat')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.pesawat_berangkat'))) as biaya_pesawat_berangkat,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbp.biaya_detail, '$.pesawat_kembali')), JSON_UNQUOTE(JSON_EXTRACT(rb.biaya_detail, '$.pesawat_kembali'))) as biaya_pesawat_kembali,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbrp.rincian_riil, '$[0].jumlah')), JSON_UNQUOTE(JSON_EXTRACT(rbr.jumlah, '$'))) as biaya_riil,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbrp.rincian_riil, '$[0].uraian')), rbr.uraian) as uraian_riil,
    COALESCE(JSON_UNQUOTE(JSON_EXTRACT(rbrp.rincian_riil, '$[0].keterangan')), rbr.keterangan) as keterangan_riil,
    COALESCE(rbrp.total_riil, rbr.jumlah) as total_riil
FROM pegawai p
JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai
JOIN surat_tugas st ON dst.id_surat = st.id_surat
JOIN users u ON st.created_by = u.id
LEFT JOIN rincian_biaya_perorangan rbp ON dst.id_surat = rbp.id_surat AND dst.id_pegawai = rbp.id_pegawai
LEFT JOIN rincian_biaya rb ON st.id_surat = rb.id_surat
LEFT JOIN rincian_biaya_riil_perorangan rbrp ON dst.id_surat = rbrp.id_surat AND dst.id_pegawai = rbrp.id_pegawai
LEFT JOIN rincian_biaya_riil rbr ON st.id_surat = rbr.id_surat AND (rbr.id_pegawai IS NULL OR rbr.id_pegawai = dst.id_pegawai)
ORDER BY p.nama_pegawai ASC, st.tanggal_surat DESC";

$result = $conn->query($query);

// Buat spreadsheet baru
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Tambahkan judul
$sheet->insertNewRowBefore(1, 2);
$sheet->mergeCells('A1:AE1');
$sheet->setCellValue('A1', 'DAFTAR RINCIAN BIAYA PERJALANAN DINAS PER PEGAWAI');

// Style untuk judul
$titleStyle = [
    'font' => [
        'bold' => true,
        'size' => 14,
        'color' => ['rgb' => '000000'],
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER,
    ],
];
$sheet->getStyle('A1')->applyFromArray($titleStyle);
$sheet->getRowDimension(1)->setRowHeight(30);

// Set judul kolom (sekarang di baris 3 karena penambahan judul)
$columns = [
    'A' => 'No',
    'B' => 'Nama Pegawai',
    'C' => 'NIP',
    'D' => 'Golongan',
    'E' => 'Jabatan',
    'F' => 'No. Surat',
    'G' => 'Jenis Surat',
    'H' => 'No. SPPD',
    'I' => 'Maksud',
    'J' => 'Tujuan',
    'K' => 'Tempat Kegiatan',
    'L' => 'Tanggal Berangkat',
    'M' => 'Tanggal Kembali',
    'N' => 'Jumlah Hari',
    'O' => 'Uang Harian',
    'P' => 'Biaya Jarak',
    'Q' => 'Representatif',
    'R' => 'Uang Diklat',
    'S' => 'Transport',
    'T' => 'Transport Dalam',
    'U' => 'Transport Luar',
    'V' => 'Akomodasi',
    'W' => 'Pesawat (Berangkat)',
    'X' => 'Pesawat (Kembali)',
    'Y' => 'Biaya Riil',
    'Z' => 'Uraian Riil',
    'AA' => 'Keterangan Riil',
    'AB' => 'Total Riil',
    'AC' => 'Total Biaya Per Pegawai',
    'AD' => 'Pembuat',
    'AE' => 'Bidang'
];

// Tulis header
foreach ($columns as $column => $header) {
    $sheet->setCellValue($column . '3', $header);
}

// Style header
$headerStyle = [
    'font' => [
        'bold' => true,
        'color' => ['rgb' => 'FFFFFF'],
    ],
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => '0EA5E9'],
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER,
        'wrapText' => true,
    ],
    'borders' => [
        'allBorders' => [
            'borderStyle' => Border::BORDER_THIN,
        ],
    ],
];

$sheet->getStyle('A3:AE3')->applyFromArray($headerStyle);

// Tulis data
$row = 4;
$no = 1;
while ($data = $result->fetch_assoc()) {
    // Hitung jumlah hari
    $tgl_berangkat = new DateTime($data['tanggal_berangkat']);
    $tgl_kembali = new DateTime($data['tanggal_kembali']);
    $selisih = $tgl_berangkat->diff($tgl_kembali);
    $jumlah_hari = $selisih->days + 1;

    $sheet->setCellValue('A' . $row, $no);
    $sheet->setCellValue('B' . $row, $data['nama_pegawai']);
    $sheet->setCellValue('C' . $row, $data['nip']);
    $sheet->setCellValue('D' . $row, $data['golongan']);
    $sheet->setCellValue('E' . $row, $data['jabatan']);
    $sheet->setCellValue('F' . $row, $data['no_surat']);
    $sheet->setCellValue('G' . $row, $data['jenis_surat']);
    $sheet->setCellValue('H' . $row, $data['no_sppd']);
    $sheet->setCellValue('I' . $row, $data['maksud']);
    $sheet->setCellValue('J' . $row, $data['tujuan']);
    $sheet->setCellValue('K' . $row, $data['tempat_kegiatan']);
    $sheet->setCellValue('L' . $row, date('d/m/Y', strtotime($data['tanggal_berangkat'])));
    $sheet->setCellValue('M' . $row, date('d/m/Y', strtotime($data['tanggal_kembali'])));
    $sheet->setCellValue('N' . $row, $jumlah_hari);
    
    // Set nilai numerik untuk kolom biaya
    $sheet->setCellValue('O' . $row, (float)$data['uang_harian']);
    $sheet->setCellValue('P' . $row, (float)$data['biaya_jarak']);
    $sheet->setCellValue('Q' . $row, (float)$data['uang_representatif']);
    $sheet->setCellValue('R' . $row, (float)$data['uang_diklat']);
    $sheet->setCellValue('S' . $row, (float)$data['transport']);
    $sheet->setCellValue('T' . $row, (float)$data['transport_dalam']);
    $sheet->setCellValue('U' . $row, (float)$data['transport_luar']);
    $sheet->setCellValue('V' . $row, (float)$data['akomodasi']);
    $sheet->setCellValue('W' . $row, (float)$data['biaya_pesawat_berangkat']);
    $sheet->setCellValue('X' . $row, (float)$data['biaya_pesawat_kembali']);
    $sheet->setCellValue('Y' . $row, (float)$data['biaya_riil']);
    $sheet->setCellValue('Z' . $row, $data['uraian_riil']);
    $sheet->setCellValue('AA' . $row, $data['keterangan_riil']);
    $sheet->setCellValue('AB' . $row, (float)$data['total_riil']);
    
    // Rumus total biaya per pegawai (tidak termasuk biaya riil)
    $sheet->setCellValue('AC' . $row, "=SUM(O{$row}:X{$row})");
    
    $sheet->setCellValue('AD' . $row, $data['pembuat']);
    $sheet->setCellValue('AE' . $row, $data['bidang_pembuat']);

    $row++;
    $no++;
}

// Set format angka untuk kolom biaya
$lastRow = $row - 1;
$sheet->getStyle('O2:AC' . $lastRow)->getNumberFormat()->setFormatCode('#,##0');

// Tambahkan total keseluruhan
$row = $lastRow + 1;
$sheet->setCellValue('A' . $row, 'Total Keseluruhan:');
$sheet->mergeCells('A' . $row . ':N' . $row);

// Tambahkan subtotal untuk setiap kolom biaya
foreach (range('O', 'Y') as $col) {
    $sheet->setCellValue($col . $row, "=SUM({$col}2:{$col}" . ($row-1) . ")");
}

// Total keseluruhan di kolom AC
$sheet->setCellValue('AC' . $row, "=SUM(AC2:AC" . ($row-1) . ")");

// Style untuk total
$totalStyle = [
    'font' => [
        'bold' => true,
        'color' => ['rgb' => 'FFFFFF'],
    ],
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => '0EA5E9'],
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_RIGHT,
    ],
];

$sheet->getStyle('A' . $row . ':AE' . $row)->applyFromArray($totalStyle);
$sheet->getStyle('O' . $row . ':AC' . $row)->getNumberFormat()->setFormatCode('#,##0');

// Auto-size columns
foreach (range('A', 'Z') as $column) {
    $sheet->getColumnDimension($column)->setAutoSize(true);
}
foreach (range('A', 'E') as $column) {
    $sheet->getColumnDimension('A' . $column)->setAutoSize(true);
}

// Set style untuk seluruh data
$styleArray = [
    'borders' => [
        'allBorders' => [
            'borderStyle' => Border::BORDER_THIN,
        ],
    ],
    'alignment' => [
        'vertical' => Alignment::VERTICAL_CENTER,
    ],
];
$sheet->getStyle('A1:AE' . $row)->applyFromArray($styleArray);

// Freeze pane
$sheet->freezePane('A4');

// Set nama sheet
$sheet->setTitle('Rincian Biaya Per Pegawai');

// Pastikan tidak ada output sebelumnya
if (ob_get_length()) ob_end_clean();

// Set header untuk download dengan nama file yang includes tanggal
$today = date('d-m-Y');
$filename = "Rincian_Biaya_Per_Pegawai_" . $today . ".xlsx";
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');
header('Cache-Control: max-age=1');
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');

// Tulis file excel
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit; 