<?php
require_once 'config/database.php';

// Buat tabel pengaturan jika belum ada
$create_table_sql = "CREATE TABLE IF NOT EXISTS pengaturan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kode VARCHAR(50) NOT NULL UNIQUE,
    nilai TEXT,
    keterangan TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;";

if (mysqli_query($conn, $create_table_sql)) {
    echo "Tabel pengaturan berhasil dibuat atau sudah ada.<br>";
} else {
    echo "Error membuat tabel: " . mysqli_error($conn) . "<br>";
}

// Tambahkan pengaturan default
$default_settings = [
    ['maintenance_mode', '0', 'Mode maintenance sistem (1=aktif, 0=nonaktif)'],
    ['site_title', 'Sistem SPPD', 'Judul website'],
    ['per_page', '10', 'Jumlah item per halaman'],
    ['timezone', 'Asia/Makassar', 'Zona waktu sistem'],
    ['backup_retention', '30', 'Lama penyimpanan backup dalam hari'],
    ['allow_registration', '1', 'Izinkan pendaftaran user baru (1=ya, 0=tidak)']
];

// Masukkan pengaturan default
$insert_sql = "INSERT IGNORE INTO pengaturan (kode, nilai, keterangan) VALUES (?, ?, ?)";
$stmt = mysqli_prepare($conn, $insert_sql);

foreach ($default_settings as $setting) {
    mysqli_stmt_bind_param($stmt, "sss", $setting[0], $setting[1], $setting[2]);
    if (mysqli_stmt_execute($stmt)) {
        echo "Berhasil menambahkan pengaturan: {$setting[0]}<br>";
    } else {
        echo "Error menambahkan pengaturan {$setting[0]}: " . mysqli_error($conn) . "<br>";
    }
}

mysqli_stmt_close($stmt);
mysqli_close($conn);

echo "<br>Selesai memperbaiki pengaturan sistem.<br>";
echo "<a href='dashboard.php'>Kembali ke Dashboard</a>";
?> 