<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Catch the Star - Mini Game</title>
    <style>
        body {
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #1a237e 0%, #283593 50%, #3949ab 100%);
            font-family: 'Poppins', sans-serif;
        }
        
        .game-container {
            text-align: center;
        }
        
        canvas {
            border: 2px solid #fff;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(255, 255, 255, 0.2);
        }
        
        .score-board {
            color: white;
            font-size: 24px;
            margin: 20px 0;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
            display: flex;
            justify-content: center;
            gap: 30px;
        }

        .lives {
            color: #ff4444;
        }
        
        .controls {
            color: white;
            margin-top: 20px;
            padding: 15px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
        }
        
        .btn-back {
            display: inline-block;
            padding: 10px 20px;
            background: #00BCD4;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
            transition: all 0.3s ease;
        }
        
        .btn-back:hover {
            background: #0097A7;
            transform: translateY(-2px);
        }

        .btn-restart {
            display: none;
            padding: 10px 20px;
            background: #4CAF50;
            color: white;
            text-decoration: none;
            border: none;
            border-radius: 5px;
            margin-top: 20px;
            cursor: pointer;
            font-family: 'Poppins', sans-serif;
            transition: all 0.3s ease;
        }

        .btn-restart:hover {
            background: #45a049;
            transform: translateY(-2px);
        }

        .game-over {
            display: none;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="game-container">
        <div class="score-board">
            <div>Score: <span id="score">0</span></div>
            <div class="lives">Lives: <span id="lives">3</span></div>
        </div>
        <canvas id="gameCanvas" width="400" height="600"></canvas>
        <div class="controls">
            Gunakan ← → untuk menggerakkan pemain<br>
            Tangkap bintang untuk mendapatkan poin!
            <br>
            semangat bagawian kakawanan 💪💪💪💪💪💪💪
        </div>
        <div class="game-over" id="gameOver">
            <h2>Game Over!</h2>
            <p>Score Akhir: <span id="finalScore">0</span></p>
            <button class="btn-restart" id="restartButton">Main Lagi</button>
        </div>
        <a href="../dashboard.php" class="btn-back">Kembali ke Dashboard</a>
    </div>

    <script>
        const canvas = document.getElementById('gameCanvas');
        const ctx = canvas.getContext('2d');
        const scoreElement = document.getElementById('score');
        const livesElement = document.getElementById('lives');
        const gameOverElement = document.getElementById('gameOver');
        const finalScoreElement = document.getElementById('finalScore');
        const restartButton = document.getElementById('restartButton');
        
        // Game objects
        const player = {
            x: canvas.width / 2,
            y: canvas.height - 30,
            width: 50,
            height: 10,
            speed: 5,
            color: '#00BCD4'
        };
        
        const star = {
            x: Math.random() * (canvas.width - 20),
            y: 0,
            size: 20,
            speed: 3,
            color: '#FFD700'
        };
        
        let score = 0;
        let lives = 3;
        let gameLoop;
        let rightPressed = false;
        let leftPressed = false;
        let gameActive = true;
        
        // Event listeners
        document.addEventListener('keydown', keyDownHandler);
        document.addEventListener('keyup', keyUpHandler);
        restartButton.addEventListener('click', restartGame);
        
        function keyDownHandler(e) {
            if(!gameActive) return;
            if(e.key === 'Right' || e.key === 'ArrowRight') {
                rightPressed = true;
            }
            else if(e.key === 'Left' || e.key === 'ArrowLeft') {
                leftPressed = true;
            }
        }
        
        function keyUpHandler(e) {
            if(e.key === 'Right' || e.key === 'ArrowRight') {
                rightPressed = false;
            }
            else if(e.key === 'Left' || e.key === 'ArrowLeft') {
                leftPressed = false;
            }
        }
        
        function drawPlayer() {
            ctx.beginPath();
            ctx.rect(player.x, player.y, player.width, player.height);
            ctx.fillStyle = player.color;
            ctx.fill();
            ctx.closePath();
        }
        
        function drawStar() {
            ctx.beginPath();
            const spikes = 5;
            const outerRadius = star.size;
            const innerRadius = star.size / 2;
            
            for(let i = 0; i < spikes * 2; i++) {
                const radius = i % 2 === 0 ? outerRadius : innerRadius;
                const angle = (i * Math.PI) / spikes;
                const x = star.x + Math.cos(angle) * radius;
                const y = star.y + Math.sin(angle) * radius;
                
                if(i === 0) {
                    ctx.moveTo(x, y);
                } else {
                    ctx.lineTo(x, y);
                }
            }
            
            ctx.fillStyle = star.color;
            ctx.fill();
            ctx.closePath();
        }
        
        function movePlayer() {
            if(rightPressed && player.x < canvas.width - player.width) {
                player.x += player.speed;
            }
            else if(leftPressed && player.x > 0) {
                player.x -= player.speed;
            }
        }
        
        function moveStar() {
            star.y += star.speed;
            
            // Check collision with player
            if(star.y + star.size > player.y && 
               star.x > player.x - star.size && 
               star.x < player.x + player.width + star.size) {
                score += 10;
                scoreElement.textContent = score;
                resetStar();
                increaseSpeed();
            }
            
            // Check if star is missed
            if(star.y > canvas.height) {
                lives--;
                livesElement.textContent = lives;
                if(lives <= 0) {
                    gameOver();
                }
                resetStar();
            }
        }
        
        function resetStar() {
            star.y = 0;
            star.x = Math.random() * (canvas.width - 20);
        }
        
        function increaseSpeed() {
            star.speed += 0.2;
            player.speed += 0.1;
        }
        
        function gameOver() {
            gameActive = false;
            clearInterval(gameLoop);
            gameOverElement.style.display = 'block';
            restartButton.style.display = 'inline-block';
            finalScoreElement.textContent = score;
        }

        function restartGame() {
            // Reset game state
            score = 0;
            lives = 3;
            star.speed = 3;
            player.speed = 5;
            player.x = canvas.width / 2;
            gameActive = true;
            
            // Reset UI
            scoreElement.textContent = score;
            livesElement.textContent = lives;
            gameOverElement.style.display = 'none';
            restartButton.style.display = 'none';
            
            // Start new game loop
            if(gameLoop) clearInterval(gameLoop);
            gameLoop = setInterval(draw, 16);
        }
        
        function draw() {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            
            drawPlayer();
            drawStar();
            
            if(gameActive) {
                movePlayer();
                moveStar();
            }
        }
        
        // Start game loop
        gameLoop = setInterval(draw, 16);
    </script>
</body>
</html> 