<?php
include '../includes/header.php';
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">Rubik's Cube Game<br>Maaf masih error wkwk</h5>
                    
                </div>
                <div class="card-body">
                    <div class="rubik-container">
                        <div id="rubik-cube"></div>
                        <div class="controls mt-4">
                            <div class="d-flex justify-content-center mb-3">
                                <button class="btn btn-primary me-2" onclick="scrambleCube()">Acak Kubus</button>
                                <button class="btn btn-success" onclick="resetCube()">Reset</button>
                            </div>
                            
                            <!-- Kontrol Rotasi Sisi -->
                            <div class="rotation-controls">
                                <!-- Sisi Depan (Front) -->
                                <div class="control-group mb-2">
                                    <label class="control-label">Sisi Depan:</label>
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary" onclick="rotateFace('front', -1)">↺</button>
                                        <button class="btn btn-outline-primary" onclick="rotateFace('front', 1)">↻</button>
                                    </div>
                                </div>
                                
                                <!-- Sisi Atas (Up) -->
                                <div class="control-group mb-2">
                                    <label class="control-label">Sisi Atas:</label>
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary" onclick="rotateFace('up', -1)">↺</button>
                                        <button class="btn btn-outline-primary" onclick="rotateFace('up', 1)">↻</button>
                                    </div>
                                </div>
                                
                                <!-- Sisi Kanan (Right) -->
                                <div class="control-group mb-2">
                                    <label class="control-label">Sisi Kanan:</label>
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary" onclick="rotateFace('right', -1)">↺</button>
                                        <button class="btn btn-outline-primary" onclick="rotateFace('right', 1)">↻</button>
                                    </div>
                                </div>

                                <!-- Sisi Belakang (Back) -->
                                <div class="control-group mb-2">
                                    <label class="control-label">Sisi Belakang:</label>
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary" onclick="rotateFace('back', -1)">↺</button>
                                        <button class="btn btn-outline-primary" onclick="rotateFace('back', 1)">↻</button>
                                    </div>
                                </div>

                                <!-- Sisi Bawah (Down) -->
                                <div class="control-group mb-2">
                                    <label class="control-label">Sisi Bawah:</label>
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary" onclick="rotateFace('down', -1)">↺</button>
                                        <button class="btn btn-outline-primary" onclick="rotateFace('down', 1)">↻</button>
                                    </div>
                                </div>

                                <!-- Sisi Kiri (Left) -->
                                <div class="control-group mb-2">
                                    <label class="control-label">Sisi Kiri:</label>
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary" onclick="rotateFace('left', -1)">↺</button>
                                        <button class="btn btn-outline-primary" onclick="rotateFace('left', 1)">↻</button>
                                    </div>
                                </div>
                            </div>

                            <!-- Kontrol Rotasi Seluruh Kubus -->
                            <div class="cube-rotation-controls mt-3">
                                <label class="control-label">Rotasi Kubus:</label>
                                <div class="d-flex justify-content-center gap-2">
                                    <button class="btn btn-outline-secondary" onclick="rotateCube('y', -1)">⟲ Horizontal</button>
                                    <button class="btn btn-outline-secondary" onclick="rotateCube('y', 1)">⟳ Horizontal</button>
                                    <button class="btn btn-outline-secondary" onclick="rotateCube('x', -1)">⟲ Vertikal</button>
                                    <button class="btn btn-outline-secondary" onclick="rotateCube('x', 1)">⟳ Vertikal</button>
                                </div>
                            </div>
                        </div>

                        
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.rubik-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 20px;
}

#rubik-cube {
    width: 300px;
    height: 300px;
    margin-bottom: 20px;
    border-radius: 8px;
    overflow: hidden;
    background: rgba(0, 0, 0, 0.05);
}

#rubik-cube canvas {
    width: 100% !important;
    height: 100% !important;
}

.controls {
    width: 100%;
    max-width: 600px;
}

.rotation-controls {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
}

.control-group {
    display: flex;
    align-items: center;
    gap: 10px;
}

.control-label {
    min-width: 100px;
    margin-bottom: 0;
    font-weight: 500;
}

.btn-group {
    display: flex;
    gap: 5px;
}

.instructions {
    max-width: 400px;
    margin: 0 auto;
    text-align: left;
    padding: 15px;
    background: rgba(0, 0, 0, 0.03);
    border-radius: 8px;
}

.instructions ul {
    padding-left: 20px;
    margin-bottom: 0;
}

.instructions li {
    margin-bottom: 8px;
}

.instructions li:last-child {
    margin-bottom: 0;
}

@media (max-width: 768px) {
    .control-group {
        flex-direction: column;
        align-items: stretch;
        text-align: center;
    }

    .control-label {
        margin-bottom: 5px;
    }

    .btn-group {
        justify-content: center;
    }

    .cube-rotation-controls .d-flex {
        flex-wrap: wrap;
        justify-content: center;
    }
}
</style>

<!-- Three.js library -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
<!-- OrbitControls untuk kontrol rotasi yang lebih baik -->
<script src="https://cdn.jsdelivr.net/npm/three@0.128.0/examples/js/controls/OrbitControls.js"></script>
<!-- TWEEN.js untuk animasi yang lebih halus -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/tween.js/18.6.4/tween.umd.js"></script>
<!-- Rubik's Cube game script -->
<script>
let scene, camera, renderer, cube, controls;
const cubelets = [];
const ROTATION_DURATION = 500; // milliseconds
let isAnimating = false;

function init() {
    scene = new THREE.Scene();
    scene.background = new THREE.Color(0xf0f0f0);
    
    camera = new THREE.PerspectiveCamera(75, 1, 0.1, 1000);
    camera.position.set(4, 4, 4);
    
    renderer = new THREE.WebGLRenderer({ antialias: true });
    renderer.setSize(300, 300);
    renderer.setPixelRatio(window.devicePixelRatio);
    document.getElementById('rubik-cube').appendChild(renderer.domElement);

    controls = new THREE.OrbitControls(camera, renderer.domElement);
    controls.enableDamping = true;
    controls.dampingFactor = 0.05;
    controls.screenSpacePanning = false;
    controls.minDistance = 4;
    controls.maxDistance = 10;
    controls.maxPolarAngle = Math.PI;

    createRubiksCube();

    const ambientLight = new THREE.AmbientLight(0xffffff, 0.6);
    scene.add(ambientLight);

    const directionalLight = new THREE.DirectionalLight(0xffffff, 0.8);
    directionalLight.position.set(10, 20, 10);
    scene.add(directionalLight);

    animate();
}

function createRubiksCube() {
    cube = new THREE.Group();
    
    for(let x = -1; x <= 1; x++) {
        for(let y = -1; y <= 1; y++) {
            for(let z = -1; z <= 1; z++) {
                const geometry = new THREE.BoxGeometry(0.95, 0.95, 0.95);
                const materials = [];
                
                const colors = [
                    0xff0000, // Right (Red)
                    0xff8c00, // Left (Orange)
                    0xffffff, // Top (White)
                    0xffff00, // Bottom (Yellow)
                    0x00ff00, // Front (Green)
                    0x0000ff  // Back (Blue)
                ];
                
                for(let i = 0; i < 6; i++) {
                    const material = new THREE.MeshPhongMaterial({
                        color: colors[i],
                        shininess: 30,
                        specular: 0x444444
                    });
                    materials.push(material);
                }
                
                const cubelet = new THREE.Mesh(geometry, materials);
                cubelet.position.set(x, y, z);
                cubelet.userData.originalPosition = { x, y, z };
                cubelet.userData.currentPosition = { x, y, z };
                
                const edgesGeometry = new THREE.EdgesGeometry(geometry);
                const edgesMaterial = new THREE.LineBasicMaterial({ color: 0x000000, linewidth: 2 });
                const edges = new THREE.LineSegments(edgesGeometry, edgesMaterial);
                cubelet.add(edges);
                
                cube.add(cubelet);
                cubelets.push(cubelet);
            }
        }
    }
    
    scene.add(cube);
}

function rotateFace(face, direction) {
    if (isAnimating) return;
    isAnimating = true;

    const rotationAxis = new THREE.Vector3();
    const selectedCubelets = [];

    switch(face) {
        case 'front':
            rotationAxis.set(0, 0, 1);
            cubelets.forEach(cubelet => {
                if (Math.abs(cubelet.position.z - 1) < 0.1) {
                    selectedCubelets.push(cubelet);
                }
            });
            break;
        case 'back':
            rotationAxis.set(0, 0, -1);
            cubelets.forEach(cubelet => {
                if (Math.abs(cubelet.position.z + 1) < 0.1) {
                    selectedCubelets.push(cubelet);
                }
            });
            break;
        case 'up':
            rotationAxis.set(0, 1, 0);
            cubelets.forEach(cubelet => {
                if (Math.abs(cubelet.position.y - 1) < 0.1) {
                    selectedCubelets.push(cubelet);
                }
            });
            break;
        case 'down':
            rotationAxis.set(0, -1, 0);
            cubelets.forEach(cubelet => {
                if (Math.abs(cubelet.position.y + 1) < 0.1) {
                    selectedCubelets.push(cubelet);
                }
            });
            break;
        case 'right':
            rotationAxis.set(1, 0, 0);
            cubelets.forEach(cubelet => {
                if (Math.abs(cubelet.position.x - 1) < 0.1) {
                    selectedCubelets.push(cubelet);
                }
            });
            break;
        case 'left':
            rotationAxis.set(-1, 0, 0);
            cubelets.forEach(cubelet => {
                if (Math.abs(cubelet.position.x + 1) < 0.1) {
                    selectedCubelets.push(cubelet);
                }
            });
            break;
    }

    const rotationMatrix = new THREE.Matrix4();
    const targetAngle = direction * Math.PI / 2;
    
    new TWEEN.Tween({ rotation: 0 })
        .to({ rotation: targetAngle }, ROTATION_DURATION)
        .easing(TWEEN.Easing.Quadratic.InOut)
        .onUpdate(function(obj) {
            rotationMatrix.makeRotationAxis(rotationAxis, obj.rotation);
            selectedCubelets.forEach(cubelet => {
                cubelet.position.applyMatrix4(rotationMatrix);
                cubelet.rotation.setFromRotationMatrix(
                    rotationMatrix.multiply(cubelet.matrix)
                );
            });
        })
        .onComplete(() => {
            // Update current positions
            selectedCubelets.forEach(cubelet => {
                cubelet.updateMatrix();
                const position = cubelet.position;
                cubelet.userData.currentPosition = {
                    x: Math.round(position.x),
                    y: Math.round(position.y),
                    z: Math.round(position.z)
                };
            });
            isAnimating = false;
        })
        .start();
}

function rotateCube(axis, direction) {
    if (isAnimating) return;
    isAnimating = true;

    const rotationAxis = new THREE.Vector3();
    switch(axis) {
        case 'x':
            rotationAxis.set(1, 0, 0);
            break;
        case 'y':
            rotationAxis.set(0, 1, 0);
            break;
        case 'z':
            rotationAxis.set(0, 0, 1);
            break;
    }

    const targetAngle = direction * Math.PI / 2;
    
    new TWEEN.Tween({ rotation: 0 })
        .to({ rotation: targetAngle }, ROTATION_DURATION)
        .easing(TWEEN.Easing.Quadratic.InOut)
        .onUpdate(function(obj) {
            cube.rotateOnAxis(rotationAxis, obj.rotation - this._object.rotation);
        })
        .onComplete(() => {
            isAnimating = false;
        })
        .start();
}

function scrambleCube() {
    if (isAnimating) return;

    const faces = ['front', 'back', 'up', 'down', 'right', 'left'];
    const moves = [];
    
    for(let i = 0; i < 20; i++) {
        const face = faces[Math.floor(Math.random() * faces.length)];
        const direction = Math.random() > 0.5 ? 1 : -1;
        moves.push({ face, direction });
    }

    let delay = 0;
    moves.forEach(move => {
        setTimeout(() => {
            rotateFace(move.face, move.direction);
        }, delay);
        delay += ROTATION_DURATION + 100;
    });
}

function resetCube() {
    if (isAnimating) return;
    
    cubelets.forEach(cubelet => {
        const orig = cubelet.userData.originalPosition;
        cubelet.position.set(orig.x, orig.y, orig.z);
        cubelet.rotation.set(0, 0, 0);
        cubelet.userData.currentPosition = { ...orig };
    });
    
    cube.rotation.set(0, 0, 0);
    controls.reset();
}

function animate() {
    requestAnimationFrame(animate);
    TWEEN.update();
    controls.update();
    renderer.render(scene, camera);
}

function onWindowResize() {
    const container = document.getElementById('rubik-cube');
    const width = container.clientWidth;
    const height = container.clientHeight;
    
    camera.aspect = width / height;
    camera.updateProjectionMatrix();
    renderer.setSize(width, height);
}

window.addEventListener('resize', onWindowResize, false);
window.addEventListener('load', init);
</script>

<?php
include '../includes/footer.php';
?> 